/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer.waypoint;

import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.client.CarpetOrgAdditionClient;
import org.carpetorgaddition.client.renderer.WorldRenderer;
import org.carpetorgaddition.client.renderer.waypoint.WaypointRendererType;
import org.carpetorgaddition.client.util.ClientKeyBindingUtils;
import org.carpetorgaddition.client.util.ClientMessageUtils;
import org.carpetorgaddition.client.util.ClientRenderUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class WaypointRenderer
implements WorldRenderer {
    private final WaypointRendererType renderType;
    private final class_243 target;
    private final String worldId;
    private final long startTime = System.currentTimeMillis();
    private boolean fade = false;
    private long fadeTime = -1L;
    private boolean stop = false;
    private final long durationTime;

    public WaypointRenderer(WaypointRendererType renderType, class_243 target, String worldId, long durationTime) {
        this.renderType = renderType;
        this.target = target;
        this.worldId = worldId;
        this.durationTime = durationTime;
    }

    public WaypointRenderer(WaypointRendererType renderType, class_243 target, String worldId) {
        this(renderType, target, worldId, renderType.getDefaultDurationTime());
    }

    public WaypointRenderer(WaypointRendererType renderType, class_243 target, class_1937 world, long durationTime) {
        this(renderType, target, WorldUtils.getDimensionId(world), durationTime);
    }

    @Override
    public void render(WorldRenderContext renderContext) {
        if (ClientKeyBindingUtils.isPressed(CarpetOrgAdditionClient.CLEAR_WAYPOINT) && class_310.method_1551().field_1755 == null && this.renderType == WaypointRendererType.HIGHLIGHT) {
            this.setFade();
        }
        class_4587 matrixStack = renderContext.matrixStack();
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (camera == null) {
            return;
        }
        class_243 vec3d = this.getPos(client);
        if (vec3d == null) {
            return;
        }
        try {
            this.drawIcon(renderContext, matrixStack, vec3d, camera);
        }
        catch (RuntimeException e) {
            ClientMessageUtils.sendErrorMessage(e, "carpet.client.render.waypoint.error", new Object[0]);
            CarpetOrgAddition.LOGGER.error("\u6e32\u67d3{}\u8def\u5f84\u70b9\u65f6\u9047\u5230\u610f\u5916\u9519\u8bef", (Object)this.renderType.getLogName(), (Object)e);
            this.renderType.clear();
        }
    }

    @Nullable
    private class_243 getPos(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null || this.target == null || this.worldId == null) {
            return null;
        }
        String playerWorldId = WorldUtils.getDimensionId(player.method_37908());
        if (WorldUtils.equalsWorld(this.worldId, playerWorldId)) {
            return this.target;
        }
        class_4184 camera = client.field_1773.method_19418();
        if (WorldUtils.isOverworld(playerWorldId) && WorldUtils.isTheNether(this.worldId)) {
            return new class_243(this.target.method_10216() * 8.0, camera.method_19326().method_10214(), this.target.method_10215() * 8.0);
        }
        if (WorldUtils.isTheNether(playerWorldId) && WorldUtils.isOverworld(this.worldId)) {
            return new class_243(this.target.method_10216() / 8.0, camera.method_19326().method_10214(), this.target.method_10215() / 8.0);
        }
        return null;
    }

    private void drawIcon(WorldRenderContext context, class_4587 matrixStack, class_243 target, class_4184 camera) {
        class_243 cameraPos = camera.method_19326();
        class_243 offset = target.method_1020(cameraPos);
        int renderDistance = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 16;
        class_243 correctionVec3d = new class_243(offset.method_10216(), offset.method_10214(), offset.method_10215());
        if (correctionVec3d.method_1033() > (double)renderDistance) {
            correctionVec3d = correctionVec3d.method_1029().method_1021((double)renderDistance);
        }
        matrixStack.method_22903();
        matrixStack.method_22904(correctionVec3d.method_10216(), correctionVec3d.method_10214(), correctionVec3d.method_10215());
        float scale = this.renderType.getScale(correctionVec3d.method_1033(), this.startTime, this.durationTime, this.fade, this.fadeTime);
        if (scale <= 0.0f) {
            this.stop = true;
            return;
        }
        matrixStack.method_22905(scale, scale, scale);
        matrixStack.method_22907((Quaternionfc)new Quaternionf(-1.0f, 0.0f, 0.0f, 0.0f));
        matrixStack.method_22907((Quaternionfc)new Quaternionf().rotateY((float)(Math.PI / 180 * (double)(camera.method_19330() - 180.0f))));
        matrixStack.method_22907((Quaternionfc)new Quaternionf().rotateX((float)(Math.PI / 180 * (double)(-camera.method_19329()))));
        ClientRenderUtils.drawWaypoint(this.renderType.getIcon(), context);
        if (this.pointerPointing(camera, target)) {
            this.drawDistance(context, matrixStack, offset);
        }
        matrixStack.method_22909();
    }

    private void drawDistance(WorldRenderContext context, class_4587 matrixStack, class_243 offset) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        double distance = offset.method_1033();
        String formatted = distance >= 1000.0 ? "%.1fkm".formatted(distance / 1000.0) : "%.1fm".formatted(distance);
        class_5250 text = TextUtils.createText(formatted);
        if (WorldUtils.isDifferentWorld(this.worldId, WorldUtils.getDimensionId((class_1937)context.world()))) {
            text = TextUtils.toItalic(text);
        }
        int width = textRenderer.method_1727(formatted);
        float backgroundOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int opacity = (int)(backgroundOpacity * 255.0f) << 24;
        matrixStack.method_22903();
        matrixStack.method_22905(0.15f, 0.15f, 0.15f);
        textRenderer.method_27522((class_2561)text, (float)(-width) / 2.0f, 8.0f, -1, false, matrixStack.method_23760().method_23761(), context.consumers(), class_327.class_6415.field_33994, opacity, 1);
        matrixStack.method_22909();
    }

    private boolean pointerPointing(class_4184 camera, class_243 target) {
        float f = camera.method_19329() * ((float)Math.PI / 180);
        float g = -camera.method_19330() * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        class_243 vec3d = new class_243((double)(i * j), (double)(-k), (double)(h * j)).method_1029();
        class_243 vec3d2 = new class_243(target.method_10216() - camera.method_19326().method_10216(), target.method_10214() - camera.method_19326().method_10214(), target.method_10215() - camera.method_19326().method_10215());
        double d = vec3d2.method_1033();
        double e = vec3d.method_1026(vec3d2 = vec3d2.method_1029());
        return e > 0.999 - 0.025 / d;
    }

    public boolean equalsTarget(WaypointRenderer renderer) {
        return this.target.equals((Object)renderer.target) && WorldUtils.equalsWorld(this.worldId, renderer.worldId);
    }

    public class_243 getPos() {
        return this.target;
    }

    public WaypointRendererType getRenderType() {
        return this.renderType;
    }

    @Override
    public boolean shouldStop() {
        return this.stop;
    }

    public void setFade() {
        if (this.fade) {
            return;
        }
        this.fade = true;
        this.fadeTime = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.renderType == ((WaypointRenderer)o).renderType;
    }

    public int hashCode() {
        return this.renderType.hashCode();
    }
}

