/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.exception.CommandExecuteIOException;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.express.Express;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.provider.CommandProvider;
import org.carpetorgaddition.util.screen.ShipExpressScreenHandler;
import org.jetbrains.annotations.NotNull;

public class MailCommand
extends AbstractServerCommand {
    public MailCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandMail))).then(class_2170.method_9247((String)"ship").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::ship)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"receive").executes(this::receiveAll)).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(this.receiveSuggests(true)).executes(this::receive)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cancel").executes(this::cancelAll)).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(this.receiveSuggests(false)).executes(this::cancel)))).then(class_2170.method_9247((String)"list").executes(this::list))).then(class_2170.method_9247((String)"multiple").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::shipMultipleExpress))));
    }

    @NotNull
    private SuggestionProvider<class_2168> receiveSuggests(boolean recipient) {
        return (context, builder) -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return class_2172.method_9265(List.of(), (SuggestionsBuilder)builder);
            }
            ExpressManager manager = ServerComponentCoordinator.getManager((CommandContext<class_2168>)context).getExpressManager();
            List<String> list = manager.stream().filter(express -> recipient ? express.isRecipient(player) : express.isSender(player)).map(express -> Integer.toString(express.getId())).toList();
            return class_2172.method_9265(list, (SuggestionsBuilder)builder);
        };
    }

    private int ship(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
        class_3222 targetPlayer = CommandUtils.getArgumentPlayer(context);
        this.checkPlayer(sourcePlayer, targetPlayer);
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        ExpressManager manager = ServerComponentCoordinator.getManager(context).getExpressManager();
        try {
            manager.put(new Express(server, sourcePlayer, targetPlayer, manager.generateNumber()));
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
        return 1;
    }

    private int shipMultipleExpress(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
        class_3222 targetPlayer = CommandUtils.getArgumentPlayer(context);
        this.checkPlayer(sourcePlayer, targetPlayer);
        class_1277 inventory = new class_1277(27);
        class_747 screen = new class_747((i, inv, player) -> new ShipExpressScreenHandler(i, inv, sourcePlayer, targetPlayer, (class_1263)inventory), (class_2561)TextUtils.translate("carpet.commands.mail.multiple.gui", new Object[0]));
        sourcePlayer.method_17355((class_3908)screen);
        return 1;
    }

    private int receive(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        Express express = this.getExpress(context);
        if (express.isRecipient(player)) {
            try {
                express.receive();
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
            return 1;
        }
        throw CommandUtils.createException("carpet.commands.mail.receive.recipient", new Object[0]);
    }

    private int receiveAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        try {
            return ServerComponentCoordinator.getManager(context).getExpressManager().receiveAll(player);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
    }

    private int cancel(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        Express express = this.getExpress(context);
        if (express.isSender(player)) {
            try {
                express.cancel();
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
            return 1;
        }
        throw CommandUtils.createException("carpet.commands.mail.cancel.recipient", new Object[0]);
    }

    private int cancelAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        try {
            return ServerComponentCoordinator.getManager(context).getExpressManager().cancelAll(player);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
    }

    private int list(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ExpressManager manager = ServerComponentCoordinator.getManager(context).getExpressManager();
        List<Express> list = manager.stream().toList();
        if (list.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.mail.list.empty", new Object[0]);
        }
        list.forEach(express -> this.list(player, (Express)express));
        return list.size();
    }

    private void list(class_3222 player, Express express) {
        class_5250 text;
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        if (express.isRecipient(player)) {
            text = TextUtils.createText("[R]");
            TextUtils.command(text, CommandProvider.receiveExpress(express.getId()), null, class_124.field_1075, false);
            list.add(TextUtils.translate("carpet.commands.mail.list.receive", new Object[0]));
            list.add(TextUtils.createEmpty());
        } else if (express.isSender(player)) {
            text = TextUtils.createText("[C]");
            TextUtils.command(text, CommandProvider.cancelExpress(express.getId()), null, class_124.field_1075, false);
            list.add(TextUtils.translate("carpet.commands.mail.list.sending", new Object[0]));
            list.add(TextUtils.createEmpty());
        } else {
            text = TextUtils.createText("[?]");
        }
        list.add(TextUtils.translate("carpet.commands.mail.list.id", express.getId()));
        list.add(TextUtils.translate("carpet.commands.mail.list.sender", express.getSender()));
        list.add(TextUtils.translate("carpet.commands.mail.list.recipient", express.getRecipient()));
        list.add(TextUtils.translate("carpet.commands.mail.list.item", TextUtils.translate(express.getExpress().method_7909().method_7876(), new Object[0]), express.getExpress().method_7947()));
        list.add(TextUtils.translate("carpet.commands.mail.list.time", express.getTime()));
        text = TextUtils.hoverText((class_2561)text, (class_2561)TextUtils.appendList(list));
        MessageUtils.sendMessage(player, "carpet.commands.mail.list.each", express.getId(), express.getExpress().method_7954(), express.getSender(), express.getRecipient(), text);
    }

    @NotNull
    private Express getExpress(CommandContext<class_2168> context) throws CommandSyntaxException {
        int id;
        ExpressManager manager = ServerComponentCoordinator.getManager(context).getExpressManager();
        Optional<Express> optional = manager.binarySearch(id = IntegerArgumentType.getInteger(context, (String)"id"));
        if (optional.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.mail.receive.non_existent", id);
        }
        return optional.get();
    }

    private void checkPlayer(class_3222 sourcePlayer, class_3222 targetPlayer) throws CommandSyntaxException {
        if (CarpetOrgAddition.isDebugDevelopment()) {
            return;
        }
        if (sourcePlayer == targetPlayer || targetPlayer instanceof EntityPlayerMPFake) {
            throw CommandUtils.createException("carpet.commands.mail.check_player", new Object[0]);
        }
    }

    @Override
    public String getDefaultName() {
        return "mail";
    }
}

