/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.command.LocationsCommand;
import org.carpetorgaddition.periodic.PlayerComponentCoordinator;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.permission.PermissionLevel;
import org.carpetorgaddition.util.permission.PermissionManager;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.Waypoint;

public class NavigatorCommand
extends AbstractServerCommand {
    private static final String START_NAVIGATION = "carpet.commands.navigate.start_navigation";

    public NavigatorCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandNavigate))).then(class_2170.method_9247((String)"entity").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, false, "entity"))).then(class_2170.method_9247((String)"continue").executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, true, "entity")))))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, false, "player"))).then(class_2170.method_9247((String)"continue").executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, true, "player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"waypoint").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandLocations))).then(class_2170.method_9244((String)"waypoint", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).executes(this::navigateToWaypoint)))).then(class_2170.method_9247((String)"stop").executes(this::stopNavigate))).then(class_2170.method_9247((String)"uuid").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(this::navigateToEntityForUUID)))).then(class_2170.method_9247((String)"blockPos").then(class_2170.method_9244((String)"blockPos", (ArgumentType)class_2262.method_9698()).executes(this::navigateToBlock)))).then(class_2170.method_9247((String)"spawnpoint").executes(this::navigateToSpawnPoint))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"death").requires((Predicate)PermissionManager.register("navigate.death", PermissionLevel.PASS))).executes(context -> this.navigateToLastDeathLocation((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.navigateToLastDeathLocation((CommandContext<class_2168>)context, false)))));
    }

    private int navigateToEntity(CommandContext<class_2168> context, boolean isContinue, String arguments) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_1297 entity = class_2186.method_9313(context, (String)arguments);
        class_5250 text = TextUtils.translate(START_NAVIGATION, player.method_5476(), entity.method_5476());
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(entity, isContinue);
        if (this.shouldBeBroadcast(entity, player)) {
            MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), (class_2561)TextUtils.toGrayItalic(text));
        } else {
            MessageUtils.sendMessage((class_2168)context.getSource(), (class_2561)text);
        }
        return 1;
    }

    private int navigateToWaypoint(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        String waypointArgument = StringArgumentType.getString(context, (String)"waypoint");
        try {
            Waypoint waypoint = Waypoint.load(server, waypointArgument);
            PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(waypoint);
            MessageUtils.sendMessage(context, START_NAVIGATION, player.method_5476(), "[" + waypointArgument + "]");
        }
        catch (IOException | NullPointerException e) {
            throw CommandUtils.createException("carpet.commands.locations.list.parse", waypointArgument);
        }
        return 1;
    }

    private int navigateToEntityForUUID(CommandContext<class_2168> context) throws CommandSyntaxException {
        UUID uuid;
        class_3222 player = CommandUtils.getSourcePlayer(context);
        try {
            uuid = UUID.fromString(StringArgumentType.getString(context, (String)"uuid"));
        }
        catch (IllegalArgumentException e) {
            throw CommandUtils.createException("carpet.commands.navigate.parse_uuid_fail", new Object[0]);
        }
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        for (class_3218 world : server.method_3738()) {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null) continue;
            PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(entity, false);
            class_5250 text = TextUtils.translate(START_NAVIGATION, player.method_5476(), entity.method_5476());
            if (this.shouldBeBroadcast(entity, player)) {
                text = TextUtils.toItalic(TextUtils.setColor(text, class_124.field_1080));
                MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), (class_2561)text);
            } else {
                MessageUtils.sendMessage((class_2168)context.getSource(), (class_2561)text);
            }
            return 1;
        }
        throw class_2186.field_9863.create();
    }

    private boolean shouldBeBroadcast(class_1297 entity, class_3222 player) {
        if (entity == player || entity instanceof EntityPlayerMPFake) {
            return false;
        }
        return entity instanceof class_3222;
    }

    private int stopNavigate(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().clearNavigator();
        MessageUtils.sendMessageToHud((class_1657)player, (class_2561)TextUtils.translate("carpet.commands.navigate.hud.stop", new Object[0]));
        return 1;
    }

    private int navigateToBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 blockPos = class_2262.method_48299(context, (String)"blockPos");
        class_1937 world = player.method_37908();
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(blockPos, world);
        MessageUtils.sendMessage(context, START_NAVIGATION, player.method_5476(), TextProvider.blockPos(blockPos, WorldUtils.getColor(world)));
        return 1;
    }

    private int navigateToSpawnPoint(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_5250 spawnPoint = TextUtils.translate("carpet.commands.navigate.name.spawnpoint", new Object[0]);
        try {
            class_3222.class_10766 respawn = Objects.requireNonNull(player.method_67564());
            class_2338 respawnPos = respawn.comp_3684();
            class_3218 world = player.field_13995.method_3847(respawn.comp_3683());
            PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(respawnPos, (class_1937)world, (class_2561)spawnPoint);
        }
        catch (NullPointerException e) {
            throw CommandUtils.createException("carpet.commands.navigate.unable_to_find", player.method_5476(), spawnPoint);
        }
        MessageUtils.sendMessage(context, START_NAVIGATION, player.method_5476(), spawnPoint);
        return 1;
    }

    private int navigateToLastDeathLocation(CommandContext<class_2168> context, boolean self) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_3222 target = self ? player : CommandUtils.getArgumentPlayer(context);
        Optional lastDeathPos = target.method_43122();
        class_5250 lastDeathLocation = TextUtils.translate("carpet.commands.navigate.name.last_death_location", new Object[0]);
        if (lastDeathPos.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.navigate.unable_to_find", target.method_5476(), lastDeathLocation);
        }
        class_5250 name = self ? lastDeathLocation : TextUtils.translate("carpet.commands.navigate.hud.of", target.method_5476(), lastDeathLocation);
        class_4208 globalPos = (class_4208)lastDeathPos.get();
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(globalPos.comp_2208(), (class_1937)((class_2168)context.getSource()).method_9211().method_3847(globalPos.comp_2207()), (class_2561)name);
        class_5250 message = TextUtils.translate(START_NAVIGATION, player.method_5476(), name);
        if (self || player == target) {
            MessageUtils.sendMessage(player, (class_2561)message);
        } else {
            MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), (class_2561)TextUtils.setColor(TextUtils.toItalic(message), class_124.field_1080));
        }
        return 1;
    }

    @Override
    public String getDefaultName() {
        return "navigate";
    }
}

