/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.exception.CommandExecuteIOException;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSafeAfkInterface;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerializer;
import org.carpetorgaddition.periodic.task.ServerTaskManager;
import org.carpetorgaddition.periodic.task.schedule.DelayedLoginTask;
import org.carpetorgaddition.periodic.task.schedule.DelayedLogoutTask;
import org.carpetorgaddition.periodic.task.schedule.PlayerScheduleTask;
import org.carpetorgaddition.periodic.task.schedule.ReLoginTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.permission.PermissionLevel;
import org.carpetorgaddition.util.permission.PermissionManager;
import org.carpetorgaddition.util.provider.CommandProvider;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.WorldFormat;
import org.jetbrains.annotations.NotNull;

public class PlayerManagerCommand
extends AbstractServerCommand {
    private static final String SAFEAFK_PROPERTIES = "safeafk.properties";

    public PlayerManagerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        RequiredArgumentBuilder loginNode = class_2170.method_9244((String)"delayed", (ArgumentType)IntegerArgumentType.integer((int)1));
        for (TimeUnit unit : TimeUnit.values()) {
            loginNode.then(class_2170.method_9247((String)unit.getName()).executes(context -> this.addDelayedLoginTask((CommandContext<class_2168>)context, unit)));
        }
        RequiredArgumentBuilder logoutNode = class_2170.method_9244((String)"delayed", (ArgumentType)IntegerArgumentType.integer((int)1));
        for (TimeUnit unit : TimeUnit.values()) {
            logoutNode.then(class_2170.method_9247((String)unit.getName()).executes(context -> this.addDelayedLogoutTask((CommandContext<class_2168>)context, unit)));
        }
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandPlayerManager))).then(class_2170.method_9247((String)"save").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.savePlayer((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.string()).executes(context -> this.withCommentSavePlayer((CommandContext<class_2168>)context, false)))))).then(class_2170.method_9247((String)"spawn").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).executes(this::spawnPlayer)))).then(class_2170.method_9247((String)"comment").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).executes(context -> this.setComment((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.string()).executes(context -> this.setComment((CommandContext<class_2168>)context, false)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"autologin").requires((Predicate)PermissionManager.register("playerManager.autologin", PermissionLevel.PASS))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).then(class_2170.method_9244((String)"autologin", (ArgumentType)BoolArgumentType.bool()).executes(this::setAutoLogin))))).then(class_2170.method_9247((String)"resave").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.savePlayer((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.string()).executes(context -> this.withCommentSavePlayer((CommandContext<class_2168>)context, true)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(context -> this.list((CommandContext<class_2168>)context, s -> true))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> this.list((CommandContext<class_2168>)context, s -> s.contains(StringArgumentType.getString((CommandContext)context, (String)"filter").toLowerCase(Locale.ROOT))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).executes(this::delete)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"schedule").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"relogin").requires((Predicate)PermissionManager.register("playerManager.schedule.relogin", PermissionLevel.PASS))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.reLoginTaskSuggests()).then(class_2170.method_9244((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"1", "3", "5"}, (SuggestionsBuilder)builder)).executes(this::setReLogin))).then(class_2170.method_9247((String)"stop").executes(this::stopReLogin))))).then(class_2170.method_9247((String)"login").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).then((ArgumentBuilder)loginNode)))).then(class_2170.method_9247((String)"logout").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then((ArgumentBuilder)logoutNode)))).then(class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.cancelSuggests()).executes(this::cancelScheduleTask)))).then(class_2170.method_9247((String)"list").executes(this::listScheduleTask)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"safeafk").then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.safeAfk((CommandContext<class_2168>)context, 5.0f, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"threshold", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> this.safeAfk((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"threshold"), false))).then(class_2170.method_9244((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.safeAfk((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"threshold"), BoolArgumentType.getBool((CommandContext)context, (String)"save")))))))).then(class_2170.method_9247((String)"list").executes(this::listSafeAfk))).then(class_2170.method_9247((String)"cancel").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.cancelSafeAfk((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.cancelSafeAfk((CommandContext<class_2168>)context, true)))))).then(class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::querySafeAfk)))));
    }

    @NotNull
    private SuggestionProvider<class_2168> cancelSuggests() {
        return (context, builder) -> {
            ServerTaskManager manager = ServerComponentCoordinator.getManager((CommandContext<class_2168>)context).getServerTaskManager();
            Stream<String> stream = manager.stream(PlayerScheduleTask.class).map(PlayerScheduleTask::getPlayerName);
            return class_2172.method_9264(stream, (SuggestionsBuilder)builder);
        };
    }

    private SuggestionProvider<class_2168> defaultSuggests() {
        return (context, builder) -> class_2172.method_9264(new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]).toImmutableFileList().stream().filter(file -> file.getName().endsWith(".json")).map(file -> IOUtils.removeExtension(file.getName(), ".json")).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
    }

    @NotNull
    private SuggestionProvider<class_2168> reLoginTaskSuggests() {
        return (context, builder) -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            ServerTaskManager manager = ServerComponentCoordinator.getManager(server).getServerTaskManager();
            List<String> taskList = manager.stream(ReLoginTask.class).map(ReLoginTask::getPlayerName).toList();
            List<String> onlineList = server.method_3760().method_14571().stream().map(player -> player.method_5477().getString()).toList();
            HashSet<String> players = new HashSet<String>();
            players.addAll(taskList);
            players.addAll(onlineList);
            return class_2172.method_9264(players.stream(), (SuggestionsBuilder)builder);
        };
    }

    private int safeAfk(CommandContext<class_2168> context, float threshold, boolean save) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        if (threshold >= fakePlayer.method_6063()) {
            throw CommandUtils.createException("carpet.commands.playerManager.safeafk.threshold_too_high", new Object[0]);
        }
        if (threshold <= 0.0f) {
            threshold = -1.0f;
        }
        FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)fakePlayer;
        safeAfk.setHealthThreshold(threshold);
        if (save) {
            try {
                this.saveSafeAfkThreshold(context, threshold, fakePlayer);
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
        } else {
            String command = CommandProvider.setupSafeAfkPermanentlyChange(fakePlayer, threshold);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up", fakePlayer.method_5476(), Float.valueOf(threshold), TextProvider.clickRun(command));
        }
        return (int)threshold;
    }

    private int listSafeAfk(CommandContext<class_2168> context) {
        List<class_3222> list = ((class_2168)context.getSource()).method_9211().method_3760().method_14571().stream().filter(player -> player instanceof EntityPlayerMPFake).toList();
        int count = 0;
        for (class_3222 player2 : list) {
            float threshold = ((FakePlayerSafeAfkInterface)player2).getHealthThreshold();
            if (threshold < 0.0f) continue;
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.list.each", player2.method_5476(), Float.valueOf(threshold));
            ++count;
        }
        if (count == 0) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.list.empty", new Object[0]);
        }
        return count;
    }

    private int cancelSafeAfk(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)fakePlayer;
        safeAfk.setHealthThreshold(-1.0f);
        if (remove) {
            try {
                this.saveSafeAfkThreshold(context, -1.0f, fakePlayer);
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
        } else {
            String key = "carpet.commands.playerManager.safeafk.successfully_set_up.cancel";
            class_5250 command = TextProvider.clickRun(CommandProvider.cancelSafeAfkPermanentlyChange(fakePlayer));
            MessageUtils.sendMessage(context, key, fakePlayer.method_5476(), command);
        }
        return 1;
    }

    private int querySafeAfk(CommandContext<class_2168> context) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        float threshold = ((FakePlayerSafeAfkInterface)fakePlayer).getHealthThreshold();
        String key = "carpet.commands.playerManager.safeafk.list.each";
        MessageUtils.sendMessage(context, key, fakePlayer.method_5476(), Float.valueOf(threshold));
        return (int)threshold;
    }

    private void saveSafeAfkThreshold(CommandContext<class_2168> context, float threshold, EntityPlayerMPFake fakePlayer) throws IOException {
        String playerName = fakePlayer.method_5477().getString();
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), null, new String[0]);
        File file = worldFormat.file(SAFEAFK_PROPERTIES);
        if (file.isFile() || file.createNewFile()) {
            BufferedWriter writer;
            BufferedReader reader;
            Properties properties = new Properties();
            try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                properties.load(reader);
            }
            if (threshold > 0.0f) {
                properties.setProperty(playerName, String.valueOf(threshold));
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up.save", fakePlayer.method_5476(), Float.valueOf(threshold));
            } else {
                properties.remove(playerName);
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up.remove", fakePlayer.method_5476());
            }
            try (BufferedWriter bufferedWriter = writer = IOUtils.toWriter(file);){
                properties.store(writer, null);
            }
        }
    }

    public static void loadSafeAfk(class_3222 player) {
        WorldFormat worldFormat;
        File file;
        if (player instanceof EntityPlayerMPFake && (file = (worldFormat = new WorldFormat(player.field_13995, null, new String[0])).file(SAFEAFK_PROPERTIES)).isFile()) {
            Properties properties = new Properties();
            try {
                BufferedReader reader;
                try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                    properties.load(reader);
                }
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("\u5047\u73a9\u5bb6\u5b89\u5168\u6302\u673a\u9608\u503c\u52a0\u8f7d\u65f6\u51fa\u9519", (Throwable)e);
                return;
            }
            try {
                FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)player;
                String value = properties.getProperty(player.method_5477().getString());
                if (value == null) {
                    return;
                }
                float threshold = Float.parseFloat(value);
                safeAfk.setHealthThreshold(threshold);
                String key = "carpet.commands.playerManager.safeafk.successfully_set_up.auto";
                class_5250 message = TextUtils.translate(key, player.method_5476(), Float.valueOf(threshold));
                MessageUtils.broadcastMessage(player.field_13995, (class_2561)TextUtils.toGrayItalic(message));
            }
            catch (NumberFormatException e) {
                CarpetOrgAddition.LOGGER.error("{}\u5b89\u5168\u6302\u673a\u9608\u503c\u8bbe\u7f6e\u5931\u8d25", (Object)player.method_5477().getString(), (Object)e);
            }
        }
    }

    private int list(CommandContext<class_2168> context, Predicate<String> filter) {
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        int count = FakePlayerSerializer.list(context, worldFormat, filter);
        if (count == 0) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.list.no_player", new Object[0]);
            return 0;
        }
        return count;
    }

    private int savePlayer(CommandContext<class_2168> context, boolean resave) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        FakePlayerSerializer fakePlayerSerializer = new FakePlayerSerializer(fakePlayer);
        this.savePlayer(context, fakePlayerSerializer, fakePlayer, resave);
        return 1;
    }

    private int withCommentSavePlayer(CommandContext<class_2168> context, boolean resave) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        String comment = StringArgumentType.getString(context, (String)"comment");
        FakePlayerSerializer fakePlayerSerializer = new FakePlayerSerializer(fakePlayer, comment);
        return this.savePlayer(context, fakePlayerSerializer, fakePlayer, resave);
    }

    private int setComment(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        FakePlayerSerializer serial;
        String name = StringArgumentType.getString(context, (String)"name");
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        String comment = remove ? null : StringArgumentType.getString(context, (String)"comment");
        try {
            serial = FakePlayerSerializer.factory(worldFormat, name);
            serial.setComment(comment);
            serial.save(context, true);
        }
        catch (FileNotFoundException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.cannot_find_file", name);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
        if (remove) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.comment.remove", serial.getDisplayName());
        } else {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.comment.modify", serial.getDisplayName(), comment);
        }
        return 1;
    }

    private int setAutoLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        FakePlayerSerializer serial;
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        String name = StringArgumentType.getString(context, (String)"name");
        boolean autologin = BoolArgumentType.getBool(context, (String)"autologin");
        try {
            serial = FakePlayerSerializer.factory(worldFormat, name);
            serial.setAutologin(autologin);
            serial.save(context, true);
        }
        catch (FileNotFoundException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.cannot_find_file", name);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
        if (autologin) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.autologin.setup", serial.getDisplayName());
        } else {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.autologin.cancel", serial.getDisplayName());
        }
        return 1;
    }

    private int savePlayer(CommandContext<class_2168> context, FakePlayerSerializer fakePlayerSerializer, EntityPlayerMPFake fakePlayer, boolean resave) throws CommandSyntaxException {
        try {
            int result = fakePlayerSerializer.save(context, resave);
            if (result == 0) {
                MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.save.success", fakePlayer.method_5476());
            } else if (result == 1) {
                MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.save.resave", fakePlayer.method_5476());
            }
            return result < 0 ? 0 : 1;
        }
        catch (IOException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.save.fail", fakePlayer.method_5476());
        }
    }

    private int spawnPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        try {
            FakePlayerSerializer serial = FakePlayerSerializer.factory(worldFormat, name);
            serial.spawn(((class_2168)context.getSource()).method_9211());
        }
        catch (FileNotFoundException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.cannot_find_file", name);
        }
        catch (IOException | RuntimeException e) {
            throw CommandUtils.createException(e, "carpet.commands.playerManager.spawn.fail", new Object[0]);
        }
        return 1;
    }

    private int delete(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name;
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        File file = worldFormat.file((name = StringArgumentType.getString(context, (String)"name")) + ".json");
        if (!file.isFile() || !file.delete()) {
            throw CommandUtils.createException("carpet.commands.playerManager.delete.fail", new Object[0]);
        }
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.delete.success", new Object[0]);
        return 1;
    }

    private int setReLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (this.fixMemoryLeak(context)) {
            String name = StringArgumentType.getString(context, (String)"name");
            int interval = IntegerArgumentType.getInteger(context, (String)"interval");
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            ServerTaskManager manager = ServerComponentCoordinator.getManager(context).getServerTaskManager();
            Optional<ReLoginTask> optional = manager.stream(ReLoginTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).findFirst();
            if (optional.isEmpty()) {
                class_3222 player = server.method_3760().method_14566(name);
                if (player == null) {
                    throw CommandUtils.createException("argument.entity.notfound.player", new Object[0]);
                }
                CommandUtils.assertFakePlayer((class_1657)player);
                manager.addTask(new ReLoginTask(name, interval, server, (class_5321<class_1937>)player.method_51469().method_27983(), context));
            } else {
                optional.get().setInterval(interval);
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.set_interval", name, interval);
            }
            return interval;
        }
        return 0;
    }

    private boolean fixMemoryLeak(CommandContext<class_2168> context) {
        if (CarpetOrgAdditionSettings.fakePlayerSpawnMemoryLeakFix) {
            return true;
        }
        class_5250 here = TextUtils.translate("carpet.command.text.click.here", new Object[0]);
        String command = "/carpet fakePlayerSpawnMemoryLeakFix true";
        class_5250 input = TextUtils.translate("carpet.command.text.click.input", command);
        here = TextUtils.suggest(here, command, (class_2561)input, class_124.field_1075);
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.condition", here);
        return false;
    }

    private int stopReLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        ServerTaskManager manager = ServerComponentCoordinator.getManager(context).getServerTaskManager();
        Optional<ReLoginTask> optional = manager.stream(ReLoginTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).findFirst();
        if (optional.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.schedule.cancel.fail", new Object[0]);
        }
        optional.ifPresent(task -> task.onCancel(context));
        return 1;
    }

    private int addDelayedLoginTask(CommandContext<class_2168> context, TimeUnit unit) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        ServerTaskManager manager = ServerComponentCoordinator.getManager(context).getServerTaskManager();
        String name = StringArgumentType.getString(context, (String)"name");
        Optional<DelayedLoginTask> optional = manager.stream(DelayedLoginTask.class).filter(task -> Objects.equals(name, task.getPlayerName())).findFirst();
        long tick = unit.getDelayed(context);
        class_5250 time = TextUtils.hoverText((class_2561)TextProvider.tickToTime(tick), (class_2561)TextProvider.tickToRealTime(tick));
        if (optional.isEmpty()) {
            FakePlayerSerializer serial;
            WorldFormat worldFormat = new WorldFormat(server, "player_data", new String[0]);
            try {
                serial = FakePlayerSerializer.factory(worldFormat, name);
            }
            catch (IOException e) {
                throw CommandUtils.createException("carpet.commands.playerManager.schedule.read_file", new Object[0]);
            }
            manager.addTask(new DelayedLoginTask(server, serial, tick));
            String key = server.method_3760().method_14566(name) == null ? "carpet.commands.playerManager.schedule.login" : "carpet.commands.playerManager.schedule.login.try";
            MessageUtils.sendMessage(context, key, serial.getDisplayName(), time);
        } else {
            DelayedLoginTask task2 = optional.get();
            class_5250 info = TextUtils.hoverText(name, task2.getInfo());
            task2.setDelayed(tick);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.login.modify", info, time);
        }
        return (int)tick;
    }

    private int addDelayedLogoutTask(CommandContext<class_2168> context, TimeUnit unit) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        long tick = unit.getDelayed(context);
        class_5250 time = TextUtils.hoverText((class_2561)TextProvider.tickToTime(tick), (class_2561)TextProvider.tickToRealTime(tick));
        ServerTaskManager manager = ServerComponentCoordinator.getManager(server).getServerTaskManager();
        Optional<DelayedLogoutTask> optional = manager.stream(DelayedLogoutTask.class).filter(task -> fakePlayer.equals((Object)task.getFakePlayer())).findFirst();
        if (optional.isEmpty()) {
            manager.addTask(new DelayedLogoutTask(server, fakePlayer, tick));
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.logout", fakePlayer.method_5476(), time);
        } else {
            optional.get().setDelayed(tick);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.logout.modify", fakePlayer.method_5476(), time);
        }
        return (int)tick;
    }

    private int cancelScheduleTask(CommandContext<class_2168> context) throws CommandSyntaxException {
        ServerTaskManager manager = ServerComponentCoordinator.getManager(context).getServerTaskManager();
        String name = StringArgumentType.getString(context, (String)"name");
        List<PlayerScheduleTask> list = manager.stream(PlayerScheduleTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).toList();
        if (list.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.schedule.cancel.fail", new Object[0]);
        }
        list.forEach(task -> task.onCancel(context));
        return list.size();
    }

    private int listScheduleTask(CommandContext<class_2168> context) {
        ServerTaskManager manager = ServerComponentCoordinator.getManager(context).getServerTaskManager();
        List<PlayerScheduleTask> list = manager.stream(PlayerScheduleTask.class).toList();
        if (list.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.list.empty", new Object[0]);
        } else {
            list.forEach(task -> task.sendEachMessage((class_2168)context.getSource()));
        }
        return list.size();
    }

    @Override
    public String getDefaultName() {
        return "playerManager";
    }

    private static enum TimeUnit {
        TICK,
        SECOND,
        MINUTE,
        HOUR;


        private String getName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "t";
                case 1 -> "s";
                case 2 -> "min";
                case 3 -> "h";
            };
        }

        private long getDelayed(CommandContext<class_2168> context) {
            int delayed = IntegerArgumentType.getInteger(context, (String)"delayed");
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> delayed;
                case 1 -> (long)delayed * 20L;
                case 2 -> (long)delayed * 1200L;
                case 3 -> (long)delayed * 72000L;
            };
        }
    }
}

