/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.math.BigInteger;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.exception.OperationTimeoutException;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.ExperienceTransfer;

public class XpTransferCommand
extends AbstractServerCommand {
    public XpTransferCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandXpTransfer))).then(class_2170.method_9244((String)"from", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"to", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"all").executes(this::transferAll))).then(class_2170.method_9247((String)"half").executes(this::transferHalf))).then(class_2170.method_9247((String)"points").then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::transferSpecifyPoint)))).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::transferSpecifyLevel)))).then(class_2170.method_9247((String)"upgrade").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::transferUpgrade)))).then(class_2170.method_9247((String)"upgradeto").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::transferUpgradeTo))))));
    }

    private int transferAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ExperienceTransfer from = new ExperienceTransfer(this.getFromPlayer(context));
        ExperienceTransfer to = new ExperienceTransfer(this.getToPlayer(context));
        if (from.isSpecifiedOrFakePlayer(CommandUtils.getSourcePlayer(context))) {
            BigInteger number;
            int fromBeforeLevel = from.getLevel();
            int toBeforeLevel = to.getLevel();
            try {
                number = from.transferAllTo(to);
            }
            catch (OperationTimeoutException e) {
                throw CommandUtils.createOperationTimeoutException();
            }
            int fromCurrentLevel = from.getLevel();
            int toCurrentLevel = to.getLevel();
            class_5250 message = TextUtils.translate("carpet.commands.xpTransfer.all", from.player().method_5476(), number.toString(), to.player().method_5476());
            class_5250 hover = this.getHover(to.player(), toCurrentLevel, toBeforeLevel, from.player(), fromBeforeLevel, fromCurrentLevel);
            MessageUtils.sendMessage(source, (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hover));
            this.writeLog(source, to.player(), from.player(), number);
            return number.intValue();
        }
        throw CommandUtils.createSelfOrFakePlayerException();
    }

    private int transferHalf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ExperienceTransfer from = new ExperienceTransfer(this.getFromPlayer(context));
        ExperienceTransfer to = new ExperienceTransfer(this.getToPlayer(context));
        if (from.isSpecifiedOrFakePlayer(CommandUtils.getSourcePlayer(context))) {
            BigInteger number;
            int outputBeforeLevel = from.getLevel();
            int inputBeforeLevel = to.getLevel();
            try {
                number = from.transferHalfTo(to);
            }
            catch (OperationTimeoutException e) {
                throw CommandUtils.createOperationTimeoutException();
            }
            int outputCurrentLevel = from.getLevel();
            int inputCurrentLevel = to.getLevel();
            class_5250 hover = this.getHover(to.player(), inputCurrentLevel, inputBeforeLevel, from.player(), outputBeforeLevel, outputCurrentLevel);
            class_5250 message = TextUtils.translate("carpet.commands.xpTransfer.half", from.player().method_5476(), number.toString(), to.player().method_5476());
            MessageUtils.sendMessage(source, (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hover));
            this.writeLog(source, to.player(), from.player(), number);
            return number.intValue();
        }
        throw CommandUtils.createSelfOrFakePlayerException();
    }

    private int transferSpecifyPoint(CommandContext<class_2168> context) throws CommandSyntaxException {
        int count = IntegerArgumentType.getInteger(context, (String)"number");
        return this.transfer(context, BigInteger.valueOf(count));
    }

    private int transferSpecifyLevel(CommandContext<class_2168> context) throws CommandSyntaxException {
        BigInteger count;
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        try {
            count = ExperienceTransfer.calculateTotalExperience(level, 0);
        }
        catch (ArithmeticException e) {
            throw CommandUtils.createException(e, "carpet.commands.xpTransfer.calculate.fail", new Object[0]);
        }
        return this.transfer(context, count);
    }

    private int transferUpgrade(CommandContext<class_2168> context) throws CommandSyntaxException {
        BigInteger count;
        int level = this.getToPlayer(context).field_7520;
        int upgrade = level + IntegerArgumentType.getInteger(context, (String)"level");
        try {
            count = ExperienceTransfer.calculateUpgradeExperience(level, upgrade);
        }
        catch (ArithmeticException e) {
            throw CommandUtils.createException(e, "carpet.commands.xpTransfer.calculate.fail", new Object[0]);
        }
        return this.transfer(context, count);
    }

    private int transferUpgradeTo(CommandContext<class_2168> context) throws CommandSyntaxException {
        BigInteger count;
        int level = this.getToPlayer(context).field_7520;
        int upgrade = IntegerArgumentType.getInteger(context, (String)"level");
        try {
            count = ExperienceTransfer.calculateUpgradeExperience(level, upgrade);
        }
        catch (ArithmeticException e) {
            throw CommandUtils.createException(e, "carpet.commands.xpTransfer.calculate.fail", new Object[0]);
        }
        if (count.compareTo(BigInteger.ZERO) < 0) {
            throw CommandUtils.createException("carpet.commands.xpTransfer.upgradeto.negative", new Object[0]);
        }
        return this.transfer(context, count);
    }

    private int transfer(CommandContext<class_2168> context, BigInteger count) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ExperienceTransfer from = new ExperienceTransfer(this.getFromPlayer(context));
        ExperienceTransfer to = new ExperienceTransfer(this.getToPlayer(context));
        if (from.isSpecifiedOrFakePlayer(CommandUtils.getSourcePlayer(context))) {
            int outputBeforeLevel = from.getLevel();
            int inputBeforeLevel = to.getLevel();
            try {
                from.transferTo(to, count);
            }
            catch (ExperienceTransfer.ExperienceTransferException e) {
                throw CommandUtils.createException("carpet.commands.xpTransfer.point.fail", from.player().method_5476(), e.getRequire().toString(), e.getExisting().toString());
            }
            catch (OperationTimeoutException e) {
                throw CommandUtils.createOperationTimeoutException();
            }
            int outputCurrentLevel = from.getLevel();
            int inputCurrentLevel = to.getLevel();
            class_5250 message = TextUtils.translate("carpet.commands.xpTransfer.point", from.player().method_5476(), count.toString(), to.player().method_5476());
            class_5250 hover = this.getHover(to.player(), inputCurrentLevel, inputBeforeLevel, from.player(), outputBeforeLevel, outputCurrentLevel);
            MessageUtils.sendMessage(source, (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hover));
            this.writeLog(source, to.player(), from.player(), count);
            return count.intValue();
        }
        throw CommandUtils.createSelfOrFakePlayerException();
    }

    private class_3222 getFromPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return class_2186.method_9315(context, (String)"from");
    }

    private class_3222 getToPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return class_2186.method_9315(context, (String)"to");
    }

    private void writeLog(class_2168 source, class_3222 inputPlayer, class_3222 outputPlayer, BigInteger point) {
        class_3222 player = source.method_44023();
        String output = player == outputPlayer ? "\u81ea\u5df1" : outputPlayer.method_5477().getString();
        String input = player == inputPlayer ? "\u81ea\u5df1" : inputPlayer.method_5477().getString();
        CarpetOrgAddition.LOGGER.info("{}\u5c06{}\u7684{}\u70b9\u7ecf\u9a8c\u8f6c\u79fb\u7ed9{}", new Object[]{source.method_9214(), output, point.toString(), input});
    }

    private class_5250 getHover(class_3222 inputPlayer, int inputCurrentLevel, int inputBeforeLevel, class_3222 outputPlayer, int outputBeforeLevel, int outputCurrentLevel) {
        return TextUtils.appendAll(TextUtils.setColor(TextUtils.translate("carpet.commands.xpTransfer.upgrade", inputPlayer.method_5476(), inputCurrentLevel - inputBeforeLevel, inputBeforeLevel, inputCurrentLevel), class_124.field_1060), TextProvider.NEW_LINE, TextUtils.setColor(TextUtils.translate("carpet.commands.xpTransfer.degrade", outputPlayer.method_5476(), outputBeforeLevel - outputCurrentLevel, outputBeforeLevel, outputCurrentLevel), class_124.field_1061));
    }

    @Override
    public String getDefaultName() {
        return "xpTransfer";
    }
}

