/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.IOUtils;

public class CustomCommandConfig {
    private final File file = IOUtils.createConfigFile("custom_command_name.json", true);
    private final HashMap<String, Set<String>> commands = new HashMap();
    private boolean expired = false;
    private static final CustomCommandConfig INSTANCE = new CustomCommandConfig();

    public static CustomCommandConfig getInstance() {
        return INSTANCE;
    }

    private CustomCommandConfig() {
        if (this.file.length() == 0L) {
            this.init();
        }
        this.load();
    }

    private void init() {
        try {
            this.createConfigFile();
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("An unexpected error occurred while creating the custom command names configuration file: ", (Throwable)e);
        }
    }

    public synchronized void refreshIfExpired() {
        if (this.expired) {
            this.init();
        }
    }

    private void createConfigFile() {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)1);
        JsonObject command = new JsonObject();
        for (Map.Entry<String, Set<String>> entry : this.commands.entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            if (value.isEmpty()) {
                command.addProperty(key, key);
                continue;
            }
            if (value.size() == 1) {
                command.addProperty(key, value.iterator().next());
                continue;
            }
            JsonArray array = new JsonArray();
            for (String str : value) {
                array.add(str);
            }
            command.add(key, (JsonElement)array);
        }
        json.add("commands", (JsonElement)command);
        try {
            IOUtils.saveJson(this.file, json);
            this.expired = false;
        }
        catch (IOException e) {
            IOUtils.loggerError(e);
        }
    }

    public void load() {
        try {
            JsonObject json = IOUtils.loadJson(this.file);
            JsonObject command = json.get("commands").getAsJsonObject();
            for (Map.Entry entry : command.entrySet()) {
                Set<String> set;
                JsonElement value;
                String key = (String)entry.getKey();
                JsonElement jsonElement = value = (JsonElement)entry.getValue();
                int n = 0;
                block8: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class, JsonArray.class}, (Object)jsonElement, n)) {
                        case 0: {
                            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                            if (!primitive.isString()) {
                                n = 1;
                                continue block8;
                            }
                            set = Set.of(value.getAsString());
                            break block8;
                        }
                        case 1: {
                            JsonArray array = (JsonArray)jsonElement;
                            set = array.asList().stream().filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).collect(Collectors.toSet());
                            break block8;
                        }
                        default: {
                            set = Set.of(key);
                            break block8;
                        }
                    }
                    break;
                }
                Set<String> set2 = set;
                this.commands.put(key, set2);
            }
            return;
        }
        catch (IOException e) {
            IOUtils.loggerError(e);
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("The custom command name configuration file is damaged. Attempting to regenerate it: ", (Throwable)e);
            IOUtils.backup(this.file);
        }
        this.expired = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCommand(String command) {
        Set<String> set;
        CustomCommandConfig customCommandConfig = this;
        synchronized (customCommandConfig) {
            set = this.commands.get(command);
            if (set == null) {
                set = Set.of(command);
                this.commands.put(command, set);
                this.expired = true;
            }
        }
        return (String[])set.toArray(String[]::new);
    }
}

