/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.debug;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.SettingsManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.debug.DebugRule;
import org.carpetorgaddition.debug.DebugSettings;
import org.carpetorgaddition.exception.ProductionEnvironmentError;

public class DebugRuleRegistrar
implements CarpetExtension {
    private final SettingsManager settingsManager;
    private static DebugRuleRegistrar instance;
    private static final HashMap<String, String> TRANSLATIONS;

    public static DebugRuleRegistrar getInstance() {
        if (instance == null) {
            instance = new DebugRuleRegistrar();
        }
        return instance;
    }

    private DebugRuleRegistrar() {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            throw new ProductionEnvironmentError();
        }
        this.settingsManager = new SettingsManager(CarpetOrgAddition.VERSION, "carpet-debug", "CarpetOrgAdditionDebug");
    }

    public void registrar() {
        Field[] fields;
        CarpetServer.manageExtension((CarpetExtension)this);
        for (Field field : fields = DebugSettings.class.getDeclaredFields()) {
            DebugRule debugRule = field.getAnnotation(DebugRule.class);
            if (debugRule == null) continue;
            this.parse(field, debugRule);
        }
    }

    private void parse(Field field, DebugRule debugRule) {
        try {
            this.translation(field, debugRule);
            Class<?> parsedRuleClass = Class.forName("carpet.settings.ParsedRule");
            Class<?> ruleAnnotationClass = Class.forName("carpet.settings.ParsedRule$RuleAnnotation");
            Constructor<?> ruleAnnotationConstructor = ruleAnnotationClass.getDeclaredConstructor(Boolean.TYPE, String.class, String.class, String[].class, String[].class, String[].class, Boolean.TYPE, String.class, Class[].class);
            ruleAnnotationConstructor.setAccessible(true);
            Object ruleAnnotation = ruleAnnotationConstructor.newInstance(true, field.getName(), debugRule.desc(), debugRule.extra(), new String[]{"Org", "\u8c03\u8bd5"}, debugRule.options(), false, "", new Class[0]);
            Constructor<?> parsedRuleConstructor = parsedRuleClass.getDeclaredConstructor(Field.class, ruleAnnotationClass, SettingsManager.class);
            parsedRuleConstructor.setAccessible(true);
            CarpetRule parsedRule = (CarpetRule)parsedRuleConstructor.newInstance(field, ruleAnnotation, this.settingsManager);
            this.settingsManager.addCarpetRule(parsedRule);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void translation(Field field, DebugRule debugRule) {
        String nameKey = "%s.rule.%s.name".formatted(this.settingsManager.identifier(), field.getName());
        String descKey = "%s.rule.%s.desc".formatted(this.settingsManager.identifier(), field.getName());
        TRANSLATIONS.put(nameKey, debugRule.name());
        TRANSLATIONS.put(descKey, debugRule.desc());
    }

    public SettingsManager extensionSettingsManager() {
        return this.settingsManager;
    }

    public Map<String, String> canHasTranslations(String lang) {
        return TRANSLATIONS;
    }

    static {
        TRANSLATIONS = new HashMap();
    }
}

