/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.patches.EntityPlayerMPFake;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_3225;
import net.minecraft.class_5552;
import org.jetbrains.annotations.Nullable;

public class BlockExcavator {
    private final EntityPlayerMPFake player;
    private int blockBreakingCooldown;
    @Nullable
    private class_2338 currentBreakingPos;
    private float currentBreakingProgress;

    public BlockExcavator(EntityPlayerMPFake player) {
        this.player = player;
    }

    public void tick() {
        if (this.blockBreakingCooldown > 0) {
            --this.blockBreakingCooldown;
        }
    }

    public boolean mining(class_2338 blockPos, class_2350 direction) {
        return this.mining(blockPos, direction, true);
    }

    public boolean mining(class_2338 blockPos, class_2350 direction, boolean breakingCooldown) {
        boolean blockBroken;
        class_3225 interactionManager;
        class_1934 gameMode;
        if (breakingCooldown && this.blockBreakingCooldown > 0) {
            return false;
        }
        class_1937 world = this.player.method_37908();
        if (this.player.method_21701(world, blockPos, gameMode = (interactionManager = this.player.field_13974).method_14257())) {
            return false;
        }
        if (!world.method_8505((class_1297)this.player, blockPos)) {
            return false;
        }
        if (this.currentBreakingPos != null && world.method_8320(this.currentBreakingPos).method_26215()) {
            this.currentBreakingPos = null;
            return true;
        }
        class_2680 blockState = world.method_8320(blockPos);
        this.player.method_5702(class_2183.class_2184.field_9851, blockPos.method_46558());
        float delta = blockState.method_26165((class_1657)this.player, (class_1922)world, blockPos);
        if (this.player.method_68878()) {
            this.breakingAction(class_2846.class_2847.field_12968, blockPos, direction);
            this.blockBreakingCooldown = 5;
            blockBroken = true;
        } else if (this.currentBreakingPos == null) {
            blockBroken = this.startMining(blockPos, direction, delta);
        } else if (this.currentBreakingPos.equals((Object)blockPos)) {
            blockBroken = this.continueMining(blockPos, direction, delta);
        } else {
            this.breakingAction(class_2846.class_2847.field_12971, this.currentBreakingPos, direction);
            blockBroken = this.startMining(blockPos, direction, delta);
        }
        this.player.method_14234();
        this.player.method_6104(class_1268.field_5808);
        return blockBroken;
    }

    private boolean startMining(class_2338 blockPos, class_2350 direction, float delta) {
        this.breakingAction(class_2846.class_2847.field_12968, blockPos, direction);
        if (delta >= 1.0f) {
            return true;
        }
        this.currentBreakingPos = blockPos;
        this.currentBreakingProgress = 0.0f;
        return false;
    }

    private boolean continueMining(class_2338 blockPos, class_2350 direction, float delta) {
        this.currentBreakingProgress += delta;
        if (this.currentBreakingProgress >= 1.0f) {
            this.breakingAction(class_2846.class_2847.field_12973, blockPos, direction);
            this.currentBreakingPos = null;
            this.blockBreakingCooldown = 5;
            this.currentBreakingProgress = 0.0f;
            return true;
        }
        return false;
    }

    public int computingRemainingMiningTime(class_2338 blockPos) {
        class_1937 world = this.player.method_37908();
        if (this.player.method_68878()) {
            return 1;
        }
        class_2680 blockState = world.method_8320(blockPos);
        float delta = blockState.method_26165((class_1657)this.player, (class_1922)world, blockPos);
        return (int)Math.ceil((1.0f - this.currentBreakingProgress) / delta);
    }

    private void breakingAction(class_2846.class_2847 action, class_2338 blockPos, class_2350 direction) {
        class_1937 world = this.player.method_37908();
        this.player.field_13974.method_14263(blockPos, action, direction, world.method_31600(), -1);
    }

    public EntityPlayerMPFake getPlayer() {
        return this.player;
    }

    public static boolean canBreak(EntityPlayerMPFake fakePlayer, class_2338 blockPos) {
        class_1937 world = fakePlayer.method_37908();
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_5552 && !fakePlayer.method_7338()) {
            return false;
        }
        if (fakePlayer.method_21701(world, blockPos, fakePlayer.field_13974.method_14257())) {
            return false;
        }
        class_1799 mainHandItemStack = fakePlayer.method_6047();
        class_1792 mainHandItem = mainHandItemStack.method_7909();
        if (mainHandItem.method_7885(mainHandItemStack, blockState, world, blockPos, (class_1309)fakePlayer) && world.method_8505((class_1297)fakePlayer, blockPos)) {
            if (fakePlayer.method_68878() || blockState.method_26215()) {
                return true;
            }
            return blockState.method_26214((class_1922)world, blockPos) != -1.0f;
        }
        return true;
    }
}

