/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.fakes.ServerPlayerInterface;
import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.dataupdate.DataUpdater;
import org.carpetorgaddition.dataupdate.player.FakePlayerSerializeDataUpdater;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.fakeplayer.EntityPlayerActionPackSerial;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerActionSerializer;
import org.carpetorgaddition.periodic.task.ServerTaskManager;
import org.carpetorgaddition.periodic.task.schedule.DelayedLoginTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.GameUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.provider.CommandProvider;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.MetaComment;
import org.carpetorgaddition.util.wheel.TextBuilder;
import org.carpetorgaddition.util.wheel.WorldFormat;
import org.jetbrains.annotations.Nullable;

public class FakePlayerSerializer {
    public static final String PLAYER_DATA = "player_data";
    public static final String SCRIPT_ACTION = "script_action";
    private final String fakePlayerName;
    private final MetaComment comment = new MetaComment();
    private final class_243 playerPos;
    private final float yaw;
    private final float pitch;
    private final String dimension;
    private final class_1934 gameMode;
    private final boolean flying;
    private final boolean sneaking;
    private boolean autologin = false;
    private final EntityPlayerActionPackSerial interactiveAction;
    private final FakePlayerActionSerializer autoAction;

    public FakePlayerSerializer(EntityPlayerMPFake fakePlayer) {
        this.fakePlayerName = fakePlayer.method_5477().getString();
        this.playerPos = fakePlayer.method_19538();
        this.yaw = fakePlayer.method_36454();
        this.pitch = fakePlayer.method_36455();
        this.dimension = WorldUtils.getDimensionId(fakePlayer.method_37908());
        this.gameMode = fakePlayer.field_13974.method_14257();
        this.flying = fakePlayer.method_31549().field_7479;
        this.sneaking = fakePlayer.method_5715();
        this.interactiveAction = new EntityPlayerActionPackSerial(((ServerPlayerInterface)fakePlayer).getActionPack());
        this.autoAction = new FakePlayerActionSerializer(fakePlayer);
    }

    public FakePlayerSerializer(EntityPlayerMPFake fakePlayer, String comment) {
        this(fakePlayer);
        this.comment.setComment(comment);
    }

    private FakePlayerSerializer(JsonObject json, String fakePlayerName) {
        this.fakePlayerName = fakePlayerName;
        JsonObject pos = json.get("pos").getAsJsonObject();
        this.playerPos = new class_243(pos.get("x").getAsDouble(), pos.get("y").getAsDouble(), pos.get("z").getAsDouble());
        JsonObject direction = json.get("direction").getAsJsonObject();
        this.yaw = direction.get("yaw").getAsFloat();
        this.pitch = direction.get("pitch").getAsFloat();
        this.dimension = json.get("dimension").getAsString();
        this.gameMode = class_1934.method_8385((String)json.get("gamemode").getAsString());
        this.flying = json.get("flying").getAsBoolean();
        this.sneaking = json.get("sneaking").getAsBoolean();
        this.autologin = IOUtils.getJsonElement(json, "autologin", false, Boolean.class);
        JsonElement element = json.get("annotation");
        this.comment.setComment(element == null ? "" : element.getAsString());
        this.interactiveAction = json.has("hand_action") ? new EntityPlayerActionPackSerial(json.get("hand_action").getAsJsonObject()) : EntityPlayerActionPackSerial.NO_ACTION;
        if (json.has(SCRIPT_ACTION)) {
            JsonObject scriptJson = json.get(SCRIPT_ACTION).getAsJsonObject();
            this.autoAction = new FakePlayerActionSerializer(scriptJson);
        } else {
            this.autoAction = FakePlayerActionSerializer.NO_ACTION;
        }
    }

    public static FakePlayerSerializer factory(WorldFormat worldFormat, String nameOrFileName) throws IOException {
        JsonObject json = IOUtils.loadJson(worldFormat.file(nameOrFileName, ".json"));
        int version = DataUpdater.getVersion(json);
        if (version < 1) {
            FakePlayerSerializeDataUpdater dataUpdater = new FakePlayerSerializeDataUpdater();
            json = dataUpdater.update(json, version);
        }
        String fakePlayerName = IOUtils.removeExtension(nameOrFileName, ".json");
        return new FakePlayerSerializer(json, fakePlayerName);
    }

    public int save(CommandContext<class_2168> context, boolean resave) throws IOException {
        String name;
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        WorldFormat worldFormat = new WorldFormat(server, PLAYER_DATA, new String[0]);
        File file = worldFormat.file((name = this.fakePlayerName) + ".json");
        boolean exists = file.exists();
        if (exists && !resave) {
            String command = CommandProvider.playerManagerResave(name, this.comment);
            class_5250 clickResave = TextProvider.clickRun(command);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.save.file_already_exist", clickResave);
            return -1;
        }
        IOUtils.saveJson(file, this.toJson());
        return exists ? 1 : 0;
    }

    public void spawn(MinecraftServer server) throws CommandSyntaxException {
        if (server.method_3760().method_14566(this.fakePlayerName) != null) {
            throw CommandUtils.createException("carpet.commands.playerManager.spawn.player_exist", new Object[0]);
        }
        EntityPlayerMPFake fakePlayer = GameUtils.createFakePlayer(this.fakePlayerName, server, this.playerPos, this.yaw, this.pitch, WorldUtils.getWorld(this.dimension), this.gameMode, this.flying);
        fakePlayer.method_5660(this.sneaking);
        this.interactiveAction.startAction(fakePlayer);
        this.autoAction.startAction(fakePlayer);
    }

    public class_2561 info() {
        TextBuilder build = new TextBuilder();
        String pos = MathUtils.numberToTwoDecimalString(this.playerPos.method_10216()) + " " + MathUtils.numberToTwoDecimalString(this.playerPos.method_10214()) + " " + MathUtils.numberToTwoDecimalString(this.playerPos.method_10215());
        build.appendTranslateLine("carpet.commands.playerManager.info.pos", pos);
        build.appendTranslateLine("carpet.commands.playerManager.info.direction", MathUtils.numberToTwoDecimalString(this.yaw), MathUtils.numberToTwoDecimalString(this.pitch));
        Object[] objectArray = new Object[1];
        objectArray[0] = switch (this.dimension) {
            case "minecraft:overworld", "overworld" -> TextProvider.OVERWORLD;
            case "minecraft:the_nether", "the_nether" -> TextProvider.THE_NETHER;
            case "minecraft:the_end", "the_end" -> TextProvider.THE_END;
            default -> TextUtils.createText(this.dimension);
        };
        build.appendTranslateLine("carpet.commands.playerManager.info.dimension", objectArray);
        build.appendTranslateLine("carpet.commands.playerManager.info.gamemode", this.gameMode.method_8383());
        build.appendTranslateLine("carpet.commands.playerManager.info.flying", TextProvider.getBoolean(this.flying));
        build.appendTranslateLine("carpet.commands.playerManager.info.sneaking", TextProvider.getBoolean(this.sneaking));
        build.appendTranslate("carpet.commands.playerManager.info.autologin", TextProvider.getBoolean(this.autologin));
        if (this.interactiveAction.hasAction()) {
            build.newLine().append(this.interactiveAction.toText());
        }
        if (this.autoAction.hasAction()) {
            build.newLine().append(this.autoAction.toText());
        }
        if (this.comment.hasContent()) {
            build.newLine().appendTranslate("carpet.commands.playerManager.info.comment", this.comment.getText());
        }
        return build.toLine();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)1);
        JsonObject pos = new JsonObject();
        pos.addProperty("x", (Number)this.playerPos.field_1352);
        pos.addProperty("y", (Number)this.playerPos.field_1351);
        pos.addProperty("z", (Number)this.playerPos.field_1350);
        json.add("pos", (JsonElement)pos);
        JsonObject direction = new JsonObject();
        direction.addProperty("yaw", (Number)Float.valueOf(this.yaw));
        direction.addProperty("pitch", (Number)Float.valueOf(this.pitch));
        json.add("direction", (JsonElement)direction);
        json.addProperty("dimension", this.dimension);
        json.addProperty("gamemode", this.gameMode.method_8381());
        json.addProperty("flying", Boolean.valueOf(this.flying));
        json.addProperty("sneaking", Boolean.valueOf(this.sneaking));
        json.addProperty("autologin", Boolean.valueOf(this.autologin));
        json.addProperty("annotation", this.comment.getComment());
        json.add("hand_action", (JsonElement)this.interactiveAction.toJson());
        json.add(SCRIPT_ACTION, (JsonElement)this.autoAction.toJson());
        return json;
    }

    public void setComment(@Nullable String comment) {
        this.comment.setComment(comment);
    }

    public void setAutologin(boolean autologin) {
        this.autologin = autologin;
    }

    public String getFakePlayerName() {
        return this.fakePlayerName;
    }

    public class_2561 getDisplayName() {
        return TextUtils.hoverText(this.fakePlayerName, this.info());
    }

    public static int list(CommandContext<class_2168> context, WorldFormat worldFormat, Predicate<String> filter) {
        class_5250 online = TextUtils.translate("carpet.commands.playerManager.click.online", new Object[0]);
        class_5250 offline = TextUtils.translate("carpet.commands.playerManager.click.offline", new Object[0]);
        int count = 0;
        List<File> jsonFileList = worldFormat.toImmutableFileList(WorldFormat.JSON_EXTENSIONS);
        for (File file : jsonFileList) {
            try {
                FakePlayerSerializer serial = FakePlayerSerializer.factory(worldFormat, file.getName());
                if (!filter.test(serial.comment.getComment()) && !filter.test(serial.fakePlayerName.toLowerCase(Locale.ROOT))) continue;
                FakePlayerSerializer.eachPlayer(context, file, online, offline, serial);
                ++count;
            }
            catch (IOException | RuntimeException e) {
                CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u4ece\u6587\u4ef6{}\u52a0\u8f7d\u73a9\u5bb6\u4fe1\u606f", (Object)file.getName(), (Object)e);
            }
        }
        return count;
    }

    private static void eachPlayer(CommandContext<class_2168> context, File file, class_5250 online, class_5250 offline, FakePlayerSerializer serial) {
        String playerName = IOUtils.removeExtension(file.getName(), ".json");
        String onlineCommand = CommandProvider.playerManagerSpawn(playerName);
        String offlineCommand = CommandProvider.killFakePlayer(playerName);
        class_5250 mutableText = TextUtils.appendAll(TextUtils.command(TextUtils.createText("[\u2191]"), onlineCommand, (class_2561)online, class_124.field_1060, false), " ", TextUtils.command(TextUtils.createText("[\u2193]"), offlineCommand, (class_2561)offline, class_124.field_1061, false), " ", TextUtils.hoverText(TextUtils.createText("[?]"), serial.info(), class_124.field_1080), " ", serial.comment.hasContent() ? TextUtils.hoverText(playerName, serial.comment.getText()) : playerName);
        MessageUtils.sendMessage((class_2168)context.getSource(), (class_2561)mutableText);
    }

    public static void autoLogin(MinecraftServer server) {
        ServerTaskManager manager = ServerComponentCoordinator.getManager(server).getServerTaskManager();
        try {
            FakePlayerSerializer.tryAutoLogin(server, manager);
        }
        catch (CommandSyntaxException | RuntimeException e) {
            CarpetOrgAddition.LOGGER.error("\u73a9\u5bb6\u81ea\u52a8\u767b\u5f55\u51fa\u73b0\u610f\u5916\u9519\u8bef", e);
        }
    }

    private static void tryAutoLogin(MinecraftServer server, ServerTaskManager manager) throws CommandSyntaxException {
        WorldFormat worldFormat = new WorldFormat(server, PLAYER_DATA, new String[0]);
        List<File> files = worldFormat.toImmutableFileList(WorldFormat.JSON_EXTENSIONS);
        int count = server.method_3788();
        for (File file : files) {
            FakePlayerSerializer fakePlayerSerializer;
            try {
                fakePlayerSerializer = FakePlayerSerializer.factory(worldFormat, file.getName());
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u8bfb\u53d6{}\u73a9\u5bb6\u6570\u636e", (Object)IOUtils.removeExtension(file.getName(), ".json"), (Object)e);
                continue;
            }
            if (!fakePlayerSerializer.autologin) continue;
            manager.addTask(new DelayedLoginTask(server, fakePlayerSerializer, 1L));
            if (++count < server.method_3802() - 1) continue;
            CarpetOrgAddition.LOGGER.warn("\u670d\u52a1\u5668\u73a9\u5bb6\u5373\u5c06\u8fbe\u5230\u4e0a\u9650");
            return;
        }
    }
}

