/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerActionManager;
import org.carpetorgaddition.periodic.fakeplayer.action.StopAction;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.wheel.TextBuilder;
import org.jetbrains.annotations.NotNull;

public class FakePlayerActionSerializer {
    private final AbstractPlayerAction action;
    public static final FakePlayerActionSerializer NO_ACTION = new FakePlayerActionSerializer();

    private FakePlayerActionSerializer() {
        this.action = new StopAction(null);
    }

    public FakePlayerActionSerializer(EntityPlayerMPFake fakePlayer) {
        FakePlayerActionManager actionManager = GenericFetcherUtils.getFakePlayerActionManager(fakePlayer);
        this.action = actionManager.getAction();
    }

    public FakePlayerActionSerializer(JsonObject json) {
        for (ActionSerializeType value : ActionSerializeType.values()) {
            String serializedName = value.getSerializedName();
            if (!json.has(serializedName)) continue;
            JsonObject actionJson = json.getAsJsonObject(serializedName);
            AbstractPlayerAction deserialize = value.deserialize(actionJson);
            if (!deserialize.isValid()) break;
            this.action = deserialize;
            return;
        }
        this.action = new StopAction(null);
    }

    public void startAction(@NotNull EntityPlayerMPFake fakePlayer) {
        if (this == NO_ACTION || this.action.isStop()) {
            return;
        }
        if (this.action.getFakePlayer() == null) {
            this.action.setFakePlayer(fakePlayer);
        } else if (!this.action.getFakePlayer().equals((Object)fakePlayer)) {
            throw new IllegalArgumentException();
        }
        FakePlayerActionManager actionManager = GenericFetcherUtils.getFakePlayerActionManager(fakePlayer);
        actionManager.setAction(this.action);
    }

    public boolean hasAction() {
        return !this.action.isStop();
    }

    public class_2561 toText() {
        TextBuilder builder = new TextBuilder();
        builder.appendTranslate("carpet.commands.playerManager.info.action", new Object[0]).newLine().indentation().append((class_2561)this.action.getDisplayName());
        return builder.toLine();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.action.isHidden()) {
            StopAction stopAction = new StopAction(null);
            json.add(stopAction.getActionSerializeType().getSerializedName(), (JsonElement)stopAction.toJson());
        } else {
            json.add(this.action.getActionSerializeType().getSerializedName(), (JsonElement)this.action.toJson());
        }
        return json;
    }
}

