/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.inventory.AutoGrowInventory;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.TextBuilder;

public class InventoryCraftAction
extends AbstractPlayerAction {
    private final ItemStackPredicate[] predicates = new ItemStackPredicate[4];

    public InventoryCraftAction(EntityPlayerMPFake fakePlayer, ItemStackPredicate[] predicates) {
        super(fakePlayer);
        if (predicates.length != 4) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(predicates, 0, this.predicates, 0, this.predicates.length);
    }

    @Override
    public void tick() {
        AutoGrowInventory inventory = new AutoGrowInventory();
        this.inventoryCraft(inventory);
        for (class_1799 itemStack : inventory) {
            this.fakePlayer.method_7329(itemStack, false, true);
        }
    }

    private void inventoryCraft(AutoGrowInventory inventory) {
        int successCount;
        block13: {
            block14: {
                class_1723 playerScreenHandler = this.fakePlayer.field_7498;
                int craftCount = 0;
                int loopCount = 0;
                do {
                    if (++loopCount > 1200) {
                        throw new InfiniteLoopException();
                    }
                    successCount = 0;
                    block1: for (int craftIndex = 1; craftIndex <= 4; ++craftIndex) {
                        ItemStackPredicate matcher = this.predicates[craftIndex - 1];
                        class_1735 slot = playerScreenHandler.method_7611(craftIndex);
                        if (slot.method_7681()) {
                            if (matcher.test(slot.method_7677())) {
                                ++successCount;
                                continue;
                            }
                            FakePlayerUtils.throwItem((class_1703)playerScreenHandler, craftIndex, this.fakePlayer);
                        } else if (matcher.isEmpty()) {
                            ++successCount;
                            continue;
                        }
                        int size = playerScreenHandler.field_7761.size();
                        for (int inventoryIndex = 5; inventoryIndex < size; ++inventoryIndex) {
                            class_1799 contentItemStack;
                            class_1799 itemStack = playerScreenHandler.method_7611(inventoryIndex).method_7677();
                            if (matcher.test(itemStack)) {
                                if (FakePlayerUtils.withKeepPickupAndMoveItemStack((class_1703)playerScreenHandler, inventoryIndex, craftIndex, this.fakePlayer)) {
                                    ++successCount;
                                    continue block1;
                                }
                            } else if (CarpetOrgAdditionSettings.fakePlayerCraftPickItemFromShulkerBox && InventoryUtils.isShulkerBoxItem(itemStack) && !(contentItemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, matcher)).method_7960()) {
                                FakePlayerUtils.dropCursorStack((class_1703)playerScreenHandler, this.fakePlayer);
                                playerScreenHandler.method_34254(contentItemStack);
                                FakePlayerUtils.pickupCursorStack((class_1703)playerScreenHandler, craftIndex, this.fakePlayer);
                                ++successCount;
                                continue block1;
                            }
                            if (craftIndex != 4 || inventoryIndex != size - 1) continue;
                            return;
                        }
                    }
                    if (successCount != 4) break block13;
                    if (!playerScreenHandler.method_7611(0).method_7681()) break block14;
                    FakePlayerUtils.collectItem((class_1703)playerScreenHandler, 0, inventory, this.fakePlayer);
                } while (!FakePlayerUtils.shouldStop(++craftCount));
                return;
            }
            FakePlayerUtils.stopCraftAction(this.fakePlayer.method_64396(), this.fakePlayer);
            return;
        }
        if (successCount > 4) {
            throw new IllegalStateException(this.fakePlayer.method_5477().getString() + "\u627e\u5230\u6b63\u786e\u5408\u6210\u6750\u6599\u7684\u6b21\u6570\u4e3a" + successCount + "\uff0c\u6b63\u5e38\u4e0d\u5e94\u8be5\u8d85\u8fc74");
        }
    }

    @Override
    public ArrayList<class_5250> info() {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        class_2561 playerName = this.fakePlayer.method_5476();
        class_1799 craftOutput = ItemStackPredicate.getCraftOutput(this.predicates, 2, this.fakePlayer);
        class_2561 itemText = craftOutput.method_7960() ? TextUtils.translate("carpet.command.item.item", new Object[0]) : craftOutput.method_7909().method_63680();
        list.add(TextUtils.translate("carpet.commands.playerAction.info.craft.result", playerName, itemText));
        this.addCraftRecipe(list, craftOutput);
        list.add(TextUtils.translate("carpet.commands.playerAction.info.craft.state", playerName));
        class_1723 playerScreenHandler = this.fakePlayer.field_7498;
        this.addCraftGridState(list, playerScreenHandler);
        return list;
    }

    private void addCraftRecipe(ArrayList<class_5250> list, class_1799 craftOutput) {
        list.add(new TextBuilder().indentation().append(this.predicates[0].getInitialUpperCase()).blank().append(this.predicates[1].getInitialUpperCase()).toLine());
        TextBuilder builder = new TextBuilder().indentation().append(this.predicates[2].getInitialUpperCase()).blank().append(this.predicates[3].getInitialUpperCase());
        if (!craftOutput.method_7960()) {
            builder.appendString(" -> ").append((class_2561)FakePlayerUtils.getWithCountHoverText(craftOutput));
        }
        list.add(builder.toLine());
    }

    private void addCraftGridState(ArrayList<class_5250> list, class_1723 playerScreenHandler) {
        list.add(TextUtils.appendAll("    ", FakePlayerUtils.getWithCountHoverText(playerScreenHandler.method_7611(1).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(playerScreenHandler.method_7611(2).method_7677())));
        list.add(TextUtils.appendAll("    ", FakePlayerUtils.getWithCountHoverText(playerScreenHandler.method_7611(3).method_7677()), " ", FakePlayerUtils.getWithCountHoverText(playerScreenHandler.method_7611(4).method_7677()), " -> ", FakePlayerUtils.getWithCountHoverText(playerScreenHandler.method_7611(0).method_7677())));
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (int i = 0; i < this.predicates.length; ++i) {
            json.addProperty(String.valueOf(i), this.predicates[i].toString());
        }
        return json;
    }

    @Override
    public class_5250 getDisplayName() {
        return TextUtils.translate("carpet.commands.playerAction.action.inventory_craft", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.INVENTORY_CRAFT;
    }
}

