/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_5250;
import net.minecraft.class_7265;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.ItemStackStatistics;
import org.carpetorgaddition.util.wheel.SelectionArea;

public class ItemSearchTask
extends ServerTask {
    private final class_1937 world;
    private final SelectionArea selectionArea;
    private final CommandContext<class_2168> context;
    private Iterator<class_1297> entitySearchIterator;
    private Iterator<class_2338> blockSearchIterator;
    private FindState findState;
    private int count;
    private boolean shulkerBox;
    private long startTime;
    private int tickCount;
    private final ItemStackPredicate predicate;
    private final ArrayList<Result> results = new ArrayList();

    public ItemSearchTask(class_1937 world, ItemStackPredicate predicate, SelectionArea selectionArea, CommandContext<class_2168> context) {
        this.world = world;
        this.selectionArea = selectionArea;
        this.findState = FindState.BLOCK;
        this.tickCount = 0;
        this.predicate = predicate;
        this.context = context;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void tick() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void searchFromContainer() {
        if (this.blockSearchIterator == null) {
            this.blockSearchIterator = this.selectionArea.iterator();
        }
        while (this.blockSearchIterator.hasNext()) {
            class_5250 class_52502;
            if (this.timeout()) {
                return;
            }
            class_2338 blockPos = this.blockSearchIterator.next();
            class_2586 blockEntity = this.world.method_8321(blockPos);
            if (!(blockEntity instanceof class_1263)) continue;
            class_1263 inventory = (class_1263)blockEntity;
            if (inventory instanceof class_2624) {
                class_2624 lockableContainer = (class_2624)inventory;
                class_52502 = lockableContainer.method_5477().method_27661();
            } else {
                class_52502 = this.world.method_8320(blockPos).method_26204().method_9518();
            }
            class_5250 containerName = class_52502;
            this.count(inventory, blockPos, containerName);
        }
        this.findState = FindState.ENTITY;
    }

    private void searchFromEntity() {
        class_238 box = this.selectionArea.toBox();
        if (this.entitySearchIterator == null) {
            this.entitySearchIterator = this.world.method_18467(class_1297.class, box).iterator();
        }
        while (this.entitySearchIterator.hasNext()) {
            if (this.timeout()) {
                return;
            }
            class_1297 entity = this.entitySearchIterator.next();
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                class_5250 drops = TextUtils.translate("carpet.commands.finder.item.drops", new Object[0]);
                this.count((class_1263)new class_1277(new class_1799[]{itemEntity.method_6983()}), itemEntity.method_24515(), drops);
                continue;
            }
            if (entity instanceof EntityPlayerMPFake) {
                EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)entity;
                this.count((class_1263)fakePlayer.method_31548(), fakePlayer.method_24515(), fakePlayer.method_5477().method_27661());
                continue;
            }
            if (!(entity instanceof class_7265)) continue;
            class_7265 inventory = (class_7265)entity;
            this.count((class_1263)inventory, entity.method_24515(), entity.method_5477().method_27661());
        }
        this.findState = FindState.SORT;
    }

    private void count(class_1263 inventory, class_2338 blockPos, class_5250 containerName) {
        ItemStackStatistics statistics = new ItemStackStatistics(this.predicate);
        statistics.statistics(inventory);
        if (statistics.getSum() == 0) {
            return;
        }
        this.count += statistics.getSum();
        if (statistics.hasNestingItem()) {
            this.shulkerBox = true;
        }
        this.results.add(new Result(blockPos, containerName, statistics));
        if (this.results.size() > 30000) {
            Runnable function = () -> MessageUtils.sendErrorMessage(this.context, "carpet.commands.finder.item.too_much_container", this.predicate.toText());
            throw new TaskExecutionException(function);
        }
    }

    private void sort() {
        if (this.results.isEmpty()) {
            MessageUtils.sendMessage((class_2168)this.context.getSource(), "carpet.commands.finder.item.find.not_item", this.predicate.toText());
            this.findState = FindState.END;
            return;
        }
        this.results.sort((o1, o2) -> o2.statistics().getSum() - o1.statistics().getSum());
        this.findState = FindState.FEEDBACK;
    }

    private void feedback() {
        class_5250 itemCount;
        boolean canConvert = this.predicate.isConvertible();
        if (canConvert) {
            itemCount = FinderCommand.showCount(this.predicate.asItem().method_7854(), this.count, this.shulkerBox);
        } else {
            class_5250 countText = TextUtils.createText(this.count);
            itemCount = this.shulkerBox ? TextUtils.toItalic(countText) : countText;
        }
        int size = this.results.size();
        if (size > CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount) {
            MessageUtils.sendMessage((class_2168)this.context.getSource(), "carpet.commands.finder.item.find.limit", size, itemCount, this.predicate.toText(), CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount);
        } else {
            MessageUtils.sendMessage((class_2168)this.context.getSource(), "carpet.commands.finder.item.find", size, itemCount, this.predicate.toText());
        }
        for (int i = 0; i < size && i < CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount; ++i) {
            class_5250 message = this.results.get(i).toText();
            MessageUtils.sendMessage((class_2168)this.context.getSource(), (class_2561)message);
        }
        this.findState = FindState.END;
    }

    private boolean timeout() {
        return System.currentTimeMillis() - this.startTime > 200L;
    }

    @Override
    public boolean stopped() {
        return this.findState == FindState.END;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(((class_2168)this.context.getSource()).method_44023());
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            return Objects.equals(((class_2168)this.context.getSource()).method_44023(), ((class_2168)((ItemSearchTask)obj).context.getSource()).method_44023());
        }
        return false;
    }

    @Override
    public String getLogName() {
        return "\u7269\u54c1\u67e5\u627e";
    }

    private static enum FindState {
        BLOCK,
        ENTITY,
        SORT,
        FEEDBACK,
        END;

    }

    private record Result(class_2338 blockPos, class_5250 containerName, ItemStackStatistics statistics) {
        private class_5250 toText() {
            return TextUtils.translate("carpet.commands.finder.item.each", TextProvider.blockPos(this.blockPos, class_124.field_1060), this.containerName, this.statistics.getCountText());
        }
    }
}

