/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_4284;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.periodic.task.search.OfflinePlayerItemSearchContext;
import org.carpetorgaddition.util.GameUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.inventory.SimulatePlayerInventory;
import org.carpetorgaddition.util.provider.CommandProvider;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.ItemStackStatistics;
import org.carpetorgaddition.util.wheel.UuidNameMappingTable;
import org.carpetorgaddition.util.wheel.WorldFormat;

public class OfflinePlayerSearchTask
extends ServerTask {
    private final AtomicInteger threadCount = new AtomicInteger();
    private final AtomicInteger itemCount = new AtomicInteger();
    private final AtomicInteger skipCount = new AtomicInteger();
    private final AtomicInteger ignoreCount = new AtomicInteger();
    private final AtomicBoolean shulkerBox = new AtomicBoolean(false);
    private int total = 0;
    private final class_2168 source;
    private final class_3312 userCache;
    protected final class_3222 player;
    private final MinecraftServer server;
    private final File[] files;
    private final ItemStackPredicate predicate;
    private final boolean showUnknown;
    private State taksState = State.START;
    private final ReentrantLock lock = new ReentrantLock();
    private final ArrayList<Result> list = new ArrayList();
    private final WorldFormat tempFileDirectory;

    public OfflinePlayerSearchTask(OfflinePlayerItemSearchContext context) {
        this.source = context.source();
        this.predicate = context.predicate();
        this.userCache = context.userCache();
        this.player = context.player();
        this.server = this.player.field_13995;
        this.files = context.files();
        this.showUnknown = context.showUnknown();
        this.tempFileDirectory = new WorldFormat(this.server, "temp", "playerdata");
    }

    @Override
    protected void tick() {
        switch (this.taksState.ordinal()) {
            case 0: {
                for (File file : this.files) {
                    if (!file.getName().endsWith(".dat")) continue;
                    this.createVirtualThread(file);
                    ++this.total;
                }
                this.taksState = State.RUNTIME;
                break;
            }
            case 1: {
                if (this.threadCount.get() != 0) break;
                this.taksState = State.FEEDBACK;
                break;
            }
            case 2: {
                this.sendFeedback();
                this.taksState = State.STOP;
                break;
            }
        }
    }

    private void createVirtualThread(File unsafe) {
        this.threadCount.getAndIncrement();
        Thread.ofVirtual().start(() -> {
            try {
                class_2487 maybeOldNbt = class_2507.method_30613((Path)unsafe.toPath(), (class_2505)class_2505.method_53898());
                int version = class_2512.method_48309((class_2487)maybeOldNbt, (int)-1);
                if (version >= GameUtils.getNbtDataVersion()) {
                    this.searchItem(unsafe, maybeOldNbt, version, false);
                } else {
                    File deletableFile = this.tempFileDirectory.file(unsafe.getName());
                    IOUtils.copyFile(unsafe, deletableFile);
                    this.searchItem(deletableFile, maybeOldNbt, version, true);
                    if (deletableFile.delete()) {
                        return;
                    }
                    CarpetOrgAddition.LOGGER.warn("\u672a\u6210\u529f\u5220\u9664\u4e34\u65f6\u6587\u4ef6{}", (Object)deletableFile.getName());
                }
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u4ece\u6587\u4ef6\u8bfb\u53d6\u73a9\u5bb6\u6570\u636e\uff1a", (Throwable)e);
            }
            finally {
                this.threadCount.getAndDecrement();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchItem(File file, class_2487 maybeOldNbt, int version, boolean needToUpgrade) {
        UUID uuid;
        String uuidString = file.getName().split("\\.")[0];
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            this.ignoreCount.getAndIncrement();
            CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u4ece\u6587\u4ef6\u540d\u89e3\u6790UUID\uff0c\u6b63\u5728\u5ffd\u7565\u6587\u4ef6\uff1a{}", (Object)file.getName());
            return;
        }
        UuidNameMappingTable table = UuidNameMappingTable.getInstance();
        Optional<GameProfile> optional = table.fetchGameProfileWithBackup(this.userCache, uuid);
        boolean unknownPlayer = false;
        if (optional.isEmpty()) {
            if (this.showUnknown) {
                optional = Optional.of(new GameProfile(uuid, "[Unknown]"));
                unknownPlayer = true;
            } else {
                this.skipCount.incrementAndGet();
                return;
            }
        }
        GameProfile gameProfile = optional.get();
        if (this.server.method_3760().method_14566(gameProfile.getName()) != null) {
            return;
        }
        DataFixer dataFixer = this.server.method_3855();
        class_2487 nbt = needToUpgrade ? class_4284.field_19213.method_48130(dataFixer, maybeOldNbt, version) : maybeOldNbt;
        class_1263 inventory = this.getInventory(nbt);
        ItemStackStatistics statistics = new ItemStackStatistics(this.predicate);
        statistics.statistics(inventory);
        if (statistics.getSum() == 0) {
            return;
        }
        this.itemCount.addAndGet(statistics.getSum());
        if (statistics.hasNestingItem()) {
            this.shulkerBox.set(true);
        }
        Result result = new Result(gameProfile, statistics, unknownPlayer);
        try {
            this.lock.lock();
            this.list.add(result);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected class_1263 getInventory(class_2487 nbt) {
        return SimulatePlayerInventory.of(nbt, this.player.method_5682());
    }

    private void sendFeedback() {
        if (this.list.isEmpty()) {
            MessageUtils.sendMessage(this.source, "carpet.commands.finder.item.offline_player.not_found", this.getInventoryName(), this.predicate.toText());
            return;
        }
        this.list.sort((o1, o2) -> o2.statistics().getSum() - o1.statistics().getSum());
        class_5250 hoverPrompt = TextUtils.translate("carpet.commands.finder.item.offline_player.prompt", this.getInventoryName());
        class_2561 itemCount = this.getItemCount();
        class_2561 numberOfPeople = this.getNumberOfPeople();
        class_5250 message = this.getFirstFeedback(numberOfPeople, itemCount);
        MessageUtils.sendMessage(this.source, (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hoverPrompt));
        int skip = this.skipCount.get();
        if (skip != 0) {
            class_5250 translate = TextUtils.translate("carpet.commands.finder.item.offline_player.skip", skip);
            class_5250 grayItalic = TextUtils.toGrayItalic(translate);
            MessageUtils.sendMessage(this.source, (class_2561)grayItalic);
        }
        for (int i = 0; i < Math.min(this.list.size(), CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount); ++i) {
            Result result = this.list.get(i);
            this.sendEveryFeedback(result);
        }
    }

    private class_5250 getFirstFeedback(class_2561 numberOfPeople, class_2561 itemCount) {
        if (this.list.size() > CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount) {
            return TextUtils.translate("carpet.commands.finder.item.offline_player.limit", numberOfPeople, this.getInventoryName(), itemCount, this.predicate.toText(), CarpetOrgAdditionSettings.finderCommandMaxFeedbackCount);
        }
        return TextUtils.translate("carpet.commands.finder.item.offline_player", numberOfPeople, this.getInventoryName(), itemCount, this.predicate.toText());
    }

    private class_2561 getItemCount() {
        if (this.predicate.isConvertible()) {
            return FinderCommand.showCount(this.predicate.asItem().method_7854(), this.itemCount.get(), this.shulkerBox.get());
        }
        class_5250 text = TextUtils.createText(Integer.toString(this.itemCount.get()));
        return this.shulkerBox.get() ? TextUtils.toItalic(text) : text;
    }

    private class_2561 getNumberOfPeople() {
        ArrayList<class_5250> peopleHover = new ArrayList<class_5250>();
        peopleHover.add(TextUtils.translate("carpet.commands.finder.item.offline_player.total", this.total - this.ignoreCount.get()));
        peopleHover.add(TextUtils.translate("carpet.commands.finder.item.offline_player.found", this.list.size()));
        if (!this.showUnknown) {
            peopleHover.add(TextUtils.translate("carpet.commands.finder.item.offline_player.skipped", this.skipCount.get()));
        }
        return TextUtils.hoverText((class_2561)TextUtils.createText(this.list.size()), (class_2561)TextUtils.appendList(peopleHover));
    }

    private void sendEveryFeedback(Result result) {
        class_5250 playerName;
        String name = result.gameProfile.getName();
        String uuid = result.gameProfile().getId().toString();
        class_5250 hover = TextUtils.appendAll(TextUtils.createText("UUID: %s\n".formatted(uuid)), TextProvider.COPY_CLICK);
        class_2561 count = result.statistics().getCountText();
        if (result.isUnknown()) {
            playerName = TextUtils.copy(name, uuid, (class_2561)hover, class_124.field_1080);
        } else {
            String command = CommandProvider.spawnFakePlayer(result.gameProfile().getName());
            class_5250 clickLogin = TextUtils.translate("carpet.command.text.click.login", new Object[0]);
            class_5250 button = TextUtils.command(TextUtils.createText(" [\u2191]"), command, (class_2561)clickLogin, class_124.field_1080);
            playerName = TextUtils.appendAll(TextUtils.copy("[" + name + "]", name, (class_2561)hover, class_124.field_1080), button);
        }
        class_5250 translate = TextUtils.translate("carpet.commands.finder.item.offline_player.each", playerName, this.getInventoryName(), count);
        if (result.isUnknown()) {
            class_5250 button = TextUtils.appendAll(TextUtils.translate("carpet.commands.finder.item.offline_player.query.name", new Object[0]), "\n", TextUtils.setColor(TextUtils.translate("carpet.commands.finder.item.offline_player.query.non_authentic", new Object[0]), class_124.field_1061));
            class_5250 command = TextUtils.command(TextUtils.createText("[\ud83d\udd0d]"), CommandProvider.queryPlayerName(result.gameProfile().getId()), (class_2561)button, class_124.field_1075, false);
            translate = TextUtils.appendAll(TextUtils.toStrikethrough(translate), " ", command);
        }
        MessageUtils.sendMessage(this.source, (class_2561)translate);
    }

    protected class_2561 getInventoryName() {
        return TextUtils.translate("container.inventory", new Object[0]);
    }

    @Override
    protected boolean stopped() {
        return this.taksState == State.STOP;
    }

    @Override
    public String getLogName() {
        return "\u4ece\u79bb\u7ebf\u73a9\u5bb6\u7269\u54c1\u680f\u5bfb\u627e\u7269\u54c1";
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return Objects.equals(this.player, ((OfflinePlayerSearchTask)o).player);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.player);
    }

    private static enum State {
        START,
        RUNTIME,
        FEEDBACK,
        STOP;

    }

    private record Result(GameProfile gameProfile, ItemStackStatistics statistics, boolean isUnknown) {
    }
}

