/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_3988;
import net.minecraft.class_5250;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.periodic.task.search.AbstractTradeSearchTask;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.SelectionArea;

public class TradeItemSearchTask
extends AbstractTradeSearchTask {
    private final ItemStackPredicate predicate;
    private final class_5250 treadName;

    public TradeItemSearchTask(class_1937 world, SelectionArea selectionArea, class_2338 sourcePos, ItemStackPredicate predicate, CommandContext<class_2168> context) {
        super(world, selectionArea, sourcePos, context);
        this.predicate = predicate;
        this.treadName = predicate.toText().method_27661();
    }

    @Override
    protected void searchVillager(class_3988 merchant) {
        class_1916 offers = merchant.method_8264();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int index = 0; index < offers.size(); ++index) {
            if (!this.predicate.test(((class_1914)offers.get(index)).method_8250())) continue;
            list.add(index + 1);
            ++this.tradeCount;
        }
        if (list.isEmpty()) {
            return;
        }
        this.results.add(this.getResult(merchant, list));
        ++this.villagerCount;
    }

    private AbstractTradeSearchTask.Result getResult(final class_3988 merchant, final ArrayList<Integer> list) {
        return new AbstractTradeSearchTask.Result(){

            @Override
            public int compare(AbstractTradeSearchTask.Result o1, AbstractTradeSearchTask.Result o2) {
                return MathUtils.compareBlockPos(TradeItemSearchTask.this.sourcePos, o1.villagerPos(), o2.villagerPos());
            }

            @Override
            public class_5250 toText() {
                class_2338 blockPos = merchant.method_24515();
                class_5250 villagerName = merchant.method_5477().method_27661();
                return TextUtils.translate("carpet.commands.finder.trade.item.each", TextProvider.blockPos(blockPos, class_124.field_1060), villagerName, AbstractTradeSearchTask.getIndexArray(list));
            }

            @Override
            public class_2338 villagerPos() {
                return merchant.method_24515();
            }
        };
    }

    @Override
    protected void notFound() {
        MessageUtils.sendMessage((class_2168)this.context.getSource(), "carpet.commands.finder.trade.find.not_trade", this.getTradeName(), FinderCommand.VILLAGER);
    }

    @Override
    protected class_5250 getTradeName() {
        return this.treadName;
    }

    @Override
    protected String getResultLimitKey() {
        return "carpet.commands.finder.trade.result.limit";
    }
}

