/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.carpetorgaddition.util.GameUtils;
import org.carpetorgaddition.util.TextUtils;

public class CommandUtils {
    public static final String PLAYER = "player";

    private CommandUtils() {
    }

    public static class_3222 getSourcePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandUtils.getSourcePlayer((class_2168)context.getSource());
    }

    public static class_3222 getSourcePlayer(class_2168 source) throws CommandSyntaxException {
        return source.method_9207();
    }

    public static class_3222 getArgumentPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return class_2186.method_9315(context, (String)PLAYER);
    }

    public static EntityPlayerMPFake getArgumentFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)PLAYER);
        CommandUtils.assertFakePlayer((class_1657)player);
        return (EntityPlayerMPFake)player;
    }

    public static boolean isSelfOrFakePlayer(class_3222 player, CommandContext<class_2168> context) {
        return CommandUtils.isSelfOrFakePlayer(player, (class_2168)context.getSource());
    }

    public static boolean isSelfOrFakePlayer(class_3222 player, class_2168 source) {
        return CommandUtils.isSpecifiedOrFakePlayer(player, source.method_44023());
    }

    public static boolean isSpecifiedOrFakePlayer(class_3222 player, class_3222 specified) {
        return player == specified || player instanceof EntityPlayerMPFake;
    }

    public static CommandSyntaxException createException(String key, Object ... obj) {
        return new SimpleCommandExceptionType((Message)TextUtils.translate(key, obj)).create();
    }

    public static CommandSyntaxException createException(Throwable e, String key, Object ... obj) {
        String exceptionMessage = GameUtils.getExceptionString(e);
        class_5250 message = TextUtils.translate(key, obj);
        return new SimpleCommandExceptionType((Message)TextUtils.hoverText(message, exceptionMessage)).create();
    }

    public static CommandSyntaxException createEntityNotFoundException() {
        return class_2186.field_9863.create();
    }

    public static CommandSyntaxException createPlayerNotFoundException() {
        return class_2186.field_9856.create();
    }

    public static CommandSyntaxException createIOErrorException(IOException e) {
        return CommandUtils.createException(e, "carpet.command.error.io", new Object[0]);
    }

    public static CommandSyntaxException createOperationTimeoutException() {
        return CommandUtils.createException("carpet.command.operation.timeout", new Object[0]);
    }

    public static CommandSyntaxException createSelfOrFakePlayerException() {
        return CommandUtils.createException("carpet.command.self_or_fake_player", new Object[0]);
    }

    public static void assertFakePlayer(class_1657 fakePlayer) throws CommandSyntaxException {
        if (fakePlayer instanceof EntityPlayerMPFake) {
            return;
        }
        throw CommandUtils.createException("carpet.command.not_fake_player", fakePlayer.method_5476());
    }

    public static UUID parseUuidFromString(String uuid) throws CommandSyntaxException {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw CommandUtils.createException("carpet.command.uuid.parse.fail", new Object[0]);
        }
    }

    public static void execute(class_3222 player, String command) {
        CommandUtils.execute(player.method_64396(), command);
    }

    public static void execute(class_2168 source, String command) {
        class_2170 commandManager = source.method_9211().method_3734();
        commandManager.method_44252(source, command);
    }
}

