/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import org.carpetorgaddition.CarpetOrgAddition;
import org.jetbrains.annotations.Contract;

public class IOUtils {
    public static final String JSON_EXTENSION = ".json";
    public static final String NBT_EXTENSION = ".nbt";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIGURE_DIRECTORY = FabricLoader.getInstance().getConfigDir().resolve(CarpetOrgAddition.MOD_NAME_LOWER_CASE);
    public static final String INVALID_FILENAME_CHARS = "\\/:*?\"<>|";
    public static final String[] WINDOWS_RESERVED_NAME = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    private IOUtils() {
    }

    public static BufferedReader toReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
    }

    public static BufferedWriter toWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8));
    }

    public static void saveJson(File file, JsonObject json) throws IOException {
        String jsonString = GSON.toJson((Object)json, JsonObject.class);
        try (BufferedWriter writer = IOUtils.toWriter(file);){
            writer.write(jsonString);
        }
    }

    public static JsonObject loadJson(File file) throws IOException {
        BufferedReader reader;
        try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
    }

    public static boolean createFileIfNotExists(File file) {
        if (file.isFile()) {
            return true;
        }
        File parent = file.getParentFile();
        if (parent.isDirectory() || parent.mkdirs()) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static void copyFile(File original, File copy) {
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(original));
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(copy));
            try (BufferedInputStream bufferedInputStream = input;
                 BufferedOutputStream bufferedOutputStream = output;){
                int len;
                byte[] bytes = new byte[8192];
                while ((len = input.read(bytes)) != -1) {
                    output.write(bytes, 0, len);
                }
            }
        }
        catch (IOException e) {
            IOUtils.loggerError(e);
        }
    }

    public static void backup(File file) {
        File backup = new File(file.getParent(), file.getName() + ".bak");
        IOUtils.copyFile(file, backup);
    }

    public static boolean jsonHasElement(JsonObject json, String ... elements) {
        for (String element : elements) {
            if (json.has(element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(String fileName) {
        if (fileName.startsWith(".")) {
            return true;
        }
        int index = fileName.indexOf(".");
        String substring = (index == -1 ? fileName : fileName.substring(0, index)).toUpperCase(Locale.ROOT);
        for (String str : WINDOWS_RESERVED_NAME) {
            if (!Objects.equals(str, substring)) continue;
            return true;
        }
        for (int i = 0; i < INVALID_FILENAME_CHARS.length(); ++i) {
            char c = INVALID_FILENAME_CHARS.charAt(i);
            if (!fileName.contains(String.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    public static File createConfigFile(String fileName, boolean create) {
        File file = CONFIGURE_DIRECTORY.resolve(fileName).toFile();
        if (create) {
            IOUtils.createFileIfNotExists(file);
        }
        return file;
    }

    @Contract(value="_,_,!null,_ -> !null")
    public static <T> T getJsonElement(JsonObject json, String key, T defaultValue, Class<T> type) {
        JsonElement element = json.get(key);
        if (element == null) {
            return defaultValue;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return type.cast(element.getAsBoolean());
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return type.cast(element.getAsByte());
        }
        if (type == Short.TYPE || type == Short.class) {
            return type.cast(element.getAsShort());
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return type.cast(element.getAsInt());
        }
        if (type == Long.TYPE || type == Long.class) {
            return type.cast(element.getAsLong());
        }
        if (type == Float.TYPE || type == Float.class) {
            return type.cast(Float.valueOf(element.getAsFloat()));
        }
        if (type == Double.TYPE || type == Double.class) {
            return type.cast(element.getAsDouble());
        }
        if (type == String.class) {
            return type.cast(element.getAsString());
        }
        if (JsonObject.class.isAssignableFrom(type)) {
            return type.cast(element.getAsJsonObject());
        }
        if (JsonArray.class.isAssignableFrom(type)) {
            return type.cast(element.getAsJsonArray());
        }
        throw new IllegalArgumentException();
    }

    public static <T> Optional<T> getJsonElement(JsonObject json, String key, Class<T> type) {
        return Optional.ofNullable(IOUtils.getJsonElement(json, key, null, type));
    }

    @Deprecated(forRemoval=true)
    public static String removeJsonExtension(String fileName) {
        if (fileName.endsWith(JSON_EXTENSION)) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public static String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public static String removeExtension(String fileName, String extension) {
        String extensionNameLowerCase;
        String fineNameLowerCase = fileName.toLowerCase(Locale.ROOT);
        if (fineNameLowerCase.endsWith(extensionNameLowerCase = ((String)(extension.startsWith(".") ? extension : "." + extension)).toLowerCase(Locale.ROOT))) {
            return IOUtils.removeExtension(fileName);
        }
        return fileName;
    }

    public static void loggerError(IOException e) {
        CarpetOrgAddition.LOGGER.error("IO error occurred:", (Throwable)e);
    }
}

