/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.provider;

import carpet.patches.EntityPlayerMPFake;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import org.carpetorgaddition.client.command.AbstractClientCommand;
import org.carpetorgaddition.client.command.ClientCommandRegister;
import org.carpetorgaddition.client.command.HighlightCommand;
import org.carpetorgaddition.command.AbstractCommand;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.command.CommandRegister;
import org.carpetorgaddition.command.MailCommand;
import org.carpetorgaddition.command.NavigatorCommand;
import org.carpetorgaddition.command.OrangeCommand;
import org.carpetorgaddition.command.PlayerManagerCommand;
import org.carpetorgaddition.util.wheel.MetaComment;

public class CommandProvider {
    private CommandProvider() {
    }

    public static String receiveExpress(int id) {
        return "/%s receive %s".formatted(CommandProvider.getCommandName(MailCommand.class), id);
    }

    public static String cancelExpress(int id) {
        return "/%s cancel %s".formatted(CommandProvider.getCommandName(MailCommand.class), id);
    }

    public static String receiveAllExpress() {
        return "/%s receive".formatted(CommandProvider.getCommandName(MailCommand.class));
    }

    public static String cancelAllExpress() {
        return "/%s cancel".formatted(CommandProvider.getCommandName(MailCommand.class));
    }

    public static String navigateToUuidEntity(UUID uuid) {
        return "/%s uuid \"%s\"".formatted(CommandProvider.getCommandName(NavigatorCommand.class), uuid.toString());
    }

    public static String playerManagerSpawn(String playerName) {
        return "/%s spawn %s".formatted(CommandProvider.getCommandName(PlayerManagerCommand.class), playerName);
    }

    public static String playerManagerResave(String playerName, MetaComment comment) {
        String str = "/%s resave %s".formatted(CommandProvider.getCommandName(PlayerManagerCommand.class), playerName);
        return comment.hasContent() ? str + " \"" + comment.getComment() + "\"" : str;
    }

    public static String setupSafeAfkPermanentlyChange(EntityPlayerMPFake player, float threshold) {
        String commandName = CommandProvider.getCommandName(PlayerManagerCommand.class);
        String playerName = player.method_5477().getString();
        return "/%s safeafk set %s %s true".formatted(commandName, playerName, Float.valueOf(threshold));
    }

    public static String cancelSafeAfkPermanentlyChange(EntityPlayerMPFake player) {
        String commandName = CommandProvider.getCommandName(PlayerManagerCommand.class);
        String playerName = player.method_5477().getString();
        return "/%s safeafk set %s -1 true".formatted(commandName, playerName);
    }

    public static String spawnFakePlayer(String playerName) {
        return "/player %s spawn".formatted(playerName);
    }

    public static String killFakePlayer(String playerName) {
        return "/player %s kill".formatted(playerName);
    }

    public static String highlightWaypoint(class_2338 blockPos) {
        return "/%s %s %s %s".formatted(CommandProvider.getClientCommandName(HighlightCommand.class), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public static String highlightWaypointByOmmc(class_2338 blockPos) {
        return "/highlightWaypoint %s %s %s".formatted(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public static String queryPlayerName(UUID uuid) {
        return "/%s textclickevent queryPlayerName %s".formatted(CommandProvider.getCommandName(OrangeCommand.class), uuid.toString());
    }

    public static String stopNavigate() {
        return "%s stop".formatted(CommandProvider.getCommandName(NavigatorCommand.class));
    }

    public static String drawParticleLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        return "particleLine %s %s %s %s %s %s".formatted(x1, y1, z1, x2, y2, z2);
    }

    public static String openPlayerInventory(class_1657 player) {
        return "player %s inventory".formatted(player.method_5477().getString());
    }

    private static <T extends AbstractServerCommand> String getCommandName(Class<T> clazz) {
        return ((AbstractCommand)CommandRegister.getCommandInstance(clazz)).getAvailableName();
    }

    private static <T extends AbstractClientCommand> String getClientCommandName(Class<T> clazz) {
        return ((AbstractCommand)ClientCommandRegister.getCommandInstance(clazz)).getAvailableName();
    }
}

