/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.carpetorgaddition.exception.OperationTimeoutException;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MathUtils;

public record ExperienceTransfer(class_3222 player) {
    private static final BigInteger MAX_INTEGER_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final int MAX_EFFECTIVE_LEVEL = 238609312;
    private static final long TIMEOUT_MILLIS = 5000L;

    private int getPoint() {
        int result = class_3532.method_15375((float)(this.player.field_7510 * (float)this.player.method_7349()));
        return Math.max(result, 0);
    }

    private void clearExperience() {
        this.player.method_14252(0);
        this.player.method_14228(0);
    }

    public BigInteger transferAllTo(ExperienceTransfer transfer) {
        return this.transfer(() -> {
            BigInteger result = this.extractAllExperience();
            this.addExperience(transfer, result);
            return result;
        });
    }

    public BigInteger transferHalfTo(ExperienceTransfer transfer) {
        return this.transfer(() -> {
            BigInteger experience = this.extractAllExperience();
            BigInteger half = experience.divide(BigInteger.TWO);
            long time = System.currentTimeMillis();
            this.addExperience(transfer, half, 5000L);
            long timeElapsed = System.currentTimeMillis() - time;
            this.addExperience(this, experience.subtract(half), 5000L - timeElapsed);
            return half;
        });
    }

    public void transferTo(ExperienceTransfer transfer, BigInteger count) {
        this.transfer(() -> {
            BigInteger total = this.calculateTotalExperience();
            if (count.compareTo(total) > 0) {
                throw new ExperienceTransferException(count, total);
            }
            this.clearExperience();
            transfer.addExperience(count);
            this.addExperience(total.subtract(count));
            return count;
        });
    }

    private BigInteger transfer(Supplier<BigInteger> supplier) {
        int level = this.player.field_7520;
        int point = this.getPoint();
        try {
            return supplier.get();
        }
        catch (OperationTimeoutException e) {
            this.player.method_14252(level);
            this.player.method_14228(point);
            throw e;
        }
    }

    public boolean isSpecifiedOrFakePlayer(class_3222 specified) {
        return CommandUtils.isSpecifiedOrFakePlayer(this.player, specified);
    }

    private void addExperience(int experience) {
        this.player.method_7255(experience);
    }

    private void addExperience(BigInteger bigInteger) {
        this.addExperience(this, bigInteger);
    }

    private void addExperience(ExperienceTransfer transfer, BigInteger experience) {
        this.addExperience(transfer, experience, 5000L);
    }

    private void addExperience(ExperienceTransfer transfer, BigInteger experience, long timeout) {
        int level = transfer.player.field_7520;
        int point = transfer.getPoint();
        try {
            long time = System.currentTimeMillis();
            if (experience.compareTo(BigInteger.valueOf(100000000000L)) > 0) {
                experience = new BigDecimal(experience).multiply(new BigDecimal("0.99999999")).toBigInteger();
            } else if (experience.compareTo(BigInteger.valueOf(10000000000L)) > 0) {
                experience = new BigDecimal(experience).multiply(new BigDecimal("0.9999999")).toBigInteger();
            }
            while (experience.compareTo(MAX_INTEGER_VALUE) >= 0) {
                if (System.currentTimeMillis() - time >= timeout) {
                    throw new OperationTimeoutException();
                }
                experience = experience.subtract(MAX_INTEGER_VALUE);
                transfer.addExperience(Integer.MAX_VALUE);
            }
            transfer.addExperience(experience.intValue());
        }
        catch (OperationTimeoutException e) {
            transfer.player.method_14252(level);
            transfer.player.method_14228(point);
            throw e;
        }
    }

    private BigInteger extractAllExperience() {
        BigInteger experience = this.calculateTotalExperience();
        this.clearExperience();
        return experience;
    }

    private BigInteger calculateTotalExperience() {
        int xp;
        int level = Math.min(this.player.field_7520, 238609312);
        int n = xp = this.player.field_7520 >= 238609312 ? 0 : this.getPoint();
        if (level <= 31) {
            int totalExp = level <= 16 ? level * level + 6 * level : (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
            return BigInteger.valueOf(totalExp);
        }
        BigDecimal bigLevel = BigDecimal.valueOf(level);
        BigDecimal decimal = new BigDecimal("4.5").multiply(bigLevel.multiply(bigLevel)).subtract(new BigDecimal("162.5").multiply(bigLevel)).add(new BigDecimal("2220")).add(new BigDecimal(xp));
        return decimal.toBigInteger();
    }

    public int getLevel() {
        return this.player.field_7520;
    }

    public static BigInteger calculateTotalExperience(int level, int xp) {
        BigInteger experience = ExperienceTransfer.calculateUpgradeExperience(0, level);
        return xp == 0 ? experience : experience.add(BigInteger.valueOf(xp));
    }

    public static BigInteger calculateUpgradeExperience(int level, int target) {
        int end;
        if (target > 238609312) {
            throw new ArithmeticException("Upgrading to level %s requires infinite experience".formatted(target));
        }
        if (level == target) {
            return BigInteger.ZERO;
        }
        if (level > target) {
            return ExperienceTransfer.calculateUpgradeExperience(target, level).negate();
        }
        double sum = 0.0;
        int start = level;
        if (start <= (end = Math.min(--target, 15))) {
            sum += ExperienceTransfer.calculateExperienceSum(start, end, x -> 2.0 * (double)x + 7.0);
        }
        if ((start = Math.max(level, 16)) <= (end = Math.min(target, 30))) {
            sum += ExperienceTransfer.calculateExperienceSum(start, end, x -> 5.0 * (double)x - 38.0);
        }
        if ((start = Math.max(level, 31)) <= (end = target)) {
            sum += ExperienceTransfer.calculateExperienceSum(start, end, x -> 9.0 * (double)x - 158.0);
        }
        return BigDecimal.valueOf(sum).toBigInteger();
    }

    private static double calculateExperienceSum(int start, int end, IntFunction<Double> function) {
        int n = end - start + 1;
        return MathUtils.sumOfArithmeticProgression(function.apply(start), function.apply(end), n);
    }

    public static class ExperienceTransferException
    extends RuntimeException {
        private final Number require;
        private final Number existing;

        public ExperienceTransferException(Number require, Number existing) {
            this.require = require;
            this.existing = existing;
        }

        public Number getRequire() {
            return this.require;
        }

        public Number getExisting() {
            return this.existing;
        }
    }
}

