/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import carpet.CarpetServer;
import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2293;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.wheel.CommandRegistryAccessor;

public class ItemStackPredicate
implements Predicate<class_1799> {
    private final Predicate<class_1799> predicate;
    private final String input;
    private final boolean isWildcard;
    public static final ItemStackPredicate EMPTY = new ItemStackPredicate(class_1802.field_8162);
    public static final ItemStackPredicate WILDCARD = new ItemStackPredicate();

    private ItemStackPredicate() {
        this.predicate = itemStack -> !itemStack.method_7960();
        this.input = "*";
        this.isWildcard = true;
    }

    public ItemStackPredicate(CommandContext<class_2168> context, String arguments) {
        for (ParsedCommandNode commandNode : context.getNodes()) {
            ArgumentCommandNode node;
            CommandNode commandNode2 = commandNode.getNode();
            if (!(commandNode2 instanceof ArgumentCommandNode) || !Objects.equals((node = (ArgumentCommandNode)commandNode2).getName(), arguments)) continue;
            StringRange range = commandNode.getRange();
            this.input = context.getInput().substring(range.getStart(), range.getEnd());
            class_2293.class_2295 predicate = class_2293.method_9804(context, (String)arguments);
            this.isWildcard = this.isWildcard();
            this.predicate = this.isWildcard ? itemStack -> !itemStack.method_7960() && predicate.test(itemStack) : predicate;
            return;
        }
        throw new IllegalArgumentException();
    }

    public ItemStackPredicate(class_1792 item) {
        this.predicate = itemStack -> itemStack.method_31574(item);
        this.input = class_7923.field_41178.method_10221((Object)item).toString();
        this.isWildcard = false;
    }

    private ItemStackPredicate(Predicate<class_1799> predicate, String input) {
        this.input = input;
        this.isWildcard = this.isWildcard();
        this.predicate = this.isWildcard ? itemStack -> !itemStack.method_7960() && predicate.test((class_1799)itemStack) : predicate;
    }

    public boolean isEmpty() {
        return this.test(class_1799.field_8037);
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return this.predicate.test(itemStack);
    }

    public static ItemStackPredicate parse(String input) {
        CommandRegistryAccessor accessor = (CommandRegistryAccessor)CarpetServer.minecraft_server.method_3734();
        class_7157 access = accessor.getAccess();
        try {
            StringReader reader = new StringReader(input);
            class_2293.class_2295 predicate = (class_2293.class_2295)class_2293.method_9801((class_7157)access).parse(reader);
            return new ItemStackPredicate((Predicate<class_1799>)predicate, input);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isWildcard() {
        return "*".equals(this.input) || "*[]".equals(this.input);
    }

    public class_2561 getInitialUpperCase() {
        class_5250 result = null;
        if (this.isEmpty()) {
            result = TextUtils.createText("[A]");
            result = TextUtils.setColor(result.method_27661(), class_124.field_1063);
            return TextUtils.hoverText((class_2561)result, class_1802.field_8162.method_63680());
        }
        if (this.input.startsWith("#")) {
            result = TextUtils.createText("[#]");
        } else if (this.input.startsWith("*")) {
            result = TextUtils.createText("[*]");
        } else if (this.input.contains("[")) {
            result = TextUtils.createText("[@]");
        }
        if (result != null) {
            return TextUtils.hoverText(result.method_27661(), this.input);
        }
        String[] split = this.input.split(":");
        int index = split.length == 1 ? 0 : 1;
        result = TextUtils.createText("[" + Character.toUpperCase(split[index].charAt(0)) + "]");
        class_2561 name = ((class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)this.input))).method_63680();
        return TextUtils.hoverText((class_2561)result, name);
    }

    public class_2561 toText() throws class_151 {
        if (this.isEmpty()) {
            return class_1802.field_8162.method_63680();
        }
        if (this.isWildcard) {
            return TextUtils.translate("carpet.command.item.predicate.wildcard", new Object[0]);
        }
        if (this.isConvertible()) {
            class_2960 identifier = class_2960.method_60654((String)this.input);
            return ((class_1792)class_7923.field_41178.method_63535(identifier)).method_63680();
        }
        if (this.input.length() > 30) {
            String substring = this.input.substring(0, 30);
            class_5250 ellipsis = TextUtils.createText("...");
            class_5250 result = TextUtils.appendAll(substring, ellipsis);
            return TextUtils.toGrayItalic(TextUtils.hoverText(result, this.input));
        }
        return TextUtils.createText(this.input);
    }

    public class_1792 asItem() {
        if (this.isEmpty()) {
            return class_1802.field_8162;
        }
        if (this.isConvertible()) {
            return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)this.input));
        }
        throw new UnsupportedOperationException(this.input + " cannot be converted to item");
    }

    public static class_1799 getCraftOutput(ItemStackPredicate[] predicates, int widthHeight, EntityPlayerMPFake fakePlayer) {
        for (ItemStackPredicate predicate : predicates) {
            if (predicate.isConvertible()) continue;
            return class_1799.field_8037;
        }
        List<class_1799> list = Arrays.stream(predicates).map(ItemStackPredicate::getInput).map(class_2960::method_60654).map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).map(class_1792::method_7854).toList();
        class_9694 input = class_9694.method_59986((int)widthHeight, (int)widthHeight, list);
        class_1937 world = fakePlayer.method_37908();
        Optional optional = fakePlayer.field_13995.method_3772().method_8132(class_3956.field_17545, (class_9695)input, world);
        return optional.map(recipe -> ((class_3955)recipe.comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)world.method_30349())).orElse(class_1799.field_8037);
    }

    public static class_1792 stringAsItem(String id) {
        return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)id));
    }

    public boolean isConvertible() {
        return !this.input.startsWith("#") && !this.input.startsWith("*") && !this.input.matches(".*\\[.*]");
    }

    public String getInput() {
        return this.input;
    }

    public String toString() {
        return this.input;
    }
}

