/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.class_3312;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.IOUtils;

public class UuidNameMappingTable {
    private final HashMap<UUID, String> hashMap = new HashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final File config = IOUtils.createConfigFile("uuid_name_mapping.txt", true);
    private static final UuidNameMappingTable MAPPING_TABLE = new UuidNameMappingTable();
    public static final String MOJANG_API = "https://api.minecraftservices.com/minecraft/profile/lookup/%s";

    private UuidNameMappingTable() {
    }

    public static UuidNameMappingTable getInstance() {
        return MAPPING_TABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> get(UUID uuid) {
        try {
            this.lock.readLock().lock();
            String value = this.hashMap.get(uuid);
            Optional<String> optional = Optional.ofNullable(value);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<GameProfile> getGameProfile(UUID uuid) {
        Optional<String> optional = this.get(uuid);
        return optional.map(name -> new GameProfile(uuid, name));
    }

    public Optional<GameProfile> fetchGameProfileWithBackup(class_3312 userCache, UUID uuid) {
        Optional optional = userCache.method_14512(uuid);
        if (optional.isPresent()) {
            return optional;
        }
        return this.getGameProfile(uuid);
    }

    public void put(GameProfile gameProfile) {
        this.put(gameProfile.getId(), gameProfile.getName());
    }

    public void put(UUID uuid, String name) {
        try {
            this.lock.writeLock().lock();
            this.hashMap.put(uuid, name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void init() {
        try {
            BufferedReader reader;
            IOUtils.createFileIfNotExists(this.config);
            try (BufferedReader bufferedReader = reader = IOUtils.toReader(this.config);){
                this.loadFromFile(reader);
            }
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u4ece\u6587\u4ef6\u8bfb\u53d6\u73a9\u5bb6UUID\u4e0e\u540d\u79f0\u7684\u6620\u5c04\u8868", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            UUID uuid;
            String[] split = line.split("=");
            if (split.length != 2) continue;
            try {
                uuid = UUID.fromString(split[0].strip());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            String playerName = split[1].strip();
            if (playerName.isEmpty()) continue;
            try {
                this.lock.writeLock().lock();
                this.hashMap.put(uuid, playerName);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            BufferedWriter writer = IOUtils.toWriter(this.config);
            try (BufferedWriter bufferedWriter = writer;){
                this.lock.readLock().lock();
                Set<Map.Entry<UUID, String>> entries = this.hashMap.entrySet();
                for (Map.Entry<UUID, String> entry : entries) {
                    writer.write(entry.getKey().toString() + "=" + entry.getValue());
                    writer.newLine();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u5c06\u73a9\u5bb6UUID\u4e0e\u540d\u79f0\u7684\u6620\u5c04\u8868\u5199\u5165\u6587\u4ef6", (Throwable)e);
        }
    }
}

