/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.dataupdate.DataUpdater;
import org.carpetorgaddition.dataupdate.waypoint.WaypointDataUpdater;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.provider.TextProvider;
import org.carpetorgaddition.util.wheel.MetaComment;
import org.carpetorgaddition.util.wheel.WorldFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Waypoint {
    public static final String WAYPOINT = "waypoint";
    private class_2338 blockPos;
    @Nullable
    private class_2338 anotherBlockPos;
    private final String dimension;
    @NotNull
    private MetaComment comment = new MetaComment();
    private final String creator;
    public final String name;

    public Waypoint(class_2338 blockPos, String name, String dimension, String creator) {
        this.name = name;
        this.blockPos = blockPos;
        this.dimension = dimension;
        this.creator = creator;
    }

    public void save(MinecraftServer server) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)1);
        JsonObject pos = new JsonObject();
        pos.addProperty("x", (Number)this.blockPos.method_10263());
        pos.addProperty("y", (Number)this.blockPos.method_10264());
        pos.addProperty("z", (Number)this.blockPos.method_10260());
        json.add("pos", (JsonElement)pos);
        json.addProperty("dimension", this.dimension);
        json.addProperty("creator", this.creator);
        json.addProperty("comment", this.comment.getComment());
        JsonObject anotherPos = new JsonObject();
        if (this.anotherBlockPos != null) {
            anotherPos.addProperty("x", (Number)this.anotherBlockPos.method_10263());
            anotherPos.addProperty("y", (Number)this.anotherBlockPos.method_10264());
            anotherPos.addProperty("z", (Number)this.anotherBlockPos.method_10260());
        }
        json.add("another_pos", (JsonElement)anotherPos);
        WorldFormat worldFormat = new WorldFormat(server, WAYPOINT, new String[0]);
        File file = worldFormat.file(this.name + ".json");
        IOUtils.saveJson(file, json);
    }

    public static Waypoint load(MinecraftServer server, String name) throws IOException {
        JsonObject anotherPos;
        WorldFormat worldFormat = new WorldFormat(server, WAYPOINT, new String[0]);
        File file = worldFormat.file(name, ".json");
        JsonObject json = IOUtils.loadJson(file);
        WaypointDataUpdater dataUpdater = new WaypointDataUpdater();
        json = dataUpdater.update(json, DataUpdater.getVersion(json));
        JsonObject pos = json.get("pos").getAsJsonObject();
        int x = pos.get("x").getAsInt();
        int y = pos.get("y").getAsInt();
        int z = pos.get("z").getAsInt();
        class_2338 blockPos = new class_2338(x, y, z);
        String dimension = IOUtils.jsonHasElement(json, "dimension") ? json.get("dimension").getAsString() : "minecraft:overworld";
        String creator = IOUtils.jsonHasElement(json, "creator") ? json.get("creator").getAsString() : "#none";
        Waypoint waypoint = new Waypoint(blockPos, name, dimension, creator);
        if (json.has("another_pos") && IOUtils.jsonHasElement(anotherPos = json.get("another_pos").getAsJsonObject(), "x", "y", "z")) {
            int anotherX = anotherPos.get("x").getAsInt();
            int anotherY = anotherPos.get("y").getAsInt();
            int anotherZ = anotherPos.get("z").getAsInt();
            waypoint.setAnotherBlockPos(new class_2338(anotherX, anotherY, anotherZ));
        }
        waypoint.setComment(json.get("comment").getAsString());
        return waypoint;
    }

    public void show(class_2168 source) {
        class_5250 text = switch (this.dimension) {
            case "minecraft:overworld" -> {
                if (this.anotherBlockPos == null) {
                    yield TextUtils.translate("carpet.commands.locations.show.overworld", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1060));
                }
                yield TextUtils.translate("carpet.commands.locations.show.overworld_and_the_nether", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1060), TextProvider.blockPos(this.anotherBlockPos, class_124.field_1061));
            }
            case "minecraft:the_nether" -> {
                if (this.anotherBlockPos == null) {
                    yield TextUtils.translate("carpet.commands.locations.show.the_nether", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1061));
                }
                yield TextUtils.translate("carpet.commands.locations.show.the_nether_and_overworld", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1061), TextProvider.blockPos(this.anotherBlockPos, class_124.field_1060));
            }
            case "minecraft:the_end" -> TextUtils.translate("carpet.commands.locations.show.the_end", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1064));
            default -> TextUtils.translate("carpet.commands.locations.show.custom_dimension", this.formatName(), this.dimension, TextProvider.blockPos(this.blockPos, class_124.field_1060));
        };
        MessageUtils.sendMessage(source, (class_2561)text);
    }

    private class_2561 formatName() {
        String name = "[" + this.name.split("\\.")[0] + "]";
        if (this.comment.isEmpty()) {
            return TextUtils.createText(name);
        }
        return TextUtils.hoverText(name, this.comment.getText());
    }

    public void setAnotherBlockPos(@Nullable class_2338 anotherBlockPos) {
        this.anotherBlockPos = anotherBlockPos;
    }

    public void setComment(String comment) {
        this.comment = comment == null || comment.isEmpty() ? new MetaComment() : new MetaComment(comment);
    }

    public void setBlockPos(class_2338 blockPos) {
        this.blockPos = blockPos;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    @Nullable
    public class_2338 getAnotherBlockPos() {
        return this.anotherBlockPos;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getName() {
        return this.name;
    }

    public boolean canAddAnother() {
        return WorldUtils.isOverworld(this.dimension) || WorldUtils.isTheNether(this.dimension);
    }
}

