/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.util.carpet;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.SettingsManager;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionExtension;
import org.carpetorgaddition.dataupdate.CarpetConfDataUpdater;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.rule.OrgRule;
import org.carpetorgaddition.rule.RuleConfig;
import org.carpetorgaddition.rule.RuleUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SettingsManager.class}, remap=false)
public abstract class SettingsManagerMixin {
    @Shadow
    @Final
    private Map<String, CarpetRule<?>> rules;
    @Shadow
    private MinecraftServer server;
    @Unique
    private final SettingsManager thisManager = (SettingsManager)this;

    @Shadow
    public abstract boolean locked();

    @Shadow
    protected abstract Path getFile();

    @Inject(method={"setDefault"}, at={@At(value="HEAD")}, cancellable=true)
    private void setDefault(class_2168 source, CarpetRule<?> rule, String stringValue, CallbackInfoReturnable<Integer> cir) {
        if (rule instanceof OrgRule && this.thisManager == CarpetOrgAdditionExtension.getSettingManager()) {
            if (this.locked() || !this.rules.containsKey(rule.name())) {
                cir.setReturnValue((Object)0);
                return;
            }
            try {
                rule.set(source, stringValue);
            }
            catch (InvalidRuleValueException e) {
                e.notifySource(rule.name(), source);
                cir.setReturnValue((Object)0);
                return;
            }
            RuleConfig ruleConfig = ServerComponentCoordinator.getCoordinator(this.server).getRuleConfig();
            ruleConfig.put(rule, stringValue);
            TextBuilder builder = TextBuilder.of("carpet.settings.command.default_set", RuleUtils.simpleTranslationName(rule), stringValue);
            builder.setGrayItalic();
            MessageUtils.sendMessage(source, builder.build());
            cir.setReturnValue((Object)1);
        }
    }

    @Inject(method={"removeDefault"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeDefault(class_2168 source, CarpetRule<?> rule, CallbackInfoReturnable<Integer> cir) {
        if (rule instanceof OrgRule && this.thisManager == CarpetOrgAdditionExtension.getSettingManager()) {
            if (this.locked() || !this.rules.containsKey(rule.name())) {
                cir.setReturnValue((Object)0);
                return;
            }
            RuleConfig ruleConfig = ServerComponentCoordinator.getCoordinator(this.server).getRuleConfig();
            ruleConfig.remove(rule);
            RuleHelper.resetToDefault(rule, (class_2168)source);
            TextBuilder builder = TextBuilder.of("carpet.settings.command.default_removed", RuleUtils.simpleTranslationName(rule));
            builder.setGrayItalic();
            MessageUtils.sendMessage(source, builder.build());
            cir.setReturnValue((Object)1);
        }
    }

    @WrapOperation(method={"loadConfigurationFromConf"}, at={@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;")})
    private Set<String> migrate(Map<String, String> map, Operation<Set<String>> original) {
        if (this.thisManager == CarpetOrgAdditionExtension.getSettingManager()) {
            RuleConfig ruleConfig = ServerComponentCoordinator.getCoordinator(this.server).getRuleConfig();
            if (ruleConfig.isMigrated()) {
                ruleConfig.load();
                return (Set)original.call(new Object[]{map});
            }
            JsonObject json = new JsonObject();
            HashSet<String> set = new HashSet<String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (CarpetConfDataUpdater.OLD_VERSION_RULES.contains(entry.getKey())) {
                    json.addProperty(entry.getKey(), entry.getValue());
                    continue;
                }
                set.add(entry.getKey());
            }
            ruleConfig.migrate(json);
            ruleConfig.load();
            File file = this.getFile().toFile();
            if (file.isFile()) {
                this.removeRulesFromCarpetConf(file);
            }
            return set;
        }
        return (Set)original.call(new Object[]{map});
    }

    @WrapOperation(method={"readSettingsFromConf"}, at={@At(value="INVOKE", target="Ljava/util/Map;containsKey(Ljava/lang/Object;)Z")})
    private boolean readSettingsFromConf(Map<String, String> instance, Object o, Operation<Boolean> original) {
        if (o instanceof String && CarpetConfDataUpdater.OLD_VERSION_RULES.contains(o)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, o});
    }

    @Unique
    private void removeRulesFromCarpetConf(File file) {
        IOUtils.backupFile(file);
        ArrayList<String> list = new ArrayList<String>();
        try {
            BufferedReader reader;
            try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (this.isCarpetOrgAdditionRule(line)) continue;
                    list.add(line);
                }
            }
            StringJoiner joiner = new StringJoiner("\n");
            for (String rule : list) {
                joiner.add(rule);
            }
            IOUtils.write(file, joiner.toString());
        }
        catch (IOException e) {
            IOUtils.loggerError(e);
        }
    }

    @Unique
    private boolean isCarpetOrgAdditionRule(String line) {
        String[] split = line.replaceAll("[\\r\\n]", "").split("\\s");
        if (split.length <= 1 || split[0].startsWith("#") || split[1].startsWith("#")) {
            return false;
        }
        return CarpetConfDataUpdater.OLD_VERSION_RULES.contains(split[0]);
    }
}

