/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.PlayerComponentCoordinator;
import org.carpetorgaddition.periodic.navigator.NavigatorManager;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNavigator {
    protected static final String IN = "carpet.commands.navigate.hud.in";
    protected static final String DISTANCE = "carpet.commands.navigate.hud.distance";
    protected static final String REACH = "carpet.commands.navigate.hud.reach";
    @NotNull
    protected final class_3222 player;
    protected final NavigatorManager manager;
    private class_243 previousPosition;
    private String previousWorldId;

    public AbstractNavigator(@NotNull class_3222 player) {
        this.player = player;
        this.manager = PlayerComponentCoordinator.getManager(this.player).getNavigatorManager();
    }

    public abstract void tick();

    protected abstract boolean shouldTerminate();

    public abstract AbstractNavigator copy(class_3222 var1);

    @NotNull
    protected class_2561 getHUDText(class_243 vec3d, class_2561 in, class_2561 distance) {
        class_2561 text = switch (AbstractNavigator.verticalAngle((class_1657)this.player, vec3d)) {
            case 1 -> TextBuilder.combineAll(in, " \u2191 ", distance);
            case -1 -> TextBuilder.combineAll(in, " \u2193 ", distance);
            default -> TextBuilder.combineAll(in, "   ", distance);
        };
        text = switch (AbstractNavigator.forwardAngle((class_1657)this.player, vec3d)) {
            case -3 -> TextBuilder.combineAll("    ", text, " >>>");
            case -2 -> TextBuilder.combineAll("    ", text, "  >>");
            case -1 -> TextBuilder.combineAll("    ", text, "   >");
            case 1 -> TextBuilder.combineAll("<   ", text, "    ");
            case 2 -> TextBuilder.combineAll("<<  ", text, "    ");
            case 3 -> TextBuilder.combineAll("<<< ", text, "    ");
            default -> TextBuilder.combineAll("    ", text, "    ");
        };
        return text;
    }

    private static int forwardAngle(class_1657 player, class_243 target) {
        double x = target.method_10216() - player.method_23317();
        double y = target.method_10215() - player.method_23321();
        double result = (double)player.method_36454() + Math.toDegrees(Math.atan2(x, y));
        result = result < 0.0 ? result + 360.0 : result;
        result = result > 180.0 ? result - 360.0 : result;
        return AbstractNavigator.forwardAngle(result);
    }

    private static int forwardAngle(double value) {
        if (value < 0.0) {
            return -AbstractNavigator.forwardAngle(-value);
        }
        if (value <= 3.0) {
            return 0;
        }
        if (value <= 60.0) {
            return 1;
        }
        if (value <= 100.0) {
            return 2;
        }
        return 3;
    }

    private static int verticalAngle(class_1657 player, class_243 target) {
        double x = Math.sqrt(Math.pow(player.method_23317() - target.method_10216(), 2.0) + Math.pow(player.method_23321() - target.method_10215(), 2.0));
        double y = target.method_10214() - player.method_23320();
        double result = (double)player.method_36455() + Math.toDegrees(Math.atan2(y, x));
        if (result >= 10.0) {
            return 1;
        }
        if (result <= -10.0) {
            return -1;
        }
        return 0;
    }

    protected void syncWaypoint(WaypointUpdateS2CPacket pack) {
        if (this.updatePrevious(pack)) {
            boolean hasPermission = CommandUtils.canUseCommand(this.player.method_64396(), CarpetOrgAdditionSettings.commandNavigate);
            if (CarpetOrgAdditionSettings.syncNavigateWaypoint.get().booleanValue() && hasPermission) {
                ServerPlayNetworking.send((class_3222)this.player, (class_8710)pack);
            }
        }
    }

    private boolean updatePrevious(WaypointUpdateS2CPacket pack) {
        if (pack.target().equals((Object)this.previousPosition) && pack.worldId().equals(this.previousWorldId)) {
            return false;
        }
        this.previousPosition = pack.target();
        this.previousWorldId = pack.worldId();
        return true;
    }

    public void sendWaypointUpdate() {
        if (this.previousPosition == null || this.previousWorldId == null) {
            return;
        }
        ServerPlayNetworking.send((class_3222)this.player, (class_8710)new WaypointUpdateS2CPacket(this.previousPosition, this.previousWorldId));
    }

    public void clear() {
        this.manager.clearNavigator();
    }
}

