/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.SettingsManager;
import carpet.utils.CommandHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionExtension;
import org.carpetorgaddition.exception.TranslatableInvalidRuleValueException;
import org.carpetorgaddition.rule.RuleObserver;
import org.carpetorgaddition.rule.RuleUtils;
import org.carpetorgaddition.rule.validator.StrictValidator;
import org.carpetorgaddition.rule.validator.Validator;
import org.carpetorgaddition.wheel.TextBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrgRule<T>
implements CarpetRule<T> {
    private final String name;
    private final String displayName;
    private final String displayDesc;
    private final Collection<String> categories;
    private final Collection<String> suggestions;
    @NotNull
    private T value;
    private final T defaultValue;
    private final boolean canBeToggledClientSide;
    private final Class<T> type;
    private final RuleValueParser<T> parser;
    private final List<Validator<T>> validators = new ArrayList<Validator<T>>();
    private final List<RuleObserver<T>> observers = new ArrayList<RuleObserver<T>>();
    private final boolean strict;

    public OrgRule(Class<T> type, String name, Collection<String> categories, Collection<String> suggestions, @NotNull T value, boolean canBeToggledClientSide, List<Validator<T>> validators, List<RuleObserver<T>> observers, boolean strict, String displayName, String displayDesc) {
        this.name = name;
        this.categories = categories;
        this.suggestions = suggestions;
        this.value = value;
        this.defaultValue = value;
        this.canBeToggledClientSide = canBeToggledClientSide;
        this.type = type;
        this.validators.addAll(validators);
        this.observers.addAll(observers);
        this.strict = strict;
        this.parser = this.createParser();
        this.displayName = displayName;
        this.displayDesc = displayDesc;
        this.init();
    }

    private void init() {
        if (this.strict()) {
            this.validators.addFirst(new StrictValidator(this));
        }
        if (this.categories.contains("command")) {
            this.observers.add((source, value) -> {
                if (source != null) {
                    CommandHelper.notifyPlayersCommandsChanged((MinecraftServer)source.method_9211());
                }
            });
        }
    }

    private RuleValueParser<T> createParser() {
        T t = this.defaultValue;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        Map.Entry<class_2561, Function<String, Object>> entry = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Integer.class, Long.class, Double.class, Float.class, Enum.class}, t2, n)) {
            case 0 -> {
                String ignored = (String)t2;
                yield Map.entry(TextBuilder.translate("carpet.generic.data.type.string", new Object[0]), this.type::cast);
            }
            case 1 -> {
                Boolean ignored = (Boolean)t2;
                yield Map.entry(TextBuilder.translate("carpet.generic.data.type.boolean", new Object[0]), s -> this.type.cast(this.parseBoolean((String)s)));
            }
            case 2 -> {
                Integer ignored = (Integer)t2;
                yield Map.entry(TextBuilder.translate("carpet.generic.data.type.integer", new Object[0]), s -> this.type.cast(Integer.parseInt(s)));
            }
            case 3 -> {
                Long ignored = (Long)t2;
                yield Map.entry(TextBuilder.translate("carpet.generic.data.type.long", new Object[0]), s -> this.type.cast(Long.parseLong(s)));
            }
            case 4 -> {
                Double ignored = (Double)t2;
                yield Map.entry(TextBuilder.translate("carpet.generic.data.type.double", new Object[0]), s -> this.type.cast(Double.parseDouble(s)));
            }
            case 5 -> {
                Float ignored = (Float)t2;
                yield Map.entry(TextBuilder.translate("carpet.generic.data.type.float", new Object[0]), s -> this.type.cast(Float.valueOf(Float.parseFloat(s))));
            }
            case 6 -> {
                Enum ignored = (Enum)t2;
                yield Map.entry(TextBuilder.translate("carpet.generic.data.type.enum", new Object[0]), s -> Enum.valueOf(this.type, s.toUpperCase(Locale.ROOT)));
            }
            default -> throw new UnsupportedOperationException("Unsupported type for %s %s".formatted(this.getClass().getSimpleName(), this.type));
        };
        return str -> {
            class_2561 dataType = (class_2561)entry.getKey();
            try {
                return ((Function)entry.getValue()).apply(str);
            }
            catch (RuntimeException e) {
                class_2561 stringType = TextBuilder.translate("carpet.generic.data.type.string", new Object[0]);
                TextBuilder builder = TextBuilder.of("carpet.rule.org.pause", stringType, str, dataType);
                builder.setHover(e);
                throw new TranslatableInvalidRuleValueException(builder.build());
            }
        };
    }

    private Boolean parseBoolean(String str) {
        return switch (str.toLowerCase(Locale.ROOT)) {
            case "true" -> Boolean.TRUE;
            case "false" -> Boolean.FALSE;
            default -> throw new IllegalArgumentException("Invalid boolean value: %s".formatted(str));
        };
    }

    public String name() {
        return this.name;
    }

    public List<class_2561> extraInfo() {
        return RuleUtils.ruleExtraInfo(this);
    }

    public Collection<String> categories() {
        return this.categories;
    }

    public Collection<String> suggestions() {
        return this.suggestions;
    }

    public SettingsManager settingsManager() {
        return CarpetOrgAdditionExtension.getSettingManager();
    }

    public T value() {
        return this.value;
    }

    public boolean canBeToggledClientSide() {
        return this.canBeToggledClientSide;
    }

    public Class<T> type() {
        return this.type;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public boolean strict() {
        return this.strict && !this.suggestions().isEmpty();
    }

    public void set(@Nullable class_2168 source, String value) throws TranslatableInvalidRuleValueException {
        this.set(source, this.parser.pause(value), value);
    }

    public void set(@Nullable class_2168 source, T value) throws TranslatableInvalidRuleValueException {
        this.set(source, value, RuleHelper.toRuleString(value));
    }

    private void set(@Nullable class_2168 source, T value, String userInput) throws TranslatableInvalidRuleValueException {
        for (Validator<T> validator : this.validators) {
            if (validator.validate(value)) continue;
            if (source != null) {
                validator.notifyFailure(source, this, userInput);
            }
            throw new TranslatableInvalidRuleValueException();
        }
        if (value.equals(this.value()) && source != null) {
            return;
        }
        this.observers.forEach(observer -> observer.onChanged(source, value));
        this.value = value;
        if (source != null) {
            this.settingsManager().notifyRuleChanged(source, (CarpetRule)this, userInput);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayDesc() {
        return this.displayDesc;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgRule that = (OrgRule)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + ": " + RuleHelper.toRuleString(this.value());
    }

    @FunctionalInterface
    private static interface RuleValueParser<T> {
        public T pause(String var1) throws TranslatableInvalidRuleValueException;
    }
}

