/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessor;

public class FabricPlayerAccessManager {
    private final MinecraftServer server;
    private final Map<GameProfile, Set<class_3222>> viewers = new ConcurrentHashMap<GameProfile, Set<class_3222>>();
    private final Map<GameProfile, FabricPlayerAccessor> accessors = new ConcurrentHashMap<GameProfile, FabricPlayerAccessor>();

    public FabricPlayerAccessManager(MinecraftServer server) {
        this.server = server;
    }

    public FabricPlayerAccessor getOrCreate(GameProfile gameProfile) {
        return this.accessors.computeIfAbsent(gameProfile, profile -> new FabricPlayerAccessor(this.server, (GameProfile)profile, this));
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    public Set<class_3222> getViewers(GameProfile gameProfile) {
        Set<class_3222> set = this.viewers.get(gameProfile);
        return set == null ? Set.of() : set;
    }

    public void addViewers(GameProfile gameProfile, Set<class_3222> viewers) {
        this.viewers.put(gameProfile, viewers);
    }

    public void removeAccessor(GameProfile gameProfile) {
        this.accessors.remove(gameProfile);
    }

    public void removeViewer(GameProfile gameProfile) {
        this.viewers.remove(gameProfile);
    }
}

