/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.api.settings.CarpetRule;
import carpet.utils.CommandHelper;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.class_12090;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.command.PlayerCommandExtension;
import org.carpetorgaddition.exception.CommandExecuteIOException;
import org.carpetorgaddition.rule.RuleSelfManager;
import org.carpetorgaddition.rule.RuleUtils;
import org.carpetorgaddition.rule.value.OpenPlayerInventory;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.GameProfileCache;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.inventory.OfflinePlayerInventory;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.permission.CommandPermission;
import org.carpetorgaddition.wheel.permission.PermissionLevel;
import org.carpetorgaddition.wheel.permission.PermissionManager;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class OrangeCommand
extends AbstractServerCommand {
    private final ThreadPoolExecutor QUERY_PLAYER_NAME_THREAD_POOL = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this::createDaemonThread, new ThreadPoolExecutor.AbortPolicy());

    public OrangeCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    private Thread createDaemonThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("Query-Player-Name");
        return thread;
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"permission").requires((Predicate)class_2170.method_71774((class_12090)class_2170.field_31841))).then(class_2170.method_9244((String)"node", (ArgumentType)StringArgumentType.string()).suggests(this.suggestsNode()).then(class_2170.method_9244((String)"level", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9253((String[])PermissionLevel.listPermission(), (SuggestionsBuilder)builder)).executes(this::setLevel))))).then(class_2170.method_9247((String)"version").executes(this::version))).then(class_2170.method_9247((String)"ruleself").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.string()).suggests(this.suggestRule()).executes(this::infoRuleSelf)).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(this::setRuleSelf)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"textclickevent").then(class_2170.method_9247((String)"queryPlayerName").then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(this::queryPlayerName)))).then(class_2170.method_9247((String)"pageturning").then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::pageTurning))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"openInventory").requires(OpenPlayerInventory::isEnable)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).then(class_2170.method_9247((String)"inventory").executes(context -> this.openPlayerInventory((CommandContext<class_2168>)context, true)))).then(class_2170.method_9247((String)"enderChest").executes(context -> this.openPlayerInventory((CommandContext<class_2168>)context, false)))))));
    }

    @NotNull
    private SuggestionProvider<class_2168> suggestRule() {
        return (context, builder) -> class_2172.method_9264(RuleSelfManager.RULES.values().stream().map(CarpetRule::name), (SuggestionsBuilder)builder);
    }

    private SuggestionProvider<class_2168> suggestsNode() {
        return (context, builder) -> class_2172.method_9264(PermissionManager.listNode().stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
    }

    private int setLevel(CommandContext<class_2168> context) throws CommandSyntaxException {
        PermissionLevel level;
        CommandPermission permission = PermissionManager.getPermission(StringArgumentType.getString(context, (String)"node"));
        if (permission == null) {
            throw CommandUtils.createException("carpet.commands.orange.permission.node.not_found", new Object[0]);
        }
        try {
            level = PermissionLevel.fromString(StringArgumentType.getString(context, (String)"level"));
        }
        catch (IllegalArgumentException e) {
            throw CommandUtils.createException(e, "carpet.commands.orange.permission.value.invalid", new Object[0]);
        }
        permission.setLevel(level);
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        CommandHelper.notifyPlayersCommandsChanged((MinecraftServer)server);
        try {
            PermissionManager.save(server);
        }
        catch (IOException e) {
            throw CommandUtils.createIOErrorException(e);
        }
        return level.ordinal();
    }

    private int version(CommandContext<class_2168> context) {
        String name = CarpetOrgAddition.MOD_NAME;
        class_2561 version = new TextBuilder(CarpetOrgAddition.VERSION).setHover(CarpetOrgAddition.BUILD_TIMESTAMP, new Object[0]).build();
        MessageUtils.sendMessage(context, "carpet.commands.orange.version", name, version);
        return 1;
    }

    private int queryPlayerName(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            UUID uuid = class_5242.method_27645(context, (String)"uuid");
            Optional<String> optional = GameProfileCache.get(uuid);
            if (optional.isPresent()) {
                String playerUuid = uuid.toString();
                String playerName = optional.get();
                this.sendFeekback(context, playerUuid, playerName);
            } else {
                this.QUERY_PLAYER_NAME_THREAD_POOL.submit(() -> this.queryPlayerName(context, uuid));
                MessageUtils.sendMessage(context, "carpet.commands.orange.textclickevent.queryPlayerName.start", new Object[0]);
            }
        }
        catch (RejectedExecutionException e) {
            throw CommandUtils.createException("carpet.command.thread.wait.last", new Object[0]);
        }
        return 1;
    }

    private void queryPlayerName(CommandContext<class_2168> context, UUID uuid) {
        String name;
        try {
            name = this.queryPlayerNameFromMojangApi(uuid);
        }
        catch (CommandSyntaxException e) {
            ((class_2168)context.getSource()).method_54495(e, false, null);
            return;
        }
        GameProfileCache.put(uuid, name);
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        server.execute(() -> this.sendFeekback(context, uuid.toString(), name));
    }

    private void sendFeekback(CommandContext<class_2168> context, String playerUuid, String playerName) {
        class_2561 uuid = new TextBuilder(playerUuid).setCopyToClipboard(playerUuid).setColor(class_124.field_1080).build();
        class_2561 name = new TextBuilder(playerName).setCopyToClipboard(playerName).setColor(class_124.field_1080).build();
        MessageUtils.sendMessage(context, "carpet.commands.orange.textclickevent.queryPlayerName.success", uuid, name);
    }

    private String queryPlayerNameFromMojangApi(UUID uuid) throws CommandSyntaxException {
        BufferedReader reader;
        URLConnection connection;
        URL url;
        try {
            URI uri = new URI("https://api.minecraftservices.com/minecraft/profile/lookup/%s".formatted(uuid.toString()));
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw CommandUtils.createException(e, "carpet.command.url.parse.fail", new Object[0]);
        }
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw CommandUtils.createException(e, "carpet.command.api.mojang_api.connection.fail", uuid.toString());
        }
        try {
            InputStream input = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(input));
        }
        catch (IOException e) {
            throw CommandUtils.createException(e, "carpet.commands.orange.textclickevent.queryPlayerName.fail", uuid.toString());
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = reader;){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
        JsonObject json = (JsonObject)IOUtils.GSON.fromJson(sb.toString(), JsonObject.class);
        if (json.has("name")) {
            return json.get("name").getAsString();
        }
        throw CommandUtils.createException("carpet.command.api.mojang_api.connection.fail", uuid.toString());
    }

    private int setRuleSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getArgumentPlayer(context);
        if (CommandUtils.isSelfOrFakePlayer(player, context)) {
            RuleSelfManager ruleSelfManager = FetcherUtils.getRuleSelfManager(player);
            String ruleString = StringArgumentType.getString(context, (String)"rule");
            CarpetRule<?> rule = RuleSelfManager.RULES.get(ruleString);
            if (rule == null) {
                throw CommandUtils.createException("carpet.commands.orange.ruleself.failed", new Object[0]);
            }
            boolean value = BoolArgumentType.getBool(context, (String)"value");
            ruleSelfManager.setEnabled(player, ruleString, value);
            class_2561 ruleName = RuleUtils.simpleTranslationName(rule);
            class_2561 playerName = player == CommandUtils.getSourcePlayer(context) ? TextProvider.SELF : player.method_5476();
            TextBuilder builder = value ? TextBuilder.of("carpet.commands.orange.ruleself.enable", ruleName, playerName) : TextBuilder.of("carpet.commands.orange.ruleself.disable", ruleName, playerName);
            if (CarpetOrgAdditionSettings.blockDropsDirectlyEnterInventory.get().isServerDecision()) {
                builder.setHover("carpet.commands.orange.ruleself.invalid", new Object[0]);
                builder.setStrikethrough();
            }
            MessageUtils.sendMessage((class_2168)context.getSource(), builder.build());
            return 1;
        }
        throw CommandUtils.createSelfOrFakePlayerException();
    }

    private int infoRuleSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getArgumentPlayer(context);
        if (CommandUtils.isSelfOrFakePlayer(player, context)) {
            RuleSelfManager ruleSelfManager = FetcherUtils.getRuleSelfManager(player);
            String ruleString = StringArgumentType.getString(context, (String)"rule");
            CarpetRule<?> rule = RuleSelfManager.RULES.get(ruleString);
            if (rule == null) {
                throw CommandUtils.createException("carpet.commands.orange.ruleself.failed", new Object[0]);
            }
            MessageUtils.sendEmptyMessage(context);
            MessageUtils.sendMessage(context, "carpet.commands.orange.ruleself.info.player", player.method_5476());
            boolean enabled = ruleSelfManager.isEnabled(player, ruleString);
            class_2561 displayName = RuleUtils.simpleTranslationName(rule);
            MessageUtils.sendMessage(context, "carpet.commands.orange.ruleself.info.rule", displayName);
            TextBuilder builder = TextBuilder.of("carpet.commands.orange.ruleself.info.enable", TextProvider.getBoolean(enabled));
            if (CarpetOrgAdditionSettings.blockDropsDirectlyEnterInventory.get().isServerDecision()) {
                builder.setHover("carpet.commands.orange.ruleself.invalid", new Object[0]);
                builder.setStrikethrough();
            }
            MessageUtils.sendMessage((class_2168)context.getSource(), builder.build());
            return 1;
        }
        throw CommandUtils.createSelfOrFakePlayerException();
    }

    private int pageTurning(CommandContext<class_2168> context) throws CommandSyntaxException {
        int id = IntegerArgumentType.getInteger(context, (String)"id");
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PageManager manager = FetcherUtils.getPageManager(server);
        Optional<PagedCollection> optional = manager.get(id);
        if (optional.isPresent()) {
            PagedCollection collection = optional.get();
            collection.print(page, true);
            return page;
        }
        throw CommandUtils.createException("carpet.command.page.non_existent", new Object[0]);
    }

    private int openPlayerInventory(CommandContext<class_2168> context, boolean isInventory) throws CommandSyntaxException {
        UUID uuid = class_5242.method_27645(context, (String)"uuid");
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_3222 player = server.method_3760().method_14602(uuid);
        if (player != null) {
            throw CommandUtils.createException("carpet.commands.orange.textclickevent.openInventory.fail", new Object[0]);
        }
        if (CarpetOrgAdditionSettings.playerCommandOpenPlayerInventoryOption.get().canOpenOfflinePlayer()) {
            Optional<GameProfile> optional = OfflinePlayerInventory.getPlayerConfigEntry(uuid, server).map(entry -> new GameProfile(entry.comp_4422(), entry.comp_4423()));
            if (optional.isEmpty()) {
                throw PlayerCommandExtension.createNoFileFoundException();
            }
            GameProfile gameProfile = optional.get();
            class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
            if (isInventory) {
                PlayerCommandExtension.openOfflinePlayerInventory(sourcePlayer, gameProfile);
            } else {
                PlayerCommandExtension.openOfflinePlayerEnderChest(sourcePlayer, gameProfile);
            }
            return 1;
        }
        throw CommandUtils.createPlayerNotFoundException();
    }

    @Override
    public String getDefaultName() {
        return "orange";
    }
}

