/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.schedule;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerializer;
import org.carpetorgaddition.periodic.task.schedule.PlayerScheduleTask;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class DelayedLoginTask
extends PlayerScheduleTask {
    private final MinecraftServer server;
    private final FakePlayerSerializer serial;
    private long delayed;

    public DelayedLoginTask(MinecraftServer server, FakePlayerSerializer serial, long delayed) {
        this.server = server;
        this.serial = serial;
        this.delayed = delayed;
    }

    @Override
    public void tick() {
        if (this.delayed == 0L) {
            try {
                try {
                    this.serial.spawn(this.server);
                }
                catch (CommandSyntaxException e) {
                    CarpetOrgAddition.LOGGER.error("\u73a9\u5bb6{}\u5df2\u5b58\u5728", (Object)this.serial.getFakePlayerName(), (Object)e);
                }
                catch (RuntimeException e) {
                    CarpetOrgAddition.LOGGER.error("\u73a9\u5bb6{}\u672a\u80fd\u5728\u6307\u5b9a\u65f6\u95f4\u4e0a\u7ebf", (Object)this.serial.getFakePlayerName(), (Object)e);
                }
            }
            finally {
                this.delayed = -1L;
            }
        } else {
            --this.delayed;
        }
    }

    @Override
    public String getPlayerName() {
        return this.serial.getFakePlayerName();
    }

    @Override
    public void onCancel(CommandContext<class_2168> context) {
        this.markRemove();
        class_2561 time = this.getDisplayTime();
        class_2561 displayName = this.serial.getDisplayName();
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.login.cancel", displayName, time);
    }

    @NotNull
    private class_2561 getDisplayTime() {
        TextBuilder builder = new TextBuilder(TextProvider.tickToTime(this.delayed));
        builder.setHover(TextProvider.tickToRealTime(this.delayed));
        return builder.build();
    }

    @Override
    public void sendEachMessage(class_2168 source) {
        MessageUtils.sendMessage(source, "carpet.commands.playerManager.schedule.login", this.serial.getDisplayName(), this.getDisplayTime());
    }

    public void setDelayed(long delayed) {
        this.delayed = delayed;
    }

    public class_2561 getInfo() {
        return this.serial.info();
    }

    @Override
    public boolean stopped() {
        return this.delayed < 0L;
    }

    @Override
    public String getLogName() {
        return this.serial.getFakePlayerName() + "\u5ef6\u8fdf\u4e0a\u7ebf";
    }
}

