/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_11565;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_4844;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.GameProfileCache;
import org.carpetorgaddition.wheel.inventory.AbstractCustomSizeInventory;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessor;

public class OfflinePlayerInventory
extends AbstractCustomSizeInventory {
    protected final FabricPlayerAccessor accessor;
    private boolean showLog = true;

    public OfflinePlayerInventory(FabricPlayerAccessor accessor) {
        this.accessor = accessor;
    }

    public static Optional<GameProfile> getGameProfile(String username, MinecraftServer server) {
        try {
            Optional<GameProfile> optional = GameProfileCache.getGameProfile(username);
            if (optional.isPresent()) {
                return optional;
            }
            UUID uuid = class_4844.method_43344((String)username);
            if (OfflinePlayerInventory.playerDataExists(uuid, server)) {
                GameProfile gameProfile = new GameProfile(uuid, username);
                GameProfileCache.put(gameProfile);
                return Optional.of(gameProfile);
            }
        }
        catch (JsonParseException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.warn("An unexpected issue occurred while reading usercache.json, using offline player UUID", e);
        }
        return Optional.empty();
    }

    public static void checkPermission(MinecraftServer server, GameProfile gameProfile, class_3222 player) throws CommandSyntaxException {
        if (CarpetOrgAdditionSettings.playerCommandOpenPlayerInventoryOption.get().permissionRequired()) {
            class_11560 entry;
            if (player.method_75004().hasPermission((class_12087)new class_12087.class_12089(class_12094.field_63198))) {
                return;
            }
            class_3324 playerManager = server.method_3760();
            if (playerManager.method_14587(entry = new class_11560(gameProfile)) || playerManager.method_14569(entry)) {
                throw CommandUtils.createException("carpet.commands.player.inventory.offline.permission", new Object[0]);
            }
        }
    }

    public static Optional<class_11560> getPlayerConfigEntry(UUID uuid, MinecraftServer server) {
        if (OfflinePlayerInventory.playerDataExists(uuid, server)) {
            Optional<class_11560> optional = GameProfileCache.getPlayerConfigEntry(uuid);
            return Optional.of(optional.orElse(new class_11560(new GameProfile(uuid, "[Unknown]"))));
        }
        return Optional.empty();
    }

    public static boolean playerDataExists(UUID uuid, MinecraftServer server) {
        String filename = uuid.toString() + ".dat";
        Path path = server.method_27050(class_5218.field_24182).resolve(filename);
        return Files.exists(path, new LinkOption[0]);
    }

    public int method_5439() {
        return 54;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5435(class_11565 user) {
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            this.accessor.onOpen(player);
            if (this.showLog) {
                CarpetOrgAddition.LOGGER.info("{} opened the inventory of the offline player {}.", (Object)FetcherUtils.getPlayerName((class_1657)player), (Object)this.accessor.getPlayerConfigEntry().comp_4423());
            }
        }
    }

    public void method_5432(class_11565 user) {
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            this.accessor.onClose(player);
        }
    }

    @Override
    protected class_1263 getInventory() {
        return this.accessor.getInventory();
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }
}

