/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.rule;

import carpet.patches.EntityPlayerMPFake;
import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.mixin.rule.LivingEntityMixin;
import org.carpetorgaddition.rule.RuleUtils;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    @Unique
    private final class_1657 thisPlayer = (class_1657)this;

    @Shadow
    public abstract class_1702 method_7344();

    @Shadow
    public abstract boolean method_7325();

    @Inject(method={"canConsume"}, at={@At(value="HEAD")}, cancellable=true)
    private void canEat(boolean ignoreHunger, CallbackInfoReturnable<Boolean> cir) {
        if (CarpetOrgAdditionSettings.healthNotFullCanEat.get().booleanValue() && (double)this.thisPlayer.method_6032() < (double)this.thisPlayer.method_6063() - 0.3 && this.method_7344().method_7589() <= 5.0f) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void interact(class_1297 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (this.method_7325()) {
            return;
        }
        switch (CarpetOrgAdditionSettings.quickSettingFakePlayerCraft.get()) {
            case FALSE: {
                break;
            }
            case SNEAKING: {
                if (!this.thisPlayer.method_5715()) break;
            }
            case TRUE: {
                if (!this.openQuickCraftGui(entity)) break;
                cir.setReturnValue((Object)class_1269.field_5812);
            }
        }
    }

    @Unique
    private boolean openQuickCraftGui(class_1297 entity) {
        Optional<Function<EntityPlayerMPFake, String>> optional = this.getOpenQuickCraftGuiCommand(this.thisPlayer.method_6047());
        if (optional.isEmpty()) {
            return false;
        }
        class_1657 class_16572 = this.thisPlayer;
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            if (entity instanceof EntityPlayerMPFake) {
                EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)entity;
                CommandUtils.execute(player, optional.get().apply(fakePlayer));
            }
        }
        return true;
    }

    @Unique
    private Optional<Function<EntityPlayerMPFake, String>> getOpenQuickCraftGuiCommand(class_1799 itemStack) {
        class_2168 source = this.thisPlayer.method_5671();
        if (CommandUtils.canUseCommand(source, CarpetOrgAdditionSettings.commandPlayerAction)) {
            if (itemStack.method_7960()) {
                return Optional.empty();
            }
            if (itemStack.method_31574(class_1802.field_8465)) {
                return Optional.of(CommandProvider::openPlayerCraftGui);
            }
            if (itemStack.method_31574(class_1802.field_16305)) {
                return Optional.of(CommandProvider::openPlayerStonecuttingGui);
            }
        }
        return Optional.empty();
    }

    @Inject(method={"getBlockInteractionRange"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBlockInteractionRange(CallbackInfoReturnable<Double> cir) {
        if (FetcherUtils.getWorld((class_1297)this.thisPlayer).method_8608() && !CarpetOrgAdditionSettings.maxBlockPlaceDistanceSyncClient.get().booleanValue()) {
            return;
        }
        if (RuleUtils.isDefaultDistance()) {
            return;
        }
        cir.setReturnValue((Object)RuleUtils.getPlayerMaxInteractionDistance());
    }

    @Inject(method={"getEntityInteractionRange"}, at={@At(value="HEAD")}, cancellable=true)
    private void getEntityInteractionRange(CallbackInfoReturnable<Double> cir) {
        if (CarpetOrgAdditionSettings.maxBlockPlaceDistanceReferToEntity.get().booleanValue()) {
            cir.setReturnValue((Object)RuleUtils.getPlayerMaxInteractionDistance());
        }
    }

    @WrapOperation(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V")})
    private void drop(class_1661 inventory, Operation<Void> original) {
        if (CarpetOrgAdditionSettings.playerDropsNotDespawning.get().booleanValue()) {
            for (List list : ImmutableList.of((Object)inventory.field_7547, (Object)inventory.field_7548, (Object)inventory.field_7544)) {
                for (int i = 0; i < list.size(); ++i) {
                    class_1799 itemStack = (class_1799)list.get(i);
                    if (itemStack.method_7960()) continue;
                    class_1542 itemEntity = inventory.field_7546.method_7329(itemStack, true, false);
                    list.set(i, class_1799.field_8037);
                    if (itemEntity == null) continue;
                    itemEntity.method_35190();
                }
            }
        } else {
            original.call(new Object[]{inventory});
        }
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="HEAD")})
    private void getBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cir) {
        if (CarpetOrgAdditionSettings.applyToolEffectsImmediately.get().booleanValue()) {
            this.onPlayerBreakBlock();
        }
    }
}

