/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.util.carpet;

import carpet.patches.EntityPlayerMPFake;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.periodic.task.batch.BatchSpawnFakePlayerTask;
import org.carpetorgaddition.periodic.task.schedule.ReLoginTask;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.ThreadContextPropagator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayerMPFake.class})
public class EntityPlayerMPFakeMixin {
    @WrapOperation(method={"createFake"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenAcceptAsync(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private static <T> CompletableFuture<Void> fakePlayerSpawnConsumer(CompletableFuture<T> instance, Consumer<? super T> action, Executor executor, Operation<CompletableFuture<Void>> original) {
        Consumer<EntityPlayerMPFake> onFakePlayerSpawning = GenericUtils.FAKE_PLAYER_SPAWNING.get();
        if (onFakePlayerSpawning == null) {
            return (CompletableFuture)original.call(new Object[]{instance, action, executor});
        }
        Consumer<Object> consumer = value -> {
            try {
                GenericUtils.INTERNAL_FAKE_PLAYER_SPAWNING.set(onFakePlayerSpawning);
                action.accept(value);
            }
            finally {
                GenericUtils.INTERNAL_FAKE_PLAYER_SPAWNING.remove();
            }
        };
        return (CompletableFuture)original.call(new Object[]{instance, consumer, executor});
    }

    @WrapOperation(method={"createFake"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenAcceptAsync(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private static <T> CompletableFuture<Void> fakePlayerLoginMessage(CompletableFuture<T> instance, Consumer<? super T> action, Executor executor, Operation<CompletableFuture<Void>> original) {
        ThreadContextPropagator<Boolean> propagator = CarpetOrgAdditionSettings.hiddenLoginMessages;
        Boolean external = propagator.getExternal();
        Boolean hiddenBatchSpawn = BatchSpawnFakePlayerTask.batchSpawnHiddenMessage.get();
        Consumer<Object> consumer = value -> {
            try {
                BatchSpawnFakePlayerTask.internalBatchSpawnHiddenMessage.set(hiddenBatchSpawn);
                propagator.setInternal(external);
                action.accept(value);
            }
            finally {
                propagator.setInternal(false);
                BatchSpawnFakePlayerTask.internalBatchSpawnHiddenMessage.set(false);
            }
        };
        return (CompletableFuture)original.call(new Object[]{instance, consumer, executor});
    }

    @Inject(method={"lambda$createFake$2"}, at={@At(value="RETURN")})
    private static void spawn(CallbackInfo ci, @Local EntityPlayerMPFake fakePlayer) {
        Consumer<EntityPlayerMPFake> consumer = GenericUtils.INTERNAL_FAKE_PLAYER_SPAWNING.get();
        if (consumer == null) {
            return;
        }
        consumer.accept(fakePlayer);
    }

    @WrapOperation(method={"lambda$createFake$2"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;onPlayerConnect(Lnet/minecraft/network/ClientConnection;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/server/network/ConnectedClientData;)V")})
    private static void onPlayerConnect(class_3324 instance, class_2535 connection, class_3222 player, class_8792 clientData, Operation<Void> original, @Local EntityPlayerMPFake fakePlayer) {
        boolean internal = CarpetOrgAdditionSettings.hiddenLoginMessages.getInternal();
        try {
            original.call(new Object[]{instance, connection, player, clientData});
        }
        catch (NullPointerException e) {
            if (internal) {
                CarpetOrgAddition.LOGGER.warn("Fake player attempts to join game after server shutdown", (Throwable)e);
            }
            throw e;
        }
    }

    @WrapOperation(method={"createFake"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenAcceptAsync(Ljava/util/function/Consumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private static <T> CompletableFuture<Void> homePositionSpawn(CompletableFuture<T> instance, Consumer<? super T> action, Executor executor, Operation<CompletableFuture<Void>> original) {
        Boolean shouldHomePosition = ReLoginTask.HOME_POSITION.get();
        Consumer<Object> consumer = value -> {
            try {
                ReLoginTask.INTERNAL_HOME_POSITION.set(shouldHomePosition);
                action.accept(value);
            }
            finally {
                ReLoginTask.INTERNAL_HOME_POSITION.set(false);
            }
        };
        return (CompletableFuture)original.call(new Object[]{instance, consumer, executor});
    }

    @WrapOperation(method={"lambda$createFake$2"}, at={@At(value="INVOKE", target="Lcarpet/patches/EntityPlayerMPFake;teleport(Lnet/minecraft/server/world/ServerWorld;DDDFF)V")})
    private static void homePositionSpawn(EntityPlayerMPFake instance, class_3218 serverWorld, double x, double y, double z, float yaw, float pitch, Operation<Void> original) {
        if (ReLoginTask.INTERNAL_HOME_POSITION.get().booleanValue()) {
            return;
        }
        original.call(new Object[]{instance, serverWorld, x, y, z, Float.valueOf(yaw), Float.valueOf(pitch)});
    }
}

