/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.PlayerComponentCoordinator;
import org.carpetorgaddition.periodic.navigator.NavigatorManager;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNavigator {
    protected static final String IN = "carpet.commands.navigate.hud.in";
    protected static final String REACH = "carpet.commands.navigate.hud.reach";
    protected final class_3222 player;
    protected final MinecraftServer server;
    protected final NavigatorManager manager;

    public AbstractNavigator(class_3222 player) {
        this.player = player;
        this.server = FetcherUtils.getServer(player);
        this.manager = PlayerComponentCoordinator.getManager(this.player).getNavigatorManager();
    }

    public void onStart() {
        this.syncWaypoint(true);
    }

    public abstract void tick();

    protected abstract boolean isArrive();

    public abstract AbstractNavigator copy(class_3222 var1);

    @NotNull
    protected class_2561 getHUDText(class_243 vec3d, class_2561 displayName, int distance) {
        Map.Entry<String, String> entry = switch (AbstractNavigator.forwardAngle((class_1657)this.player, vec3d)) {
            case -3 -> Map.entry("    ", " >>>");
            case -2 -> Map.entry("    ", "  >>");
            case -1 -> Map.entry("    ", "   >");
            case 1 -> Map.entry("<   ", "    ");
            case 2 -> Map.entry("<<  ", "    ");
            case 3 -> Map.entry("<<< ", "    ");
            default -> Map.entry("    ", "    ");
        };
        TextBuilder builder = new TextBuilder();
        builder.append(entry.getKey());
        builder.append(displayName);
        builder.append(switch (AbstractNavigator.verticalAngle((class_1657)this.player, vec3d)) {
            case 1 -> " \u2191 ";
            case -1 -> " \u2193 ";
            default -> "   ";
        });
        builder.append(TextBuilder.of("carpet.commands.navigate.hud.distance", distance));
        builder.append(entry.getValue());
        return builder.build();
    }

    private static int forwardAngle(class_1657 player, class_243 target) {
        double x = target.method_10216() - player.method_23317();
        double y = target.method_10215() - player.method_23321();
        double result = (double)player.method_36454() + Math.toDegrees(Math.atan2(x, y));
        result = result < 0.0 ? result + 360.0 : result;
        result = result > 180.0 ? result - 360.0 : result;
        return AbstractNavigator.forwardAngle(result);
    }

    private static int forwardAngle(double value) {
        if (value < 0.0) {
            return -AbstractNavigator.forwardAngle(-value);
        }
        if (value <= 3.0) {
            return 0;
        }
        if (value <= 60.0) {
            return 1;
        }
        if (value <= 100.0) {
            return 2;
        }
        return 3;
    }

    private static int verticalAngle(class_1657 player, class_243 target) {
        double x = Math.sqrt(Math.pow(player.method_23317() - target.method_10216(), 2.0) + Math.pow(player.method_23321() - target.method_10215(), 2.0));
        double y = target.method_10214() - player.method_23320();
        double result = (double)player.method_36455() + Math.toDegrees(Math.atan2(y, x));
        if (result >= 10.0) {
            return 1;
        }
        if (result <= -10.0) {
            return -1;
        }
        return 0;
    }

    public void syncWaypoint(boolean force) {
        if (force || this.updateRequired()) {
            boolean hasPermission = CommandUtils.canUseCommand(this.player.method_5671(), CarpetOrgAdditionSettings.commandNavigate);
            if (CarpetOrgAdditionSettings.syncNavigateWaypoint.get().booleanValue() && hasPermission) {
                WaypointUpdateS2CPacket packet = this.createPacket();
                ServerPlayNetworking.send((class_3222)this.player, (class_8710)packet);
            }
        }
    }

    protected abstract WaypointUpdateS2CPacket createPacket();

    protected abstract boolean updateRequired();

    public void clear() {
        this.manager.clearNavigator();
    }
}

