/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.carpetorgaddition.CarpetOrgAdditionExtension;
import org.carpetorgaddition.debug.DebugRuleRegistrar;
import org.carpetorgaddition.network.NetworkS2CPacketRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarpetOrgAddition
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CarpetOrgAddition");
    public static final String MOD_ID = "carpet-org-addition";
    public static final ModMetadata METADATA = ((ModContainer)FabricLoader.getInstance().getModContainer("carpet-org-addition").orElseThrow()).getMetadata();
    public static final String MOD_NAME = METADATA.getName();
    public static final String VERSION = METADATA.getVersion().getFriendlyString();
    public static final String MOD_NAME_LOWER_CASE = MOD_NAME.replace(" ", "").toLowerCase(Locale.ROOT);
    public static final String BUILD_TIMESTAMP = METADATA.getCustomValue("buildTimestamp").getAsString();
    public static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(s -> s.contains("jdwp"));
    public static final boolean LITHIUM = FabricLoader.getInstance().isModLoaded("lithium");
    public static final boolean ENABLE_HIDDEN_FUNCTION = Boolean.getBoolean("CarpetOrgAddition.EnableHiddenFunction");
    public static final boolean ALLOW_CUSTOM_SETTINGS_MANAGER = false;

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)new CarpetOrgAdditionExtension());
        NetworkS2CPacketRegister.register();
        if (ENABLE_HIDDEN_FUNCTION) {
            LOGGER.info("\u5df2\u542f\u7528\u9690\u85cf\u529f\u80fd");
        }
        if (CarpetOrgAddition.isDebugDevelopment()) {
            DebugRuleRegistrar.getInstance().registrar();
            LOGGER.info("\u6784\u5efa\u65f6\u95f4\u6233\uff1a{}", (Object)BUILD_TIMESTAMP);
        }
    }

    public static boolean isDebugDevelopment() {
        return IS_DEBUG && FabricLoader.getInstance().isDevelopmentEnvironment();
    }
}

