/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.rule.value.OpenPlayerInventory;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.screen.PlayerEnderChestScreenHandler;
import org.carpetorgaddition.util.screen.PlayerInventoryScreenHandler;
import org.jetbrains.annotations.NotNull;

public class PlayerCommandExtension {
    public static RequiredArgumentBuilder<class_2168, ?> register(RequiredArgumentBuilder<class_2168, ?> builder) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"inventory").requires(OpenPlayerInventory::isEnable)).executes(PlayerCommandExtension::openPlayerInventory))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enderChest").requires(OpenPlayerInventory::isEnable)).executes(PlayerCommandExtension::openEnderChest))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").requires(source -> CarpetOrgAdditionSettings.playerCommandTeleportFakePlayer)).executes(PlayerCommandExtension::fakePlayerTeleport));
    }

    private static int openPlayerInventory(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
        class_3222 argumentPlayer = PlayerCommandExtension.getPlayer(context);
        switch (CarpetOrgAdditionSettings.playerCommandOpenPlayerInventory) {
            case FALSE: {
                throw new IllegalStateException();
            }
            case FAKE_PLAYER: {
                CommandUtils.assertFakePlayer((class_1657)argumentPlayer);
            }
            case ONLINE_PLAYER: {
                class_747 screen = new class_747((syncId, inventory, player) -> new PlayerInventoryScreenHandler(syncId, inventory, argumentPlayer), argumentPlayer.method_5477());
                sourcePlayer.method_17355((class_3908)screen);
            }
        }
        return 1;
    }

    private static int openEnderChest(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
        class_3222 argumentPlayer = PlayerCommandExtension.getPlayer(context);
        switch (CarpetOrgAdditionSettings.playerCommandOpenPlayerInventory) {
            case FALSE: {
                throw new IllegalStateException();
            }
            case FAKE_PLAYER: {
                CommandUtils.assertFakePlayer((class_1657)argumentPlayer);
            }
            case ONLINE_PLAYER: {
                class_747 screen = new class_747((i, inventory, playerEntity1) -> new PlayerEnderChestScreenHandler(i, inventory, argumentPlayer), argumentPlayer.method_5477());
                sourcePlayer.method_17355((class_3908)screen);
            }
        }
        return 1;
    }

    private static int fakePlayerTeleport(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_3222 fakePlayer = PlayerCommandExtension.getPlayer(context);
        CommandUtils.assertFakePlayer((class_1657)fakePlayer);
        fakePlayer.method_37908().method_43128(null, fakePlayer.field_6014, fakePlayer.field_6036, fakePlayer.field_5969, class_3417.field_14915, fakePlayer.method_5634(), 1.0f, 1.0f);
        fakePlayer.method_14251(player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        class_2561 fakePlayerName = fakePlayer.method_5476();
        class_2561 playerName = player.method_5476();
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.player.tp.success", fakePlayerName, playerName);
        return 1;
    }

    @NotNull
    private static class_3222 getPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 player = server.method_3760().method_14566(playerName);
        if (player == null) {
            throw CommandUtils.createPlayerNotFoundException();
        }
        return player;
    }
}

