/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.logger;

import carpet.logging.HUDLogger;
import carpet.utils.CommandHelper;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3989;
import net.minecraft.class_3990;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.logger.LoggerRegister;
import org.carpetorgaddition.logger.Loggers;
import org.carpetorgaddition.logger.WanderingTraderSpawnLogger;
import org.carpetorgaddition.mixin.logger.LoggerAccessor;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.provider.CommandProvider;
import org.carpetorgaddition.util.provider.TextProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3990.class})
public class WanderingTraderManagerMixin {
    @Shadow
    private int field_17729;
    @Shadow
    private int field_17728;
    @Shadow
    private int field_17730;

    @Inject(method={"spawn"}, at={@At(value="HEAD")})
    private void updataLogger(class_3218 world, boolean spawnMonsters, boolean spawnAnimals, CallbackInfoReturnable<Integer> cir) {
        if (world.method_8450().method_8355(class_1928.field_21832)) {
            int countdown = ((this.field_17729 == 0 ? 1200 : this.field_17729) - (1200 - this.field_17728)) / 20;
            WanderingTraderSpawnLogger.setSpawnCountdown(new WanderingTraderSpawnLogger.SpawnCountdown(countdown, this.field_17730));
            return;
        }
        WanderingTraderSpawnLogger.setSpawnCountdown(null);
    }

    @WrapOperation(method={"trySpawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/WanderingTraderEntity;setPositionTarget(Lnet/minecraft/util/math/BlockPos;I)V")})
    private void broadcastSpawnSuccess(class_3989 trader, class_2338 blockPos, int i, Operation<Void> original) {
        original.call(new Object[]{trader, blockPos, i});
        if (LoggerRegister.wanderingTrader && WanderingTraderSpawnLogger.spawnCountdownNonNull()) {
            MinecraftServer server = trader.method_37908().method_8503();
            if (server == null) {
                return;
            }
            HUDLogger logger = Loggers.getWanderingTraderLogger();
            Set<Map.Entry<String, String>> entries = ((LoggerAccessor)logger).getSubscribedOnlinePlayers().entrySet();
            class_5250 message = TextUtils.translate("carpet.logger.wanderingTrader.message", TextProvider.blockPos(trader.method_24515(), class_124.field_1060));
            class_5250 command = TextUtils.command(TextUtils.translate("carpet.logger.wanderingTrader.message.navigate", new Object[0]), CommandProvider.navigateToUuidEntity(trader.method_5667()), (class_2561)TextUtils.translate("carpet.logger.wanderingTrader.message.navigate.hover", trader.method_5477()), class_124.field_1075, false);
            class_5250 canClickMessage = TextUtils.translate("carpet.logger.wanderingTrader.message.click", TextProvider.blockPos(trader.method_24515(), class_124.field_1060), command);
            for (Map.Entry<String, String> entry : entries) {
                class_3222 player = server.method_3760().method_14566(entry.getKey());
                if (player == null) continue;
                MessageUtils.sendMessage(player, (class_2561)(CommandHelper.canUseCommand((class_2168)player.method_5671(), (Object)CarpetOrgAdditionSettings.commandNavigate) ? canClickMessage : message));
                WorldUtils.playSound(trader.method_37908(), player.method_24515(), trader.method_18010(), trader.method_5634());
            }
        }
    }
}

