/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic;

import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.periodic.PeriodicTaskManagerInterface;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.periodic.task.ServerTaskManager;
import org.carpetorgaddition.rule.RuleSelfManager;
import org.jetbrains.annotations.NotNull;

public class ServerComponentCoordinator {
    private final MinecraftServer server;
    private final ExpressManager expressManager;
    private final ServerTaskManager serverTaskManager = new ServerTaskManager();
    private final RuleSelfManager ruleSelfManager;

    public ServerComponentCoordinator(MinecraftServer server) {
        this.expressManager = new ExpressManager(server);
        this.server = server;
        this.ruleSelfManager = new RuleSelfManager(server);
    }

    public void tick() {
        this.expressManager.tick();
        class_8915 tickManager = this.server.method_54833();
        this.serverTaskManager.tick(tickManager);
    }

    public ExpressManager getExpressManager() {
        return this.expressManager;
    }

    public ServerTaskManager getServerTaskManager() {
        return this.serverTaskManager;
    }

    public RuleSelfManager getRuleSelfManager() {
        return this.ruleSelfManager;
    }

    private void onServerSave() {
        this.ruleSelfManager.onServerSave();
    }

    @NotNull
    public static ServerComponentCoordinator getManager(CommandContext<class_2168> context) {
        return ServerComponentCoordinator.getManager(((class_2168)context.getSource()).method_9211());
    }

    @NotNull
    public static ServerComponentCoordinator getManager(MinecraftServer server) {
        return ((PeriodicTaskManagerInterface)server).carpet_Org_Addition$getServerPeriodicTaskManager();
    }

    static {
        ServerLifecycleEvents.AFTER_SAVE.register((server, flush, force) -> ServerComponentCoordinator.getManager(server).onServerSave());
    }
}

