/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class BlockPosNavigator
extends AbstractNavigator {
    protected final class_2338 blockPos;
    protected final class_1937 world;

    public BlockPosNavigator(@NotNull class_3222 player, class_2338 blockPos, class_1937 world) {
        super(player);
        this.blockPos = blockPos;
        this.world = world;
        this.syncWaypoint(new WaypointUpdateS2CPacket(blockPos.method_46558(), world));
    }

    @Override
    public void tick() {
        class_5250 text;
        if (this.shouldTerminate()) {
            this.clear();
            return;
        }
        if (this.player.method_37908().equals(this.world)) {
            class_5250 in = TextProvider.simpleBlockPos(this.blockPos);
            class_5250 distance = TextUtils.translate("carpet.commands.navigate.hud.distance", MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.blockPos));
            text = this.getHUDText(this.blockPos.method_46558(), (class_2561)in, (class_2561)distance);
        } else {
            text = TextUtils.appendAll(WorldUtils.getDimensionName(this.world), TextProvider.simpleBlockPos(this.blockPos));
        }
        MessageUtils.sendMessageToHud((class_1657)this.player, (class_2561)text);
    }

    @Override
    public BlockPosNavigator copy(class_3222 player) {
        return new BlockPosNavigator(player, this.blockPos, this.world);
    }

    @Override
    protected boolean shouldTerminate() {
        if (this.player.method_51469().equals(this.world) && MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.blockPos) <= 8) {
            MessageUtils.sendMessageToHud((class_1657)this.player, (class_2561)TextUtils.translate("carpet.commands.navigate.hud.reach", new Object[0]));
            this.clear();
            return true;
        }
        return false;
    }
}

