/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.schedule;

import carpet.patches.EntityPlayerMPFake;
import carpet.patches.FakeClientConnection;
import carpet.utils.Messenger;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2726;
import net.minecraft.class_2777;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3738;
import net.minecraft.class_4844;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7417;
import net.minecraft.class_8791;
import net.minecraft.class_8792;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.mixin.rule.EntityAccessor;
import org.carpetorgaddition.mixin.rule.PlayerEntityAccessor;
import org.carpetorgaddition.periodic.task.schedule.PlayerScheduleTask;
import org.carpetorgaddition.util.GameUtils;
import org.carpetorgaddition.util.MessageUtils;

public class ReLoginTask
extends PlayerScheduleTask {
    private final String playerName;
    private int interval;
    private int remainingTick;
    private final MinecraftServer server;
    private final class_5321<class_1937> dimensionId;
    private final CommandContext<class_2168> context;
    private boolean stop = false;
    private int canSpawn = 2;

    public ReLoginTask(String playerName, int interval, MinecraftServer server, class_5321<class_1937> dimensionId, CommandContext<class_2168> context) {
        this.playerName = playerName;
        this.remainingTick = this.interval = interval;
        this.server = server;
        this.dimensionId = dimensionId;
        this.context = context;
    }

    @Override
    public void tick() {
        if (CarpetOrgAdditionSettings.fakePlayerSpawnMemoryLeakFix) {
            class_3222 player = this.server.method_3760().method_14566(this.playerName);
            if (player == null) {
                if (this.canSpawn == 0) {
                    this.homePositionSpawn(this.playerName, this.server, this.dimensionId);
                    this.canSpawn = 2;
                } else {
                    --this.canSpawn;
                }
            } else if (this.remainingTick <= 0) {
                this.remainingTick = this.interval;
                if (player instanceof EntityPlayerMPFake) {
                    EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)player;
                    if (fakePlayer.method_23318() < (double)(fakePlayer.method_51469().method_31607() - 64)) {
                        this.stop();
                    }
                    this.logoutPlayer(fakePlayer);
                }
            } else {
                --this.remainingTick;
            }
        } else {
            Runnable function = () -> {
                MessageUtils.sendErrorMessage(this.context, "carpet.commands.playerManager.schedule.relogin.rule.disable", new Object[0]);
                class_3222 player = this.server.method_3760().method_14566(this.playerName);
                if (player == null) {
                    this.homePositionSpawn(this.playerName, this.server, this.dimensionId);
                }
            };
            throw new TaskExecutionException(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutPlayer(EntityPlayerMPFake fakePlayer) {
        class_2588 text;
        class_2561 reason = Messenger.s((String)"Killed");
        if (fakePlayer.method_5854() instanceof class_1657) {
            fakePlayer.method_5848();
        }
        for (class_1297 passenger : fakePlayer.method_5736()) {
            if (!(passenger instanceof class_1657)) continue;
            passenger.method_5848();
        }
        class_7417 content = reason.method_10851();
        if (content instanceof class_2588 && (text = (class_2588)content).method_11022().equals("multiplayer.disconnect.duplicate_login")) {
            try {
                CarpetOrgAdditionSettings.hiddenLoginMessages = true;
                fakePlayer.field_13987.method_10839(new class_9812(reason));
            }
            finally {
                CarpetOrgAdditionSettings.hiddenLoginMessages = false;
            }
            return;
        }
        this.server.method_18858((Runnable)new class_3738(this.server.method_3780(), () -> {
            try {
                CarpetOrgAdditionSettings.hiddenLoginMessages = true;
                if (fakePlayer.method_31481()) {
                    return;
                }
                fakePlayer.field_13987.method_10839(new class_9812(reason));
            }
            finally {
                CarpetOrgAdditionSettings.hiddenLoginMessages = false;
            }
        }));
    }

    @Override
    public boolean stopped() {
        return this.stop;
    }

    @Override
    public String getLogName() {
        return this.playerName + "\u5468\u671f\u6027\u91cd\u65b0\u4e0a\u7ebf";
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public void onCancel(CommandContext<class_2168> context) {
        this.markRemove();
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.cancel", this.playerName);
        class_3222 player = this.server.method_3760().method_14566(this.playerName);
        if (player == null) {
            this.homePositionSpawn(this.playerName, this.server, this.dimensionId);
        }
    }

    @Override
    public void sendEachMessage(class_2168 source) {
        MessageUtils.sendMessage(source, "carpet.commands.playerManager.schedule.relogin", this.playerName, this.interval);
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.remainingTick = interval;
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void homePositionSpawn(String username, MinecraftServer server, class_5321<class_1937> dimensionId) {
        class_3312 userCache;
        class_3218 worldIn;
        block10: {
            worldIn = server.method_3847(dimensionId);
            if (worldIn == null) {
                return;
            }
            class_3312.method_14510((boolean)false);
            try {
                userCache = server.method_3793();
                if (userCache != null) break block10;
            }
            catch (Throwable throwable) {
                class_3312.method_14510((server.method_3816() && server.method_3828() ? 1 : 0) != 0);
                throw throwable;
            }
            class_3312.method_14510((server.method_3816() && server.method_3828() ? 1 : 0) != 0);
            return;
        }
        GameProfile gameprofile = userCache.method_14515(username).orElse(null);
        class_3312.method_14510((server.method_3816() && server.method_3828() ? 1 : 0) != 0);
        if (gameprofile == null) {
            gameprofile = new GameProfile(class_4844.method_43344((String)username), username);
        }
        EntityPlayerMPFake fakePlayer = EntityPlayerMPFake.respawnFake((MinecraftServer)server, (class_3218)worldIn, (GameProfile)gameprofile, (class_8791)class_8791.method_53821());
        fakePlayer.fixStartingPosition = GameUtils::pass;
        try {
            CarpetOrgAdditionSettings.hiddenLoginMessages = true;
            server.method_3760().method_14570((class_2535)new FakeClientConnection(class_2598.field_11941), (class_3222)fakePlayer, new class_8792(gameprofile, 0, fakePlayer.method_53823(), false));
        }
        catch (NullPointerException e) {
            CarpetOrgAddition.LOGGER.warn("{}\u5728\u5c1d\u8bd5\u5728\u670d\u52a1\u5668\u5173\u95ed\u65f6\u4e0a\u7ebf", (Object)this.playerName, (Object)e);
            this.stop();
            return;
        }
        finally {
            CarpetOrgAdditionSettings.hiddenLoginMessages = false;
        }
        fakePlayer.method_6033(20.0f);
        ((EntityAccessor)fakePlayer).cancelRemoved();
        Objects.requireNonNull(fakePlayer.method_5996(class_5134.field_47761)).method_6192((double)0.6f);
        server.method_3760().method_14589((class_2596)new class_2726((class_1297)fakePlayer, (byte)(fakePlayer.field_6241 * 256.0f / 360.0f)), dimensionId);
        server.method_3760().method_14589((class_2596)new class_2777((class_1297)fakePlayer), dimensionId);
        fakePlayer.method_5841().method_12778(PlayerEntityAccessor.getPlayerModelParts(), (Object)127);
    }
}

