/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.permission;

import carpet.utils.CommandHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.permission.CommandPermission;
import org.carpetorgaddition.util.permission.PermissionLevel;
import org.carpetorgaddition.util.wheel.WorldFormat;
import org.jetbrains.annotations.Nullable;

public class PermissionManager {
    private static final HashMap<String, CommandPermission> PERMISSIONS = new HashMap();
    private static final String PERMISSION_JSON = "permission.json";

    public static CommandPermission register(String node, PermissionLevel level) {
        CommandPermission permission = new CommandPermission(level);
        PERMISSIONS.put(node, permission);
        return permission;
    }

    public static CommandPermission registerHiddenCommand(String node, PermissionLevel level) {
        if (CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION) {
            return PermissionManager.register(node, level);
        }
        return new CommandPermission(level);
    }

    public static List<String> listNode() {
        return PERMISSIONS.keySet().stream().toList();
    }

    @Nullable
    public static CommandPermission getPermission(String node) {
        return PERMISSIONS.get(node);
    }

    public static void reset() {
        PERMISSIONS.clear();
    }

    public static void save(MinecraftServer server) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)1);
        JsonObject permission = new JsonObject();
        PERMISSIONS.forEach((node, perm) -> permission.addProperty(node, perm.getLevel().asString()));
        json.add("permission", (JsonElement)permission);
        WorldFormat worldFormat = new WorldFormat(server, null, new String[0]);
        File file = worldFormat.file(PERMISSION_JSON);
        IOUtils.saveJson(file, json);
    }

    public static void load(MinecraftServer server) {
        WorldFormat worldFormat = new WorldFormat(server, null, new String[0]);
        File file = worldFormat.file(PERMISSION_JSON);
        if (file.isFile()) {
            JsonObject json;
            try {
                json = IOUtils.loadJson(file);
            }
            catch (IOException e) {
                IOUtils.loggerError(e);
                return;
            }
            Set entries = json.get("permission").getAsJsonObject().entrySet();
            for (Map.Entry entry : entries) {
                PermissionLevel level;
                CommandPermission permission = PERMISSIONS.get(entry.getKey());
                if (permission == null) continue;
                try {
                    level = PermissionLevel.fromString(((JsonElement)entry.getValue()).getAsString());
                }
                catch (IllegalArgumentException e) {
                    CarpetOrgAddition.LOGGER.warn("Unable to parse permissions for permission node {}", entry.getKey(), (Object)e);
                    continue;
                }
                permission.setLevel(level);
            }
            CommandHelper.notifyPlayersCommandsChanged((MinecraftServer)server);
        }
    }
}

