/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import carpet.CarpetSettings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.carpetorgaddition.util.IOUtils;
import org.jetbrains.annotations.Nullable;

public class Translation {
    private static final String TRANSLATION_PATH = "assets/carpet-org-addition/lang/%s.json";
    private static final Translation TRANSLATION = new Translation();
    private static final Gson GSON = IOUtils.GSON;
    private final ConcurrentHashMap<String, Map<String, String>> translations = new ConcurrentHashMap();

    private Translation() {
    }

    public static Translation getInstance() {
        return TRANSLATION;
    }

    public Map<String, String> getTranslation() {
        String lang = CarpetSettings.language;
        return this.translations.computeIfAbsent(lang, this::loadTranslation);
    }

    private Map<String, String> loadTranslation(String lang) {
        try {
            Map<String, String> map = this.readTranslation(lang);
            if (map.isEmpty()) {
                Map<String, String> enUs = this.translations.get("en_us");
                if (enUs == null) {
                    enUs = this.readTranslation("en_us");
                }
                return enUs;
            }
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException("\u672a\u80fd\u6210\u529f\u8bfb\u53d6\u8bed\u8a00\u6587\u4ef6", e);
        }
    }

    private Map<String, String> readTranslation(String lang) throws IOException {
        ClassLoader classLoader = Translation.class.getClassLoader();
        String path = TRANSLATION_PATH.formatted(lang);
        InputStream input = classLoader.getResourceAsStream(path);
        return this.readFromInputStream(input);
    }

    private Map<String, String> readFromInputStream(InputStream input) throws IOException {
        if (input == null) {
            return Map.of();
        }
        String json = org.apache.commons.io.IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        TypeToken<Map<String, String>> typeToken = new TypeToken<Map<String, String>>(this){};
        Map map = (Map)GSON.fromJson(json, (TypeToken)typeToken);
        return this.parse(map);
    }

    private Map<String, String> parse(Map<String, String> map) {
        return map;
    }

    @Nullable
    public static String getTranslateValue(String key) {
        Map<String, String> translate = Translation.getInstance().getTranslation();
        return translate.get(key);
    }
}

