/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util.wheel;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.jetbrains.annotations.Nullable;

public class WorldFormat {
    public static final Predicate<File> JSON_EXTENSIONS = file -> file.getName().endsWith(".json");
    private final File directory;

    public WorldFormat(MinecraftServer server, @Nullable String directory, String ... directories) {
        Path path = server.method_27050(class_5218.field_24188).resolve(CarpetOrgAddition.MOD_NAME_LOWER_CASE);
        if (directory == null) {
            if (directories.length != 0) {
                throw new IllegalArgumentException();
            }
        } else {
            path = path.resolve(directory);
        }
        for (String name : directories) {
            path = path.resolve(name);
        }
        this.directory = path.toFile();
        if (this.directory.isDirectory() || this.directory.mkdirs()) {
            return;
        }
        CarpetOrgAddition.LOGGER.error("{}\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25", (Object)this.directory);
    }

    public File file(String fileName) {
        if (fileName.contains(".")) {
            return new File(this.directory, fileName);
        }
        throw new IllegalArgumentException();
    }

    public File file(String fileName, String extension) {
        Object end;
        Object object = end = extension.startsWith(".") ? extension : "." + extension;
        if (fileName.endsWith((String)end)) {
            return new File(this.directory, fileName);
        }
        return new File(this.directory, fileName + (String)end);
    }

    @Deprecated(forRemoval=true)
    public File jsonFile(String fileName) {
        return new File(this.directory, WorldFormat.suppJsonFileName(fileName));
    }

    @Deprecated(forRemoval=true)
    public File getJsonFile(String fileName) {
        fileName = WorldFormat.suppJsonFileName(fileName);
        return new File(this.directory, fileName);
    }

    @Deprecated(forRemoval=true)
    private static String suppJsonFileName(String fileName) {
        if (fileName.split("\\.").length == 1) {
            return fileName + ".json";
        }
        return fileName;
    }

    @Deprecated(forRemoval=true)
    public HashSet<File> listFiles() {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return new HashSet<File>();
        }
        return new HashSet<File>(Arrays.asList(files));
    }

    public List<File> toImmutableFileList() {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return List.of();
        }
        return Stream.of(files).sorted(Comparator.comparing(file -> file.getName().toLowerCase())).toList();
    }

    public List<File> toImmutableFileList(Predicate<File> filter) {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return List.of();
        }
        return Stream.of(files).filter(filter).sorted(Comparator.comparing(file -> file.getName().toLowerCase())).toList();
    }

    @Deprecated(forRemoval=true)
    public boolean fileExists(String fileName) {
        fileName = WorldFormat.suppJsonFileName(fileName);
        File file = this.jsonFile(fileName);
        return file.exists();
    }

    public String toString() {
        return this.directory.toString();
    }
}

