/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlayerAction {
    @Nullable
    private EntityPlayerMPFake fakePlayer;
    private boolean isPlayerChanged = false;

    public AbstractPlayerAction(@Nullable EntityPlayerMPFake fakePlayer) {
        this.fakePlayer = fakePlayer;
        if (this.fakePlayer != null) {
            this.isPlayerChanged = true;
        }
    }

    public final void execute() {
        if (this.isPlayerChanged) {
            this.onAssignPlayer();
            this.isPlayerChanged = false;
        }
        Objects.requireNonNull(this.fakePlayer);
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        this.tick();
    }

    protected abstract void tick();

    public abstract List<class_2561> info();

    public abstract JsonObject toJson();

    public abstract class_2561 getDisplayName();

    public abstract ActionSerializeType getActionSerializeType();

    public boolean isHidden() {
        return false;
    }

    public boolean isValid() {
        if (CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION) {
            return true;
        }
        return !this.isHidden();
    }

    public boolean isStop() {
        return false;
    }

    public void onStop() {
    }

    @NotNull
    protected EntityPlayerMPFake getFakePlayer() {
        return Objects.requireNonNull(this.fakePlayer);
    }

    public boolean equalFakePlayer(@Nullable EntityPlayerMPFake fakePlayer) {
        return Objects.equals(this.fakePlayer, fakePlayer);
    }

    @Contract(value="null -> fail")
    public void setFakePlayer(EntityPlayerMPFake fakePlayer) {
        if (fakePlayer == null) {
            throw new IllegalArgumentException();
        }
        this.fakePlayer = fakePlayer;
        this.onAssignPlayer();
    }

    public void clearFakePlayer() {
        this.fakePlayer = null;
        this.onClearPlayer();
    }

    protected void onAssignPlayer() {
    }

    protected void onClearPlayer() {
    }
}

