/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import com.mojang.brigadier.Message;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.MetaComment;
import org.carpetorgaddition.wheel.Translation;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBuilder {
    @NotNull
    private class_5250 text;

    private TextBuilder(@NotNull class_5250 text) {
        this.text = text;
    }

    public TextBuilder() {
        this(TextBuilder.empty());
    }

    public TextBuilder(class_2561 text) {
        this(text.method_27661());
    }

    public TextBuilder(String str) {
        this(TextBuilder.create(str));
    }

    public TextBuilder(Number number) {
        this(number.toString());
    }

    public TextBuilder(Message message) {
        this(TextBuilder.create(message));
    }

    public static TextBuilder of(String key, Object ... args) {
        return new TextBuilder(TextBuilder.translate(key, args));
    }

    public static TextBuilder fromCombined(Object ... args) {
        return new TextBuilder(TextBuilder.combineAll(args));
    }

    public static class_2561 empty() {
        return class_2561.method_43473();
    }

    public static class_2561 create(String str) {
        return class_2561.method_43470((String)str);
    }

    public static class_2561 create(Number number) {
        return class_2561.method_43470((String)number.toString());
    }

    public static class_2561 create(Message message) {
        return class_2561.method_54155((Message)message).method_27661();
    }

    public static class_2561 create(class_2960 identifier) {
        return TextBuilder.create(identifier.toString());
    }

    public TextBuilder setSuggest(String input) {
        this.text.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610(input)));
        return this;
    }

    public TextBuilder setColor(class_124 color) {
        if (color == null) {
            return this;
        }
        this.text.method_27694(style -> style.method_10977(color));
        return this;
    }

    public TextBuilder setHover(class_2561 text) {
        this.text.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613(text)));
        return this;
    }

    public TextBuilder setHover(MetaComment comment) {
        if (comment.hasContent()) {
            this.setHover(comment.getText());
        }
        return this;
    }

    public TextBuilder setHover(String key, Object ... args) {
        return this.setHover(TextBuilder.translate(key, args));
    }

    public TextBuilder setHover(Throwable e) {
        String error = GenericUtils.getExceptionString(e);
        return this.setHover(TextBuilder.create(error));
    }

    public TextBuilder setStringHover(String hover) {
        return this.setHover(TextBuilder.create(hover));
    }

    public TextBuilder setCopyToClipboard(String str) {
        return this.setCopyToClipboard(str, true);
    }

    public TextBuilder setCopyToClipboard(String str, boolean hover) {
        this.text.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(str)));
        if (hover) {
            this.setHover(TextProvider.COPY_CLICK);
        }
        return this;
    }

    public TextBuilder setCommand(String command) {
        this.text.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(command)));
        return this;
    }

    public TextBuilder setSuggestCommand(String command) {
        this.text.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610(command)));
        return this;
    }

    public TextBuilder setItalic() {
        this.text.method_27694(style -> style.method_10978(Boolean.valueOf(true)));
        return this;
    }

    public TextBuilder setBold() {
        this.text.method_27694(style -> style.method_10982(Boolean.valueOf(true)));
        return this;
    }

    public TextBuilder setStrikethrough() {
        this.text.method_27694(style -> style.method_36140(Boolean.valueOf(true)));
        return this;
    }

    public TextBuilder setUnderline() {
        this.text.method_27694(style -> style.method_30938(Boolean.valueOf(true)));
        return this;
    }

    public TextBuilder setObfuscated() {
        this.text.method_27694(style -> style.method_36141(Boolean.valueOf(true)));
        return this;
    }

    public TextBuilder setGrayItalic() {
        return this.setColor(class_124.field_1080).setItalic();
    }

    public TextBuilder append(String str) {
        return this.append(TextBuilder.create(str));
    }

    public TextBuilder append(@Nullable class_2561 text) {
        if (text == null) {
            return this;
        }
        this.text = TextBuilder.empty().method_27661().method_10852((class_2561)this.text).method_10852(text);
        return this;
    }

    public TextBuilder append(TextBuilder builder) {
        return this.append((class_2561)builder.text);
    }

    public class_2561 build() {
        return this.text;
    }

    public static class_2561 combineAll(Object ... args) {
        class_5250 result = TextBuilder.empty().method_27661();
        for (Object obj : args) {
            TextBuilder.appendEach(obj, result);
        }
        return result;
    }

    public static class_2561 combineList(List<?> list) {
        class_5250 result = TextBuilder.empty().method_27661();
        list.forEach(obj -> TextBuilder.appendEach(obj, result));
        return result;
    }

    private static void appendEach(@Nullable Object obj, class_5250 result) {
        Object object = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, class_2561.class, Message.class, Number.class, TextBuilder.class}, (Object)object, n)) {
            case 0: {
                String str = (String)object;
                result.method_27693(str);
                break;
            }
            case 1: {
                class_2561 text = (class_2561)object;
                result.method_10852(text);
                break;
            }
            case 2: {
                Message message = (Message)object;
                result.method_10852(TextBuilder.create(message));
                break;
            }
            case 3: {
                Number number = (Number)object;
                result.method_27693(String.valueOf(number));
                break;
            }
            case 4: {
                TextBuilder builder = (TextBuilder)object;
                result.method_10852((class_2561)builder.text);
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(obj) + " cannot be parsed as a Text type");
            }
        }
    }

    public static class_2561 joinList(List<? extends class_2561> list) {
        return TextBuilder.joinList(list, TextProvider.NEW_LINE);
    }

    public static class_2561 joinList(List<? extends class_2561> list, class_2561 separator) {
        class_5250 result = TextBuilder.empty().method_27661();
        for (int i = 0; i < list.size(); ++i) {
            result.method_10852(list.get(i));
            if (i >= list.size() - 1) continue;
            result.method_10852(separator);
        }
        return result;
    }

    public static class_2561 translate(String key, Object ... obj) {
        String value = Translation.getTranslateValue(key);
        return class_2561.method_48322((String)key, (String)value, (Object[])obj);
    }
}

