/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1661;
import net.minecraft.class_1730;
import net.minecraft.class_1937;
import net.minecraft.class_2509;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.mixin.accessor.PlayerManagerAccessor;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessManager;
import org.slf4j.Logger;

public class FabricPlayerAccessor {
    private final FakePlayer fabricPlayer;
    private final MinecraftServer server;
    private final FabricPlayerAccessManager accessManager;
    private final Set<class_3222> viewers = new HashSet<class_3222>();
    private final GameProfile gameProfile;

    public FabricPlayerAccessor(MinecraftServer server, GameProfile gameProfile, FabricPlayerAccessManager accessManager) {
        this.server = server;
        this.fabricPlayer = FakePlayer.get((class_3218)server.method_30002(), (GameProfile)gameProfile);
        this.gameProfile = gameProfile;
        this.initFakePlayer(server);
        this.accessManager = accessManager;
        this.accessManager.addViewers(gameProfile, this.viewers);
    }

    private void initFakePlayer(MinecraftServer server) {
        Optional optional = server.method_3760().method_14600((class_3222)this.fabricPlayer);
        class_5321 registryKey = optional.flatMap(nbt -> {
            Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("Dimension"));
            DataResult dimension = class_2874.method_28521((Dynamic)dynamic);
            return dimension.resultOrPartial(arg_0 -> ((Logger)CarpetOrgAddition.LOGGER).error(arg_0));
        }).orElse(class_1937.field_25179);
        class_3218 world = server.method_3847(registryKey);
        if (world != null) {
            this.fabricPlayer.method_51468(world);
        }
    }

    public class_1661 getInventory() {
        return this.fabricPlayer.method_31548();
    }

    public class_1730 getEnderChest() {
        return this.fabricPlayer.method_7274();
    }

    public void onOpen(class_3222 player) {
        this.viewers.add(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(class_3222 player) {
        this.viewers.remove(player);
        if (this.viewers.isEmpty()) {
            try {
                class_3324 playerManager = this.server.method_3760();
                PlayerManagerAccessor accessor = (PlayerManagerAccessor)playerManager;
                accessor.savePlayerEntityData((class_3222)this.fabricPlayer);
            }
            catch (RuntimeException e) {
                CarpetOrgAddition.LOGGER.error("Failed to save player data for {}", (Object)this.gameProfile.getName(), (Object)e);
            }
            finally {
                this.accessManager.removeAccessor(this.gameProfile);
                this.accessManager.removeViewer(this.gameProfile);
            }
        }
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }
}

