/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.network.handler;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.network.c2s.ObjectSearchTaskC2SPacket;
import org.carpetorgaddition.network.codec.ObjectSearchTaskCodecs;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.periodic.task.ServerTaskManager;
import org.carpetorgaddition.periodic.task.search.BlockSearchTask;
import org.carpetorgaddition.periodic.task.search.ItemSearchTask;
import org.carpetorgaddition.periodic.task.search.OfflinePlayerSearchTask;
import org.carpetorgaddition.periodic.task.search.TradeItemSearchTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.permission.CommandPermission;
import org.carpetorgaddition.wheel.permission.PermissionManager;
import org.carpetorgaddition.wheel.predicate.BlockStatePredicate;
import org.carpetorgaddition.wheel.predicate.ItemStackPredicate;
import org.carpetorgaddition.wheel.traverser.BlockEntityTraverser;
import org.carpetorgaddition.wheel.traverser.BlockPosTraverser;

public class ObjectSearchTaskPacketHandler
implements ServerPlayNetworking.PlayPayloadHandler<ObjectSearchTaskC2SPacket> {
    public void receive(ObjectSearchTaskC2SPacket packet, ServerPlayNetworking.Context context) {
        OfflinePlayerSearchTask serverTask;
        class_3222 player = context.player();
        MinecraftServer server = FetcherUtils.getServer(player);
        ServerTaskManager taskManager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
        class_3218 world = FetcherUtils.getWorld(player);
        class_2168 source = player.method_5671();
        class_2338 blockPos = player.method_24515();
        try {
            this.checkPermission(packet.type(), source);
        }
        catch (CommandSyntaxException e) {
            CommandUtils.handlingException(e, source);
            return;
        }
        switch (packet.type()) {
            case ITEM: {
                Record decode = ObjectSearchTaskCodecs.ITEM_SEARCH_CODEC.decode(packet.json());
                ItemStackPredicate predicate = ItemStackPredicate.of(((ObjectSearchTaskCodecs.ItemSearchContext)decode).list());
                BlockEntityTraverser traverser = new BlockEntityTraverser((class_1937)world, blockPos, ((ObjectSearchTaskCodecs.ItemSearchContext)decode).range());
                ServerTask serverTask2 = new ItemSearchTask((class_1937)world, predicate, traverser, source);
                break;
            }
            case OFFLINE_PLAYER_ITEM: {
                Record decode = ObjectSearchTaskCodecs.OFFLINE_PLAYER_SEARCH_CODEC.decode(packet.json());
                ItemStackPredicate predicate = ItemStackPredicate.of(((ObjectSearchTaskCodecs.OfflinePlayerItemSearchContext)decode).list());
                ServerTask serverTask2 = new OfflinePlayerSearchTask(source, predicate, player);
                break;
            }
            case BLOCK: {
                Record decode = ObjectSearchTaskCodecs.BLOCK_SEARCH_CODEC.decode(packet.json());
                BlockPosTraverser traverser = new BlockPosTraverser((class_1937)world, blockPos, ((ObjectSearchTaskCodecs.BlockSearchContext)decode).range());
                Object predicate = BlockStatePredicate.ofBlocks(((ObjectSearchTaskCodecs.BlockSearchContext)decode).list());
                ServerTask serverTask2 = new BlockSearchTask(world, blockPos, traverser, source, (BlockStatePredicate)predicate);
                break;
            }
            case TRADE_ITEM: {
                Record decode = ObjectSearchTaskCodecs.TRADE_ITEM_SEARCH_CODEC.decode(packet.json());
                BlockPosTraverser traverser = new BlockPosTraverser((class_1937)world, blockPos, ((ObjectSearchTaskCodecs.TradeItemSearchContext)decode).range());
                Object predicate = ItemStackPredicate.of(((ObjectSearchTaskCodecs.TradeItemSearchContext)decode).list());
                ServerTask serverTask2 = new TradeItemSearchTask((class_1937)world, traverser, blockPos, (ItemStackPredicate)predicate, source);
                break;
            }
            default: {
                ServerTask serverTask2 = serverTask = null;
            }
        }
        if (serverTask == null) {
            return;
        }
        CommandUtils.handlingException(() -> taskManager.addTask(serverTask), source);
    }

    private void checkPermission(ObjectSearchTaskC2SPacket.Type type, class_2168 source) throws CommandSyntaxException {
        CommandPermission permission;
        switch (type) {
            case ITEM: {
                CommandPermission commandPermission = PermissionManager.getPermission("finder.item");
                break;
            }
            case OFFLINE_PLAYER_ITEM: {
                CommandPermission commandPermission = PermissionManager.getPermission("finder.item.from.offline_player");
                break;
            }
            case BLOCK: {
                CommandPermission commandPermission = PermissionManager.getPermission("finder.block");
                break;
            }
            default: {
                CommandPermission commandPermission = permission = null;
            }
        }
        if (permission == null || permission.test(source)) {
            return;
        }
        throw CommandUtils.createException("carpet.command.permission.insufficient", new Object[0]);
    }
}

