/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.dataupdate.DataUpdater;
import org.carpetorgaddition.dataupdate.WaypointDataUpdater;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.MetaComment;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.WorldFormat;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Waypoint {
    public static final String WAYPOINT = "waypoint";
    private class_2338 blockPos;
    @Nullable
    private class_2338 anotherBlockPos;
    private final class_1937 world;
    @NotNull
    private MetaComment comment = new MetaComment();
    private final String creator;
    private final MinecraftServer server;
    private final String name;

    public Waypoint(class_2338 blockPos, String name, class_1937 world, String creator, MinecraftServer server) {
        this.name = name;
        this.blockPos = blockPos;
        this.world = world;
        this.creator = creator;
        this.server = server;
    }

    public Waypoint(class_2338 blockPos, String name, class_3222 player) {
        this(blockPos, name, (class_1937)FetcherUtils.getWorld(player), FetcherUtils.getPlayerName((class_1657)player), FetcherUtils.getServer(player));
    }

    public void save() throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)2);
        JsonObject pos = new JsonObject();
        pos.addProperty("x", (Number)this.blockPos.method_10263());
        pos.addProperty("y", (Number)this.blockPos.method_10264());
        pos.addProperty("z", (Number)this.blockPos.method_10260());
        json.add("pos", (JsonElement)pos);
        json.addProperty("dimension", this.getWorldAsString());
        json.addProperty("creator", this.creator);
        json.addProperty("comment", this.comment.getComment());
        JsonObject anotherPos = new JsonObject();
        if (this.anotherBlockPos != null) {
            anotherPos.addProperty("x", (Number)this.anotherBlockPos.method_10263());
            anotherPos.addProperty("y", (Number)this.anotherBlockPos.method_10264());
            anotherPos.addProperty("z", (Number)this.anotherBlockPos.method_10260());
        }
        json.add("another_pos", (JsonElement)anotherPos);
        WorldFormat worldFormat = new WorldFormat(this.server, WAYPOINT, new String[0]);
        File file = worldFormat.file(this.name + ".json");
        IOUtils.write(file, json);
    }

    public static Waypoint load(MinecraftServer server, String name) throws IOException {
        JsonObject anotherPos;
        WorldFormat worldFormat = new WorldFormat(server, WAYPOINT, new String[0]);
        File file = worldFormat.file(name, ".json");
        JsonObject json = IOUtils.loadJson(file);
        WaypointDataUpdater dataUpdater = new WaypointDataUpdater();
        json = dataUpdater.update(json, DataUpdater.getVersion(json));
        JsonObject pos = json.get("pos").getAsJsonObject();
        int x = pos.get("x").getAsInt();
        int y = pos.get("y").getAsInt();
        int z = pos.get("z").getAsInt();
        class_2338 blockPos = new class_2338(x, y, z);
        String dimension = IOUtils.jsonHasElement(json, "dimension") ? json.get("dimension").getAsString() : "minecraft:overworld";
        String creator = IOUtils.jsonHasElement(json, "creator") ? json.get("creator").getAsString() : "#none";
        class_3218 world = WorldUtils.getWorld(server, dimension);
        Waypoint waypoint = new Waypoint(blockPos, name, (class_1937)world, creator, server);
        if (json.has("another_pos") && IOUtils.jsonHasElement(anotherPos = json.get("another_pos").getAsJsonObject(), "x", "y", "z")) {
            int anotherX = anotherPos.get("x").getAsInt();
            int anotherY = anotherPos.get("y").getAsInt();
            int anotherZ = anotherPos.get("z").getAsInt();
            waypoint.setAnotherBlockPos(new class_2338(anotherX, anotherY, anotherZ));
        }
        waypoint.setComment(json.get("comment").getAsString());
        return waypoint;
    }

    public class_2561 line() {
        return switch (this.getWorldAsString()) {
            case "minecraft:overworld" -> {
                if (this.anotherBlockPos == null) {
                    yield TextBuilder.translate("carpet.commands.locations.show.overworld", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1060));
                }
                yield TextBuilder.translate("carpet.commands.locations.show.overworld_and_the_nether", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1060), TextProvider.blockPos(this.anotherBlockPos, class_124.field_1061));
            }
            case "minecraft:the_nether" -> {
                if (this.anotherBlockPos == null) {
                    yield TextBuilder.translate("carpet.commands.locations.show.the_nether", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1061));
                }
                yield TextBuilder.translate("carpet.commands.locations.show.the_nether_and_overworld", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1061), TextProvider.blockPos(this.anotherBlockPos, class_124.field_1060));
            }
            case "minecraft:the_end" -> TextBuilder.translate("carpet.commands.locations.show.the_end", this.formatName(), TextProvider.blockPos(this.blockPos, class_124.field_1064));
            default -> TextBuilder.translate("carpet.commands.locations.show.custom_dimension", this.formatName(), this.getWorldAsString(), TextProvider.blockPos(this.blockPos, class_124.field_1060));
        };
    }

    private class_2561 formatName() {
        TextBuilder builder = new TextBuilder("[" + this.name.split("\\.")[0] + "]");
        if (this.comment.isEmpty()) {
            return builder.build();
        }
        builder.setHover(this.comment.getText());
        return builder.build();
    }

    public void setAnotherBlockPos(@Nullable class_2338 anotherBlockPos) {
        this.anotherBlockPos = anotherBlockPos;
    }

    public void setComment(String comment) {
        this.comment = comment == null || comment.isEmpty() ? new MetaComment() : new MetaComment(comment);
    }

    public void setBlockPos(class_2338 blockPos) {
        this.blockPos = blockPos;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    @Nullable
    public class_2338 getAnotherBlockPos() {
        return this.anotherBlockPos;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public String getWorldAsString() {
        return WorldUtils.getDimensionId(this.world);
    }

    public String getName() {
        return this.name;
    }

    public boolean canAddAnother() {
        return this.world.method_27983() == class_1937.field_25179 || this.world.method_27983() == class_1937.field_25180;
    }
}

