/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.predicate;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2247;
import net.minecraft.class_2248;
import net.minecraft.class_2252;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_3619;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import org.carpetorgaddition.mixin.accessor.StateAccessor;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStatePredicate
implements BiPredicate<class_1937, class_2338> {
    protected final String content;
    private final BiPredicate<class_1937, class_2338> biPredicate;
    @Nullable
    private final class_2248 block;
    public static final BlockStatePredicate EMPTY = new BlockStatePredicate();

    public BlockStatePredicate(@NotNull class_2248 block) {
        this.content = GenericUtils.getIdAsString(block);
        this.biPredicate = (world, blockPos) -> world.method_8320(blockPos).method_27852(block);
        this.block = block;
    }

    public BlockStatePredicate(class_2680 blockState) {
        StringBuilder builder = new StringBuilder();
        class_2248 block = blockState.method_26204();
        builder.append(GenericUtils.getIdAsString(block));
        Map defaultEntries = block.method_9564().method_11656();
        List<String> list = new HashMap(blockState.method_11656()).entrySet().stream().filter(entry -> !((Comparable)entry.getValue()).equals(defaultEntries.get(entry.getKey()))).filter(Objects::nonNull).map(StateAccessor.getPropertyMapPrinter()).toList();
        if (list.isEmpty()) {
            this.block = block;
        } else {
            this.block = null;
            builder.append("[");
            list.forEach(builder::append);
            builder.append("]");
        }
        this.content = builder.toString();
        this.biPredicate = (world, blockPos) -> world.method_8320(blockPos).equals(blockState);
    }

    private BlockStatePredicate() {
        this.content = GenericUtils.getIdAsString(class_2246.field_10124);
        this.biPredicate = (world, blockPos) -> false;
        this.block = class_2246.field_10124;
    }

    private BlockStatePredicate(String content, BiPredicate<class_1937, class_2338> biPredicate, @Nullable class_2248 block) {
        this.content = content;
        this.biPredicate = biPredicate;
        this.block = block;
    }

    private BlockStatePredicate(String content, class_2247 argument) {
        this.content = content;
        this.biPredicate = (world, blockPos) -> argument.method_9493(new class_2694((class_4538)world, blockPos, false));
        Set set = argument.method_35759();
        this.block = set.isEmpty() ? argument.method_9494().method_26204() : null;
    }

    private BlockStatePredicate(LinkedHashSet<class_2248> blocks) {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (class_2248 block : blocks) {
            joiner.add(GenericUtils.getIdAsString(block));
        }
        this.content = joiner.toString();
        this.biPredicate = (world, blockPos) -> blocks.contains(world.method_8320(blockPos).method_26204());
        this.block = null;
    }

    public static BlockStatePredicate ofBlocks(Collection<class_2248> collection) {
        LinkedHashSet<class_2248> blocks = new LinkedHashSet<class_2248>(collection);
        return switch (blocks.size()) {
            case 0 -> EMPTY;
            case 1 -> new BlockStatePredicate(blocks.getFirst());
            default -> new MatchAnyBlockPredicate(blocks);
        };
    }

    public static BlockStatePredicate ofWorldEater() {
        return new WorldEaterBlockPredicate();
    }

    public static BlockStatePredicate ofPredicate(CommandContext<class_2168> context, String arguments) {
        for (ParsedCommandNode commandNode : context.getNodes()) {
            Predicate argument;
            ArgumentCommandNode node;
            CommandNode commandNode2 = commandNode.getNode();
            if (!(commandNode2 instanceof ArgumentCommandNode) || !Objects.equals((node = (ArgumentCommandNode)commandNode2).getName(), arguments)) continue;
            StringRange range = commandNode.getRange();
            String content = context.getInput().substring(range.getStart(), range.getEnd());
            try {
                argument = class_2252.method_9644(context, (String)arguments);
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            BiPredicate<class_1937, class_2338> biPredicate = (world, blockPos) -> argument.test(new class_2694((class_4538)world, blockPos, false));
            class_2248 block = BlockStatePredicate.tryConvert(content);
            return new BlockStatePredicate(content, biPredicate, block);
        }
        throw new IllegalArgumentException();
    }

    public static BlockStatePredicate ofState(CommandContext<class_2168> context, String arguments) {
        for (ParsedCommandNode commandNode : context.getNodes()) {
            ArgumentCommandNode node;
            CommandNode commandNode2 = commandNode.getNode();
            if (!(commandNode2 instanceof ArgumentCommandNode) || !Objects.equals((node = (ArgumentCommandNode)commandNode2).getName(), arguments)) continue;
            StringRange range = commandNode.getRange();
            String content = context.getInput().substring(range.getStart(), range.getEnd());
            class_2247 argument = class_2257.method_9655(context, (String)arguments);
            return new BlockStatePredicate(content, argument);
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    private static class_2248 tryConvert(String id) {
        if ("air".equals(id) || "minecraft:air".equals(id)) {
            return class_2246.field_10124;
        }
        try {
            class_2248 block = GenericUtils.getBlock(id);
            if (block.method_9564().method_26215()) {
                return null;
            }
            return block;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Override
    public boolean test(class_1937 world, class_2338 blockPos) {
        int chunkZ;
        int chunkX = class_4076.method_18675((int)blockPos.method_10263());
        if (world.method_8393(chunkX, chunkZ = class_4076.method_18675((int)blockPos.method_10260()))) {
            return this.biPredicate.test(world, blockPos);
        }
        return false;
    }

    public class_2561 getDisplayName() {
        if (this == EMPTY) {
            return class_2246.field_10124.method_9518();
        }
        if (this.block != null) {
            return this.block.method_9518();
        }
        if (this.content.length() > 30) {
            String substring = this.content.substring(0, 30);
            class_2561 ellipsis = TextBuilder.create("...");
            class_2561 result = TextBuilder.combineAll(substring, ellipsis);
            TextBuilder builder = new TextBuilder(result).setGrayItalic().setHover(this.content, new Object[0]);
            return builder.build();
        }
        return TextBuilder.create(this.content);
    }

    public static class MatchAnyBlockPredicate
    extends BlockStatePredicate {
        private final LinkedHashSet<class_2248> blocks;

        private MatchAnyBlockPredicate(LinkedHashSet<class_2248> blocks) {
            super(blocks);
            this.blocks = blocks;
        }

        @Override
        public class_2561 getDisplayName() {
            if (this.content.length() > 30) {
                String display = this.content.substring(0, 30) + "...";
                TextBuilder builder = new TextBuilder(display);
                StringJoiner joiner = new StringJoiner(",\n");
                for (class_2248 block : this.blocks) {
                    joiner.add(GenericUtils.getIdAsString(block));
                }
                return builder.setGrayItalic().setStringHover(joiner.toString()).build();
            }
            return TextBuilder.create(this.content);
        }
    }

    public static class WorldEaterBlockPredicate
    extends BlockStatePredicate {
        private WorldEaterBlockPredicate() {
        }

        @Override
        public boolean test(class_1937 world, class_2338 pos) {
            boolean hasWater;
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_27852(class_2246.field_9987) || blockState.method_26215() || blockState.method_26204() instanceof class_2404) {
                return false;
            }
            if (blockState.method_26223() == class_3619.field_15971) {
                return false;
            }
            if (blockState.method_26204().method_9520() > 17.0f) {
                return true;
            }
            boolean blockPiston = blockState.method_26204() instanceof class_2237 || blockState.method_26223() == class_3619.field_15972;
            boolean bl = hasWater = !blockState.method_26227().method_15769();
            if (blockPiston && hasWater) {
                return true;
            }
            return hasWater && this.canPush(world, pos);
        }

        private boolean canPush(class_1937 world, class_2338 pos) {
            for (int i = 1; i <= 8; ++i) {
                class_2680 blockState = world.method_8320(pos.method_10087(i));
                class_3619 pistonBehavior = blockState.method_26223();
                if (pistonBehavior == class_3619.field_15972) {
                    return true;
                }
                if (pistonBehavior != class_3619.field_15971) continue;
                return false;
            }
            return true;
        }

        @Override
        public class_2561 getDisplayName() {
            return TextBuilder.translate("carpet.commands.finder.may_affect_world_eater_block.name", new Object[0]);
        }
    }
}

