/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.command;

import carpet.patches.EntityPlayerMPFake;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8103;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSafeAfkInterface;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
implements FakePlayerSafeAfkInterface {
    @Unique
    private final class_3222 thisPlayer = (class_3222)this;
    @Unique
    private float safeAfkThreshold = -1.0f;

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void damage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.safeAfkThreshold > 0.0f && this.thisPlayer instanceof EntityPlayerMPFake) {
            this.safeAfk(source, amount);
        }
    }

    @WrapOperation(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageTracker;getDeathMessage()Lnet/minecraft/text/Text;")})
    private class_2561 getDeathMessage(class_1283 instance, Operation<class_2561> original) {
        if (CarpetOrgAdditionSettings.committingSuicide.get().booleanValue()) {
            return TextBuilder.translate("carpet.commands.killMe.suicide", this.thisPlayer.method_5476());
        }
        return (class_2561)original.call(new Object[]{instance});
    }

    @Unique
    private void safeAfk(class_1282 source, float amount) {
        if (this.canTriggerTotemOfUndying(source)) {
            return;
        }
        if (this.carpet_Org_Addition$afkTriggerFail()) {
            TextBuilder builder = TextBuilder.of("carpet.commands.playerManager.safeafk.trigger.fail", this.thisPlayer.method_5476());
            builder.setItalic();
            builder.setColor(class_124.field_1061);
            builder.setHover(this.report(source, amount));
            MessageUtils.broadcastMessage(FetcherUtils.getServer(this.thisPlayer), builder.build());
            return;
        }
        if (this.thisPlayer.method_6032() <= this.safeAfkThreshold) {
            String health = MathUtils.numberToTwoDecimalString(this.thisPlayer.method_6032());
            TextBuilder builder = TextBuilder.of("carpet.commands.playerManager.safeafk.trigger.success", this.thisPlayer.method_5476(), health);
            builder.setHover(this.report(source, amount));
            builder.setGrayItalic();
            MessageUtils.broadcastMessage(FetcherUtils.getServer(this.thisPlayer), builder.build());
            this.thisPlayer.method_7344().method_7580(20);
            this.thisPlayer.method_5768(this.thisPlayer.method_51469());
        }
    }

    @Unique
    private class_2561 report(class_1282 damageSource, float amount) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        Object attacker = Optional.ofNullable(damageSource.method_5529()).map(entity -> entity.method_5476()).orElse("null");
        Object source = Optional.ofNullable(damageSource.method_5526()).map(entity -> entity.method_5476()).orElse("null");
        list.add(TextBuilder.translate("carpet.commands.playerManager.safeafk.info.attacker", attacker));
        list.add(TextBuilder.translate("carpet.commands.playerManager.safeafk.info.source", source));
        list.add(TextBuilder.translate("carpet.commands.playerManager.safeafk.info.type", damageSource.method_5525()));
        list.add(TextBuilder.translate("carpet.commands.playerManager.safeafk.info.amount", String.valueOf(amount)));
        return TextBuilder.joinList(list);
    }

    @Unique
    private boolean canTriggerTotemOfUndying(class_1282 source) {
        if (source.method_48789(class_8103.field_42242)) {
            return false;
        }
        switch (CarpetOrgAdditionSettings.betterTotemOfUndying.get()) {
            case VANILLA: {
                if (this.thisPlayer.method_6047().method_31574(class_1802.field_8288)) {
                    return true;
                }
                if (!this.thisPlayer.method_6079().method_31574(class_1802.field_8288)) break;
                return true;
            }
            case INVENTORY_WITH_SHULKER_BOX: {
                int i;
                class_1661 inventory = this.thisPlayer.method_31548();
                for (i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 itemStack = inventory.method_5438(i);
                    if (!InventoryUtils.hasItemStack(itemStack, stack -> stack.method_31574(class_1802.field_8288))) continue;
                    return true;
                }
            }
            case INVENTORY: {
                int i;
                class_1661 inventory = this.thisPlayer.method_31548();
                for (i = 0; i < inventory.method_5439(); ++i) {
                    if (!inventory.method_5438(i).method_31574(class_1802.field_8288)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return false;
    }

    @Override
    public void carpet_Org_Addition$setHealthThreshold(float threshold) {
        this.safeAfkThreshold = threshold;
    }

    @Override
    public float carpet_Org_Addition$getHealthThreshold() {
        return this.safeAfkThreshold;
    }

    @Override
    public boolean carpet_Org_Addition$afkTriggerFail() {
        return false;
    }
}

