/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2561;
import net.minecraft.class_2665;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import org.apache.commons.lang3.mutable.MutableInt;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.BlockExcavator;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerPathfinder;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.BedrockBreakingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.BedrockRegionType;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.BreakingState;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.PlayerWorkPhase;
import org.carpetorgaddition.periodic.fakeplayer.action.bedrock.StepResult;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.util.JsonUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.wheel.BlockEntityIterator;
import org.carpetorgaddition.wheel.BlockIterator;
import org.carpetorgaddition.wheel.Counter;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.inventory.ContainerComponentInventory;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BedrockAction
extends AbstractPlayerAction {
    private final LinkedHashSet<BedrockBreakingContext> contexts = new LinkedHashSet();
    private final HashSet<class_2338> lavas = new HashSet();
    private final BlockIterator blockIterator;
    private final BedrockRegionType regionType;
    @NotNull
    private FakePlayerPathfinder pathfinder = FakePlayerPathfinder.EMPTY;
    private final boolean ai;
    private int recycleTimer;
    @Nullable
    private BedrockBreakingContext currentContext;
    @NotNull
    private PlayerWorkPhase phase = PlayerWorkPhase.WORK;
    @NotNull
    private PlayerWorkPhase prevPhase = this.getPhase();
    @Nullable
    private class_2338 bedrockTarget;
    @Nullable
    private class_1542 recentItemEntity;
    private boolean isMovingToNearbyBedrock = false;
    private boolean hasAction;
    private boolean materialCollectionComplete = false;
    private final Counter<class_2338> invalidBedrock = new Counter();
    private final ArrayList<class_1542> itemEntities = new ArrayList();
    private static final int MATERIAL_RECYCLING_TIME = 3600;

    private BedrockAction(EntityPlayerMPFake fakePlayer, BlockIterator blockIterator, BedrockRegionType regionType, boolean ai, boolean timedMaterialRecycling) {
        super(fakePlayer);
        this.blockIterator = blockIterator;
        this.regionType = regionType;
        this.ai = ai;
        this.recycleTimer = timedMaterialRecycling ? 3600 : -1;
    }

    public BedrockAction(EntityPlayerMPFake fakePlayer, class_2338 from, class_2338 to, boolean ai, boolean timedMaterialRecycling) {
        this(fakePlayer, new BlockIterator(from, to), BedrockRegionType.CUBOID, ai, timedMaterialRecycling);
    }

    public BedrockAction(EntityPlayerMPFake fakePlayer, class_2338 center, int radius, int height, boolean ai, boolean timedMaterialRecycling) {
        this(fakePlayer, new CylinderBlockIterator(center, radius, height), BedrockRegionType.CYLINDER, ai, timedMaterialRecycling);
    }

    @Override
    protected void tick() {
        if (this.ai) {
            this.pathfinder.tick();
            EntityPlayerMPFake fakePlayer = this.getFakePlayer();
            if (BlockEntityIterator.ofAbove(fakePlayer, 3).contains(class_1540.class)) {
                this.pathfinder.pause(3);
            }
            this.itemEntities.removeIf(class_1297::method_31481);
            if (this.recentItemEntity != null && this.recentItemEntity.method_31481()) {
                this.recentItemEntity = null;
            }
            if (this.shouldEat()) {
                if (this.getPhase() != PlayerWorkPhase.EAT) {
                    this.prevPhase = this.getPhase();
                }
                this.setPhase(PlayerWorkPhase.EAT);
            } else if (this.recycleTimer > 0) {
                --this.recycleTimer;
                if (this.recycleTimer == 0) {
                    this.setPhase(PlayerWorkPhase.COLLECT);
                }
            }
            if (this.recycleTimer < -1) {
                throw new IllegalStateException("The remaining time for material recycling should not be %s".formatted(this.recycleTimer));
            }
            switch (this.getPhase()) {
                case WORK: {
                    this.work();
                    break;
                }
                case EAT: {
                    this.eat();
                    break;
                }
                case COLLECT: {
                    this.collectingMaterials();
                }
            }
        } else {
            this.work();
        }
    }

    private void work() {
        this.invalidBedrock.trim();
        this.hasAction = false;
        if (this.materialCollectionComplete) {
            this.materialCollectionComplete = false;
            this.bedrockTarget = null;
        }
        this.drainFluidLava();
        for (class_2338 blockPos : this.invalidBedrock) {
            this.invalidBedrock.decrement(blockPos);
        }
        if (this.tickCurrentWork()) {
            return;
        }
        class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
        this.removeIf(arg_0 -> this.lambda$work$0((class_1937)world, arg_0));
        double range = this.getFakePlayer().method_55754();
        class_238 box = new class_238(this.getFakePlayer().method_24515()).method_1014(Math.min(range, 10.0));
        BlockIterator area = new BlockIterator(box);
        for (class_2338 blockPos : area) {
            if (!this.canInteract(blockPos) || !this.inSelectionArea(blockPos)) continue;
            class_2680 blockState = world.method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_9987)) {
                this.add(new BedrockBreakingContext(blockPos));
                continue;
            }
            if (!blockState.method_27852(class_2246.field_10164)) continue;
            this.lavas.add(blockPos);
        }
        for (BedrockBreakingContext context : this.contexts) {
            if (context == this.currentContext || !this.tickWork(context)) continue;
            return;
        }
        if (this.ai) {
            this.setGotoTarget((class_1937)world);
        }
    }

    private void setGotoTarget(class_1937 world) {
        if (this.hasAction) {
            if (this.pathfinder.isFinished()) {
                this.bedrockTarget = null;
            }
            return;
        }
        this.isMovingToNearbyBedrock = false;
        Optional<class_2338> optional = this.getMovingTarget();
        if (optional.isPresent() && this.canInteract(optional.get())) {
            this.selectRandomBedrock(world);
            this.invalidBedrock.set(optional.get(), 200);
            return;
        }
        for (BedrockBreakingContext context : this.contexts) {
            class_2338 blockPos = context.getBedrockPos();
            if (this.invalidBedrock.getCount(blockPos) > 0) continue;
            this.bedrockTarget = blockPos;
            return;
        }
        this.selectRandomBedrock(world);
    }

    private void selectRandomBedrock(class_1937 world) {
        if (this.pathfinder.isInvalid()) {
            for (int i = 0; i < 100; ++i) {
                class_2338 blockPos = this.blockIterator.randomBlockPos();
                if (!world.method_8320(blockPos).method_27852(class_2246.field_9987)) continue;
                this.bedrockTarget = blockPos;
                return;
            }
        }
    }

    private boolean canInteract(class_2338 blockPos) {
        return this.getFakePlayer().method_56093(blockPos, 0.0);
    }

    private boolean tickCurrentWork() {
        if (this.currentContext == null) {
            return false;
        }
        if (this.contexts.contains(this.currentContext)) {
            if (!this.isMovingToNearbyBedrock) {
                this.isMovingToNearbyBedrock = true;
                this.bedrockTarget = this.currentContext.getBedrockPos();
            }
            return this.tickWork(this.currentContext);
        }
        this.currentContext = null;
        return false;
    }

    private boolean tickWork(BedrockBreakingContext context) {
        int loopCount = 0;
        block4: while (true) {
            if (++loopCount > 10) {
                throw new InfiniteLoopException();
            }
            StepResult stepResult = this.start(context);
            switch (stepResult) {
                case COMPLETION: {
                    break block4;
                }
                case TICK_COMPLETION: {
                    this.currentContext = context;
                    return true;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        return false;
    }

    private StepResult start(BedrockBreakingContext context) {
        class_2338 bedrockPos = context.getBedrockPos();
        switch (context.getState()) {
            case PLACE_THE_PISTON_FACING_UP: {
                if (this.hasMaterial()) {
                    StepResult stepResult = this.placePiston(bedrockPos);
                    if (stepResult == StepResult.CONTINUE) {
                        context.nextStep();
                        break;
                    }
                    return stepResult;
                }
                this.setPhase(PlayerWorkPhase.COLLECT);
                return StepResult.TICK_COMPLETION;
            }
            case PLACE_AND_ACTIVATE_THE_LEVER: {
                StepResult stepResult = this.placeAndActivateTheLever(context);
                if (stepResult != StepResult.CONTINUE) {
                    return stepResult;
                }
                context.nextStep();
                return StepResult.COMPLETION;
            }
            case PISTON_BREAK_BEDROCK: {
                StepResult stepResult = this.pistonBreakBedrock(context);
                switch (stepResult) {
                    case COMPLETION: {
                        context.nextStep();
                        return StepResult.COMPLETION;
                    }
                    case TICK_COMPLETION: {
                        return StepResult.TICK_COMPLETION;
                    }
                    case FAIL: {
                        context.fail();
                        return StepResult.COMPLETION;
                    }
                }
                throw new IllegalStateException();
            }
            case CLEAN_PISTON: {
                if (this.cleanPiston(bedrockPos.method_10084())) {
                    context.nextStep();
                    break;
                }
                return StepResult.TICK_COMPLETION;
            }
            default: {
                return StepResult.COMPLETION;
            }
        }
        return StepResult.CONTINUE;
    }

    private boolean hasMaterial() {
        MutableInt pistonCount = new MutableInt(0);
        MutableInt levelCount = new MutableInt(0);
        ArrayList<class_1799> list = new ArrayList<class_1799>((Collection<class_1799>)this.getFakePlayer().method_31548().method_67533());
        list.add(this.getFakePlayer().method_6079());
        if (BedrockAction.hasMaterial(list, pistonCount, levelCount)) {
            return true;
        }
        if (CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get().booleanValue()) {
            return list.stream().filter(InventoryUtils::isOperableSulkerBox).map(ContainerComponentInventory::new).anyMatch(inventory -> BedrockAction.hasMaterial((Iterable<class_1799>)((Object)inventory), pistonCount, levelCount));
        }
        return false;
    }

    private static boolean hasMaterial(Iterable<class_1799> list, MutableInt pistonCount, MutableInt levelCount) {
        for (class_1799 itemStack : list) {
            if (itemStack.method_31574(class_1802.field_8249)) {
                pistonCount.add(itemStack.method_7947());
            } else if (itemStack.method_31574(class_1802.field_8865)) {
                levelCount.add(itemStack.method_7947());
            }
            if (pistonCount.getValue() < 2 || levelCount.getValue() < 1) continue;
            return true;
        }
        return false;
    }

    private StepResult placePiston(class_2338 bedrockPos) {
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
        if (this.aboveHasFallingBlockEntity((class_1937)world, bedrockPos)) {
            return StepResult.COMPLETION;
        }
        class_2338 up = bedrockPos.method_10086(1);
        class_2680 blockState = world.method_8320(up);
        BlockExcavator blockExcavator = FetcherUtils.getBlockExcavator(this.getFakePlayer());
        boolean isPiston = false;
        if (!this.isReplaceableBlock(blockState)) {
            if (blockState.method_27852(class_2246.field_10560) && blockState.method_11654((class_2769)class_2665.field_10927) == class_2350.field_11036) {
                isPiston = true;
            } else {
                if (this.canMine(blockState, (class_1937)world, up)) {
                    return this.tickBreakBlock(blockExcavator, up);
                }
                return StepResult.COMPLETION;
            }
        }
        up = bedrockPos.method_10086(2);
        blockState = world.method_8320(up);
        if (isPiston && blockState.method_27852(class_2246.field_10379) && blockState.method_11654((class_2769)class_2671.field_10927) == class_2350.field_11036) {
            return StepResult.CONTINUE;
        }
        if (blockState.method_26215() || blockState.method_26223() == class_3619.field_15971) {
            if (isPiston) {
                return StepResult.CONTINUE;
            }
            if (this.placePiston(bedrockPos, class_2350.field_11036).method_23665()) {
                return StepResult.CONTINUE;
            }
            return StepResult.COMPLETION;
        }
        if (this.canMine(blockState, (class_1937)world, up)) {
            return this.tickBreakBlock(blockExcavator, up);
        }
        return StepResult.COMPLETION;
    }

    private boolean canMine(class_2680 blockState, class_1937 world, class_2338 blockPos) {
        if (blockState.method_26215()) {
            return true;
        }
        boolean isPiston = blockState.method_27852(class_2246.field_10560);
        if (isPiston) {
            if (((class_2350)blockState.method_11654((class_2769)class_2665.field_10927)).method_10166() != class_2350.class_2351.field_11052) {
                return true;
            }
            if (!world.method_8320(blockPos.method_10074()).method_27852(class_2246.field_9987)) {
                return true;
            }
            if (blockState.method_11654((class_2769)class_2665.field_10927) == class_2350.field_11033) {
                return true;
            }
        }
        if (blockState.method_27852(class_2246.field_10363)) {
            return blockState.method_11654((class_2769)class_2401.field_11007) != class_2738.field_12471;
        }
        if (isPiston || blockState.method_27852(class_2246.field_10379)) {
            return false;
        }
        return blockState.method_26214((class_1922)world, blockPos) != -1.0f && BlockExcavator.canBreak(this.getFakePlayer(), blockPos);
    }

    private StepResult placeAndActivateTheLever(BedrockBreakingContext context) {
        class_2338 bedrockPos = context.getBedrockPos();
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
        class_3225 interactionManager = fakePlayer.field_13974;
        class_2350 direction = null;
        for (class_2350 value : MathUtils.HORIZONTAL) {
            class_2338 offset = bedrockPos.method_10093(value);
            class_2680 blockState = world.method_8320(offset);
            if (this.isReplaceableBlock(blockState)) {
                direction = value;
                continue;
            }
            BlockExcavator blockExcavator = FetcherUtils.getBlockExcavator(fakePlayer);
            if (blockState.method_27852(class_2246.field_10363)) {
                if (blockState.method_11654((class_2769)class_2341.field_11007) != class_2738.field_12471) {
                    return this.tickBreakBlock(blockExcavator, offset);
                }
                if (bedrockPos.equals((Object)offset.method_10079((class_2350)blockState.method_11654((class_2769)class_2401.field_11177), -1))) {
                    if (context.getLeverPos() == null) {
                        context.setLeverPos(offset);
                        if (((Boolean)blockState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) continue;
                        this.interactionLever(offset);
                        continue;
                    }
                    return this.tickBreakBlock(blockExcavator, offset);
                }
                class_2338 supportBlockPos = offset.method_10079((class_2350)blockState.method_11654((class_2769)class_2401.field_11177), -1);
                if (world.method_8320(supportBlockPos).method_27852(class_2246.field_9987) && this.inSelectionArea(supportBlockPos)) continue;
                return this.tickBreakBlock(blockExcavator, offset);
            }
            if (!this.inSelectionArea(offset) || !this.canMine(blockState, (class_1937)world, offset)) continue;
            return this.tickBreakBlock(blockExcavator, offset);
        }
        if (context.getLeverPos() != null) {
            return StepResult.CONTINUE;
        }
        if (direction == null) {
            return StepResult.COMPLETION;
        }
        class_2338 offset = bedrockPos.method_10093(direction);
        class_2680 blockState = world.method_8320(offset.method_10074());
        if (blockState.method_27852(class_2246.field_10560) && blockState.method_11654((class_2769)class_2665.field_10927) == class_2350.field_11036) {
            return StepResult.COMPLETION;
        }
        if (blockState.method_27852(class_2246.field_10008)) {
            return StepResult.COMPLETION;
        }
        FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5810, stack -> stack.method_31574(class_1802.field_8865));
        FakePlayerUtils.look(fakePlayer, direction.method_10153());
        class_3965 hitResult = new class_3965(bedrockPos.method_46558(), direction, bedrockPos, false);
        interactionManager.method_14262((class_3222)fakePlayer, (class_1937)world, fakePlayer.method_6079(), class_1268.field_5810, hitResult);
        this.interactionLever(offset);
        context.setLeverPos(offset);
        return StepResult.CONTINUE;
    }

    private boolean isReplaceableBlock(class_2680 blockState) {
        if (blockState.method_26215()) {
            return true;
        }
        if (blockState.method_26164(class_3481.field_44471)) {
            if (blockState.method_27852(class_2246.field_10477)) {
                return (Integer)blockState.method_11654((class_2769)class_2488.field_11518) == 1;
            }
            return true;
        }
        return false;
    }

    private StepResult pistonBreakBedrock(BedrockBreakingContext context) {
        class_2338 bedrockPos = context.getBedrockPos();
        class_2338 up = bedrockPos.method_10084();
        class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
        class_2680 blockState = world.method_8320(up);
        if (blockState.method_27852(class_2246.field_10560) && ((Boolean)blockState.method_11654((class_2769)class_2665.field_12191)).booleanValue()) {
            BlockExcavator blockExcavator = FetcherUtils.getBlockExcavator(this.getFakePlayer());
            this.switchTool(blockState, (class_1937)world, up, this.getFakePlayer());
            int currentTime = blockExcavator.computingRemainingMiningTime(up);
            if (currentTime == 1) {
                class_2338 leverPos = context.getLeverPos();
                class_2680 leverState = world.method_8320(leverPos);
                if (leverState.method_27852(class_2246.field_10363)) {
                    if (((Boolean)leverState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                        this.interactionLever(leverPos);
                    }
                    this.closeTheSurroundingLevers(up);
                    context.setLeverPos(null);
                    this.breakBlock(blockExcavator, up, false);
                    if (this.placePiston(bedrockPos, class_2350.field_11033).method_23665()) {
                        return StepResult.COMPLETION;
                    }
                }
                return StepResult.COMPLETION;
            }
            this.breakBlock(blockExcavator, up, false);
            return StepResult.TICK_COMPLETION;
        }
        return StepResult.FAIL;
    }

    private void closeTheSurroundingLevers(class_2338 pistonPos) {
        class_2338 down;
        class_2680 downBlockState;
        class_2338 offset;
        class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
        Consumer<class_2338> consumer = arg_0 -> this.lambda$closeTheSurroundingLevers$3((class_1937)world, arg_0);
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            offset = pistonPos.method_10093(direction);
            consumer.accept(offset);
            for (class_2350 value : MathUtils.HORIZONTAL) {
                consumer.accept(offset.method_10093(value));
            }
        }
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            offset = pistonPos.method_10084().method_10093(direction);
            consumer.accept(offset);
            for (class_2350 value : MathUtils.HORIZONTAL) {
                consumer.accept(offset.method_10093(value));
            }
        }
        consumer.accept(pistonPos.method_10086(2));
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            consumer.accept(pistonPos.method_10086(2).method_10093(direction));
        }
        class_2338 up = pistonPos.method_10086(3);
        class_2680 upBlockState = world.method_8320(up);
        if (upBlockState.method_27852(class_2246.field_10363) && ((Boolean)upBlockState.method_11654((class_2769)class_2401.field_11265)).booleanValue() && upBlockState.method_11654((class_2769)class_2401.field_11007) == class_2738.field_12475) {
            this.interactionLever(up);
        }
        if ((downBlockState = world.method_8320(down = pistonPos.method_10087(2))).method_27852(class_2246.field_10363) && ((Boolean)downBlockState.method_11654((class_2769)class_2401.field_11265)).booleanValue() && downBlockState.method_11654((class_2769)class_2401.field_11007) == class_2738.field_12473) {
            this.interactionLever(down);
        }
    }

    private boolean cleanPiston(class_2338 blockPos) {
        BlockExcavator blockExcavator = FetcherUtils.getBlockExcavator(this.getFakePlayer());
        class_2680 blockState = FetcherUtils.getWorld((class_3222)this.getFakePlayer()).method_8320(blockPos);
        if (blockState.method_26215()) {
            return true;
        }
        if (blockState.method_27852(class_2246.field_10008)) {
            return false;
        }
        if (blockState.method_27852(class_2246.field_10560)) {
            return this.breakBlock(blockExcavator, blockPos, true);
        }
        return true;
    }

    private StepResult tickBreakBlock(BlockExcavator blockExcavator, class_2338 blockPos) {
        EntityPlayerMPFake player = blockExcavator.getPlayer();
        class_3218 world = FetcherUtils.getWorld((class_3222)player);
        if (class_2346.method_10128((class_2680)world.method_8320(blockPos.method_10084())) && this.aboveHasFallingBlockEntity((class_1937)world, blockPos)) {
            return StepResult.COMPLETION;
        }
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_27852(class_2246.field_10336) || blockState.method_27852(class_2246.field_10099)) {
            for (int i = 1; i <= 2; ++i) {
                class_2338 up = blockPos.method_10086(i);
                if (!(world.method_8320(up).method_26204() instanceof class_2346)) continue;
                if (this.canInteract(up)) {
                    return this.breakBlock(blockExcavator, up, true) ? StepResult.COMPLETION : StepResult.TICK_COMPLETION;
                }
                return StepResult.COMPLETION;
            }
        }
        if (world.method_8320(blockPos).method_26204() instanceof class_2346) {
            class_2350 direction;
            class_2338 offset;
            boolean hasTorch = this.hasTorch();
            while (world.method_8320(offset = blockPos.method_10093(direction = hasTorch ? class_2350.field_11033 : class_2350.field_11036)).method_26204() instanceof class_2346 && this.canInteract(offset.method_10093(direction))) {
                blockPos = offset;
            }
            boolean broken = this.breakBlock(blockExcavator, blockPos, true);
            if (broken && hasTorch) {
                FakePlayerUtils.replenishment(player, class_1268.field_5810, itemStack -> itemStack.method_31574(class_1802.field_8810));
                this.placeBlock(blockPos);
                return StepResult.COMPLETION;
            }
            return StepResult.TICK_COMPLETION;
        }
        return this.breakBlock(blockExcavator, blockPos, true) ? StepResult.COMPLETION : StepResult.TICK_COMPLETION;
    }

    private boolean hasTorch() {
        return FakePlayerUtils.hasItem(this.getFakePlayer(), itemStack -> itemStack.method_31574(class_1802.field_8810));
    }

    private boolean aboveHasFallingBlockEntity(class_1937 world, class_2338 blockPos) {
        return this.hasTorch() && BlockEntityIterator.ofAbove(world, blockPos, 0).contains(class_1540.class);
    }

    private boolean breakBlock(BlockExcavator blockExcavator, class_2338 blockPos, boolean switchTool) {
        this.hasAction = true;
        EntityPlayerMPFake player = blockExcavator.getPlayer();
        class_3218 world = FetcherUtils.getWorld((class_3222)player);
        class_2680 blockState = world.method_8320(blockPos);
        if (switchTool) {
            this.switchTool(blockState, (class_1937)world, blockPos, player);
        }
        return blockExcavator.mining(blockPos, class_2350.field_11033, false);
    }

    private void switchTool(class_2680 blockState, class_1937 world, class_2338 blockPos, EntityPlayerMPFake player) {
        boolean replenishment = FakePlayerUtils.replenishment(player, itemStack -> {
            if (player.method_68878()) {
                return itemStack.method_7909().method_7885(player.method_6047(), blockState, world, blockPos, (class_1309)player);
            }
            if (itemStack.method_7960()) {
                return false;
            }
            if (this.isDamaged((class_1799)itemStack)) {
                return false;
            }
            return itemStack.method_7924(blockState) > 1.0f;
        });
        if (replenishment) {
            return;
        }
        FakePlayerUtils.replenishment(this.getFakePlayer(), itemStack -> !this.isDamaged((class_1799)itemStack));
    }

    private boolean isDamaged(class_1799 itemStack) {
        return itemStack.method_7963() && itemStack.method_7936() - itemStack.method_7919() <= 10 && EnchantmentUtils.canRepairWithXp(itemStack);
    }

    private class_1269 placePiston(class_2338 bedrockPos, class_2350 direction) {
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        class_3225 interactionManager = fakePlayer.field_13974;
        FakePlayerUtils.look(fakePlayer, direction.method_10153());
        FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5810, itemStack -> itemStack.method_31574(class_1802.field_8249));
        class_3965 hitResult = new class_3965(class_243.method_26410((class_2382)bedrockPos, (double)1.0), direction, bedrockPos.method_10084(), false);
        class_1269 result = interactionManager.method_14262((class_3222)fakePlayer, (class_1937)FetcherUtils.getWorld((class_3222)fakePlayer), fakePlayer.method_6079(), class_1268.field_5810, hitResult);
        if (result.method_23665()) {
            this.hasAction = true;
        }
        return result;
    }

    private void placeBlock(class_2338 blockPos) {
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        class_3225 interactionManager = fakePlayer.field_13974;
        fakePlayer.method_5702(class_2183.class_2184.field_9851, blockPos.method_46558());
        class_3965 hitResult = new class_3965(class_243.method_26410((class_2382)blockPos, (double)1.0), class_2350.field_11033, blockPos, false);
        interactionManager.method_14262((class_3222)fakePlayer, (class_1937)FetcherUtils.getWorld((class_3222)fakePlayer), fakePlayer.method_6079(), class_1268.field_5810, hitResult);
    }

    private void interactionLever(class_2338 leverPos) {
        class_3225 interactionManager = this.getFakePlayer().field_13974;
        class_3965 hitResult = new class_3965(leverPos.method_46558(), class_2350.field_11036, leverPos, false);
        class_1269 result = interactionManager.method_14262((class_3222)this.getFakePlayer(), (class_1937)FetcherUtils.getWorld((class_3222)this.getFakePlayer()), this.getFakePlayer().method_6047(), class_1268.field_5808, hitResult);
        if (result.method_23665()) {
            this.hasAction = true;
        }
    }

    private boolean shouldEat() {
        if (FakePlayerUtils.hasItem(this.getFakePlayer(), InventoryUtils::isFoodItem)) {
            if (this.getFakePlayer().method_31549().field_7480) {
                return false;
            }
            class_1702 hungerManager = this.getFakePlayer().method_7344();
            if (hungerManager.method_7586() <= 10) {
                return true;
            }
            if (hungerManager.method_7587()) {
                return this.getFakePlayer().method_6063() - this.getFakePlayer().method_6032() > 2.0f;
            }
        }
        return false;
    }

    private void drainFluidLava() {
        Iterator<class_2338> iterator = this.lavas.iterator();
        while (iterator.hasNext()) {
            class_2338 blockPos = iterator.next();
            EntityPlayerMPFake fakePlayer = this.getFakePlayer();
            class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
            if (this.canInteract(blockPos) && (FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5810, this.canDrainFluid((class_1937)world, blockPos)) || FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5810, itemStack -> itemStack.method_31574(class_1802.field_8249)))) {
                this.placeBlock(blockPos);
            }
            iterator.remove();
        }
    }

    private Predicate<class_1799> canDrainFluid(class_1937 world, class_2338 blockPos) {
        return itemStack -> {
            if (itemStack.method_31574(class_1802.field_8249) || itemStack.method_31574(class_1802.field_8793)) {
                return false;
            }
            class_1792 patt0$temp = itemStack.method_7909();
            if (patt0$temp instanceof class_1747) {
                class_1747 blockItem = (class_1747)patt0$temp;
                class_2248 block = blockItem.method_7711();
                if (block instanceof class_2237) {
                    return false;
                }
                return block.method_9564().method_26212((class_1922)world, blockPos);
            }
            return false;
        };
    }

    private void eat() {
        PlayerWorkPhase prev;
        PlayerWorkPhase playerWorkPhase = prev = this.prevPhase == PlayerWorkPhase.EAT ? PlayerWorkPhase.WORK : this.prevPhase;
        if (this.getFakePlayer().method_31549().field_7480) {
            this.setPhase(prev);
            return;
        }
        if (this.getFakePlayer().method_7332(false)) {
            if (this.getFakePlayer().method_6030().method_7960()) {
                if (FakePlayerUtils.replenishment(this.getFakePlayer(), InventoryUtils::isFoodItem)) {
                    class_3225 interactionManager = this.getFakePlayer().field_13974;
                    class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
                    class_1799 food = this.getFakePlayer().method_6047();
                    interactionManager.method_14256((class_3222)this.getFakePlayer(), (class_1937)world, food, class_1268.field_5808);
                } else {
                    this.setPhase(prev);
                }
            }
        } else {
            this.setPhase(prev);
        }
    }

    private void collectingMaterials() {
        boolean finished = this.pathfinder.isFinished();
        if (finished) {
            this.dropGarbageAndCollectMaterial();
        }
        if ((this.pathfinder.isInvalid() || this.pathfinder.isInaccessible()) && !this.itemEntities.isEmpty()) {
            this.itemEntities.remove(this.recentItemEntity);
            this.pathfinder.pause(1);
            this.materialCollectionComplete = true;
            this.recentItemEntity = null;
            if (this.itemEntities.isEmpty()) {
                this.setPhase(PlayerWorkPhase.WORK);
                return;
            }
        }
        if (this.itemEntities.isEmpty()) {
            class_238 box = this.blockIterator.toBox().method_1014(10.0);
            List<class_1542> list = FetcherUtils.getWorld((class_3222)this.getFakePlayer()).method_18467(class_1542.class, box).stream().filter(itemEntity -> this.isMaterial(itemEntity.method_6983())).toList();
            this.itemEntities.addAll(list);
        }
        if (this.itemEntities.isEmpty()) {
            this.setPhase(PlayerWorkPhase.WORK);
            return;
        }
        if (this.recentItemEntity != null) {
            return;
        }
        class_1542 recentEntity = this.itemEntities.getFirst();
        for (class_1542 itemEntity2 : this.itemEntities) {
            if (!(recentEntity.method_5739((class_1297)this.getFakePlayer()) > itemEntity2.method_5739((class_1297)this.getFakePlayer()))) continue;
            recentEntity = itemEntity2;
        }
        this.recentItemEntity = recentEntity;
    }

    private void dropGarbageAndCollectMaterial() {
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        class_1661 inventory = fakePlayer.method_31548();
        class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
        class_2338 blockPos = fakePlayer.method_24515();
        class_1799 mostStack = class_1799.field_8037;
        for (int i = 0; i < inventory.method_67533().size(); ++i) {
            class_1747 blockItem;
            class_1799 itemStack2 = (class_1799)inventory.method_67533().get(i);
            if (itemStack2.method_7960()) {
                return;
            }
            class_1792 class_17922 = itemStack2.method_7909();
            if (!(class_17922 instanceof class_1747) || !(blockItem = (class_1747)class_17922).method_7711().method_9564().method_26212((class_1922)world, blockPos) || itemStack2.method_7947() <= mostStack.method_7947()) continue;
            mostStack = itemStack2;
        }
        class_1799 finalMostStack = mostStack;
        boolean dropped = FakePlayerUtils.dropInventoryItem(fakePlayer, itemStack -> itemStack != finalMostStack && this.isGarbage((class_1799)itemStack));
        if (dropped) {
            return;
        }
        if (CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get().booleanValue()) {
            this.collectMaterialToShulkerBox();
            this.collectToolToShulkerBox();
        }
    }

    private void collectMaterialToShulkerBox() {
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        class_1661 inventory = fakePlayer.method_31548();
        class_1799 most = InventoryUtils.findMostAbundantStack((class_1263)inventory, this::isMaterial);
        class_1723 screenHandler = fakePlayer.field_7498;
        for (int i = 9; i <= 44; ++i) {
            if (!InventoryUtils.canMerge(most, screenHandler.method_7611(i).method_7677())) continue;
            FakePlayerUtils.dropCursorStack((class_1703)screenHandler, fakePlayer);
            FakePlayerUtils.throwItem((class_1703)screenHandler, i, fakePlayer);
            break;
        }
        FakePlayerUtils.sorting(fakePlayer);
        boolean isFoundMost = false;
        for (int i = 9; i <= 44; ++i) {
            class_1799 itemStack = screenHandler.method_7611(i).method_7677();
            if (itemStack.method_7960() || InventoryUtils.isShulkerBoxItem(itemStack)) {
                return;
            }
            if (InventoryUtils.canMerge(itemStack, most)) {
                isFoundMost = true;
                class_1799 result = InventoryUtils.putItemToInventoryShulkerBox(itemStack, fakePlayer);
                if (result.method_7960()) continue;
                FakePlayerUtils.putToEmptySlotOrDrop(fakePlayer, result);
                this.setPhase(PlayerWorkPhase.WORK);
                return;
            }
            if (!isFoundMost) continue;
            return;
        }
    }

    private void collectToolToShulkerBox() {
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        FakePlayerUtils.sorting(fakePlayer);
        class_1723 screenHandler = fakePlayer.field_7498;
        for (int i = 9; i <= 44; ++i) {
            class_1799 result;
            class_1799 itemStack = screenHandler.method_7611(i).method_7677();
            if (itemStack.method_7960() || InventoryUtils.isShulkerBoxItem(itemStack)) {
                return;
            }
            if (!InventoryUtils.isToolItem(itemStack) || !this.isDamaged(itemStack) || (result = InventoryUtils.putItemToInventoryShulkerBox(itemStack, fakePlayer)).method_7960()) continue;
            FakePlayerUtils.putToEmptySlotOrDrop(fakePlayer, result);
            return;
        }
    }

    private boolean isGarbage(class_1799 itemStack) {
        if (this.isMaterial(itemStack)) {
            return false;
        }
        if (itemStack.method_31574(class_1802.field_8810)) {
            return false;
        }
        if (InventoryUtils.isFoodItem(itemStack)) {
            return false;
        }
        if (InventoryUtils.isShulkerBoxItem(itemStack)) {
            return false;
        }
        return !InventoryUtils.isToolItem(itemStack);
    }

    private boolean isMaterial(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8249) || itemStack.method_31574(class_1802.field_8865);
    }

    public void add(BedrockBreakingContext context) {
        this.contexts.add(context);
    }

    public void removeIf(Predicate<BedrockBreakingContext> predicate) {
        this.contexts.removeIf(predicate);
    }

    public boolean inSelectionArea(class_2338 blockPos) {
        return this.blockIterator.contains(blockPos);
    }

    @Override
    public ArrayList<class_2561> info() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(TextBuilder.translate("carpet.commands.playerAction.info.bedrock", this.getFakePlayer().method_5476()));
        switch (this.regionType) {
            case CUBOID: {
                class_2561 from = TextProvider.blockPos(this.blockIterator.getMinBlockPos(), class_124.field_1060);
                class_2561 to = TextProvider.blockPos(this.blockIterator.getMaxBlockPos(), class_124.field_1060);
                list.add(TextBuilder.translate("carpet.commands.playerAction.info.bedrock.cuboid.range", from, to));
                break;
            }
            case CYLINDER: {
                CylinderBlockIterator iterator = (CylinderBlockIterator)this.blockIterator;
                class_2561 center = TextProvider.blockPos(iterator.center);
                list.add(TextBuilder.translate("carpet.commands.playerAction.info.bedrock.cylinder.center", center));
                list.add(TextBuilder.translate("carpet.commands.playerAction.info.bedrock.cylinder.radius", iterator.radius));
                list.add(TextBuilder.translate("carpet.commands.playerAction.info.bedrock.cylinder.height", iterator.height));
            }
        }
        if (this.ai) {
            list.add(TextBuilder.translate("carpet.commands.playerAction.info.bedrock.ai.enable", new Object[0]));
        }
        return list;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("region_type", this.regionType.name().toLowerCase());
        switch (this.regionType) {
            case CUBOID: {
                class_2338 minBlockPos = this.blockIterator.getMinBlockPos();
                json.add("from", (JsonElement)JsonUtils.toJson(minBlockPos));
                class_2338 maxBlockPos = this.blockIterator.getMaxBlockPos();
                json.add("to", (JsonElement)JsonUtils.toJson(maxBlockPos));
                break;
            }
            case CYLINDER: {
                CylinderBlockIterator iterator = (CylinderBlockIterator)this.blockIterator;
                json.add("center", (JsonElement)JsonUtils.toJson(iterator.center));
                json.addProperty("radius", (Number)iterator.radius);
                json.addProperty("height", (Number)iterator.height);
            }
        }
        json.addProperty("ai", Boolean.valueOf(this.ai));
        json.addProperty("timed_material_recycling", Boolean.valueOf(this.recycleTimer != -1));
        return json;
    }

    @Override
    public class_2561 getDisplayName() {
        return TextBuilder.translate("carpet.commands.playerAction.action.bedrock", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.BEDROCK;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    protected void onAssignPlayer() {
        this.pathfinder = FakePlayerPathfinder.of(this::getFakePlayer, this::getMovingTarget);
    }

    @Override
    protected void onClearPlayer() {
        this.pathfinder = FakePlayerPathfinder.EMPTY;
    }

    public Optional<class_2338> getMovingTarget() {
        switch (this.getPhase()) {
            case WORK: {
                class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
                if (this.bedrockTarget == null) {
                    return Optional.empty();
                }
                class_2680 blockState = world.method_8320(this.bedrockTarget);
                if (blockState.method_27852(class_2246.field_9987) || this.isMovingToNearbyBedrock) {
                    return Optional.of(this.bedrockTarget);
                }
                return Optional.empty();
            }
            case COLLECT: {
                if (this.recentItemEntity == null || this.recentItemEntity.method_31481()) {
                    return Optional.empty();
                }
                return Optional.of(this.recentItemEntity.method_24515());
            }
        }
        return Optional.empty();
    }

    @Override
    public void onStop() {
        this.pathfinder.onStop();
    }

    @NotNull
    private PlayerWorkPhase getPhase() {
        return this.phase;
    }

    private void setPhase(@NotNull PlayerWorkPhase phase) {
        this.phase = phase;
        if (this.recycleTimer != -1 && phase == PlayerWorkPhase.WORK) {
            this.recycleTimer = 3600;
        }
    }

    private /* synthetic */ void lambda$closeTheSurroundingLevers$3(class_1937 world, class_2338 blockPos) {
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26215()) {
            return;
        }
        if (blockState.method_27852(class_2246.field_10363) && ((Boolean)blockState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
            this.interactionLever(blockPos);
        }
    }

    private /* synthetic */ boolean lambda$work$0(class_1937 world, BedrockBreakingContext context) {
        if (context.getState() == BreakingState.COMPLETE) {
            return true;
        }
        if (world.method_8320(context.getBedrockPos()).method_27852(class_2246.field_9987)) {
            return !this.canInteract(context.getBedrockPos());
        }
        return context.getState() != BreakingState.CLEAN_PISTON;
    }

    public static class CylinderBlockIterator
    extends BlockIterator {
        private final class_2338 center;
        private final int radius;
        private final int height;

        public CylinderBlockIterator(class_2338 center, int radius, int height) {
            super(new class_2338(center.method_10263() - radius, center.method_10264(), center.method_10260() - radius), new class_2338(center.method_10263() + radius, center.method_10264() + height, center.method_10260() + radius));
            this.center = center;
            this.radius = radius;
            this.height = height;
        }

        @Override
        public boolean contains(class_2338 blockPos) {
            return super.contains(blockPos) && MathUtils.getCalculateBlockIntegerDistance(this.center, blockPos) <= this.radius;
        }

        @Override
        public class_2338 randomBlockPos() {
            class_2338 blockPos;
            while (!this.contains(blockPos = super.randomBlockPos())) {
            }
            return blockPos;
        }

        @Override
        @NotNull
        public Iterator<class_2338> iterator() {
            return new Iterator<class_2338>(){
                private final Iterator<class_2338> iterator;
                private class_2338 blockPos;
                {
                    this.iterator = CylinderBlockIterator.super.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.blockPos == null) {
                        while (this.iterator.hasNext()) {
                            class_2338 next = this.iterator.next();
                            if (!this.contains(next)) continue;
                            this.blockPos = next;
                            break;
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public class_2338 next() {
                    class_2338 result = this.blockPos;
                    this.blockPos = null;
                    return result;
                }
            };
        }
    }
}

