/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import java.lang.runtime.SwitchBootstraps;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class EntityNavigator
extends AbstractNavigator {
    private final class_1297 entity;
    private final boolean isContinue;

    public EntityNavigator(@NotNull class_3222 player, class_1297 entity, boolean isContinue) {
        super(player);
        this.entity = entity;
        this.isContinue = isContinue;
    }

    @Override
    public void tick() {
        class_2561 text;
        if (this.targetDeath()) {
            MessageUtils.sendMessageToHud((class_1657)this.player, TextBuilder.translate("carpet.commands.navigate.hud.target_death", new Object[0]));
            this.clear();
            return;
        }
        class_1937 world = FetcherUtils.getWorld(this.entity);
        if (FetcherUtils.getWorld(this.player).equals(world)) {
            class_2561 in = TextBuilder.translate("carpet.commands.navigate.hud.in", this.entity.method_5477(), TextProvider.simpleBlockPos(this.entity.method_24515()));
            class_2561 distance = TextBuilder.translate("carpet.commands.navigate.hud.distance", MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.entity.method_24515()));
            class_243 eyePos = this.entity.method_33571();
            text = this.getHUDText(eyePos, in, distance);
        } else {
            text = TextBuilder.translate("carpet.commands.navigate.hud.in", this.entity.method_5477(), TextBuilder.combineAll(TextProvider.dimension(FetcherUtils.getWorld(this.entity)), TextProvider.simpleBlockPos(this.entity.method_24515())));
        }
        MessageUtils.sendMessageToHud((class_1657)this.player, text);
        this.syncWaypoint(new WaypointUpdateS2CPacket(this.entity.method_33571(), world));
    }

    @Override
    protected boolean shouldTerminate() {
        if (this.isContinue) {
            return false;
        }
        if (FetcherUtils.getWorld(this.player).equals(FetcherUtils.getWorld(this.entity)) && MathUtils.getBlockDistance(this.player.method_24515(), this.entity.method_24515()) <= 8.0) {
            MessageUtils.sendMessageToHud((class_1657)this.player, TextBuilder.translate("carpet.commands.navigate.hud.reach", new Object[0]));
            this.clear();
            return true;
        }
        return false;
    }

    private boolean targetDeath() {
        class_1297 class_12972 = this.entity;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3222.class, class_1309.class}, (Object)class_12972, n)) {
            case -1: {
                return true;
            }
            case 0: {
                class_3222 serverPlayerEntity = (class_3222)class_12972;
                if (serverPlayerEntity.method_31481()) {
                    MinecraftServer server = FetcherUtils.getServer(serverPlayerEntity);
                    UUID uuid = serverPlayerEntity.method_5667();
                    class_3222 newPlayer = server.method_3760().method_14602(uuid);
                    if (newPlayer == null) {
                        return true;
                    }
                    this.manager.setNavigator((class_1297)newPlayer, this.isContinue);
                }
                return false;
            }
            case 1: {
                class_1309 livingEntity = (class_1309)class_12972;
                class_1297.class_5529 removalReason = livingEntity.method_35049();
                if (livingEntity.method_29504() || removalReason != null && removalReason.method_31486()) {
                    return true;
                }
                MinecraftServer server = FetcherUtils.getServer((class_1297)livingEntity);
                if (server == null) {
                    return true;
                }
                UUID uuid = this.entity.method_5667();
                for (class_3218 world : server.method_3738()) {
                    class_1297 newEntity = world.method_66347(uuid);
                    if (newEntity == null || newEntity.method_31481()) continue;
                    if (this.entity != newEntity) {
                        this.manager.setNavigator(newEntity, this.isContinue);
                    }
                    return false;
                }
                return false;
            }
        }
        return this.entity.method_31481();
    }

    @Override
    public EntityNavigator copy(class_3222 player) {
        return new EntityNavigator(player, this.entity, this.isContinue);
    }
}

