/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.wheel.CreateFakePlayerContext;
import org.jetbrains.annotations.Nullable;

public class GenericUtils {
    public static final ThreadLocal<Consumer<EntityPlayerMPFake>> FAKE_PLAYER_SPAWNING = new ThreadLocal();
    public static final ThreadLocal<Consumer<EntityPlayerMPFake>> INTERNAL_FAKE_PLAYER_SPAWNING = new ThreadLocal();
    public static final int CURRENT_DATA_VERSION = GenericUtils.getNbtDataVersion();

    private GenericUtils() {
    }

    @Nullable
    public static class_1297 getEntity(MinecraftServer server, UUID uuid) {
        for (class_3218 world : server.method_3738()) {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static Optional<class_3222> getPlayer(MinecraftServer server, UUID uuid) {
        return Optional.ofNullable(server.method_3760().method_14602(uuid));
    }

    public static Optional<class_3222> getPlayer(MinecraftServer server, String name) {
        return Optional.ofNullable(server.method_3760().method_14566(name));
    }

    public static Optional<class_3222> getPlayer(MinecraftServer server, GameProfile gameProfile) {
        return GenericUtils.getPlayer(server, gameProfile.getName());
    }

    public static void createFakePlayer(String username, MinecraftServer server, CreateFakePlayerContext context) {
        GenericUtils.createFakePlayer(username, server, context.pos(), context.yaw(), context.pitch(), context.dimension(), context.gamemode(), context.flying(), context.consumer());
    }

    public static Optional<UUID> uuidFromString(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(UUID.fromString(str));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFakePlayer(String username, MinecraftServer server, class_243 pos, double yaw, double pitch, class_5321<class_1937> dimension, class_1934 gamemode, boolean flying, Consumer<EntityPlayerMPFake> consumer) {
        try {
            FAKE_PLAYER_SPAWNING.set(consumer);
            EntityPlayerMPFake.createFake((String)username, (MinecraftServer)server, (class_243)pos, (double)yaw, (double)pitch, dimension, (class_1934)gamemode, (boolean)flying);
        }
        finally {
            FAKE_PLAYER_SPAWNING.remove();
        }
    }

    public static String getExceptionString(Throwable throwable) {
        String name = throwable.getClass().getSimpleName();
        String message = throwable.getMessage();
        return message == null ? name : name + ": " + message;
    }

    public static int getNbtDataVersion() {
        return class_155.method_16673().comp_4026().comp_4038();
    }

    public static void pass(Object ... ignored) {
    }
}

